/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.ProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class DelegatingProgressIndicator
implements ProgressIndicator {
    protected Set<ProgressIndicator> mWrapped = ConcurrentHashMap.newKeySet();

    public DelegatingProgressIndicator(ProgressIndicator wrapped) {
        this.mWrapped.add(wrapped);
    }

    public void addDelegate(ProgressIndicator wrapped) {
        this.mWrapped.add(wrapped);
    }

    @Override
    public void setText(String s) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.setText(s));
    }

    @Override
    public boolean isCanceled() {
        return this.mWrapped.stream().anyMatch(ProgressIndicator::isCanceled);
    }

    @Override
    public void cancel() {
        this.mWrapped.forEach(ProgressIndicator::cancel);
    }

    @Override
    public void setCancellable(boolean cancellable) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.setCancellable(cancellable));
    }

    @Override
    public boolean isCancellable() {
        return this.mWrapped.stream().allMatch(ProgressIndicator::isCancellable);
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.setIndeterminate(indeterminate));
    }

    @Override
    public boolean isIndeterminate() {
        return this.mWrapped.stream().anyMatch(ProgressIndicator::isIndeterminate);
    }

    @Override
    public void setFraction(double v) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.setFraction(v));
    }

    @Override
    public double getFraction() {
        return this.mWrapped.iterator().next().getFraction();
    }

    @Override
    public void setSecondaryText(String s) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.setSecondaryText(s));
    }

    @Override
    public void logWarning(String s) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.logWarning(s));
    }

    @Override
    public void logWarning(String s, Throwable e) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.logWarning(s, e));
    }

    @Override
    public void logError(String s) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.logError(s));
    }

    @Override
    public void logError(String s, Throwable e) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.logError(s, e));
    }

    @Override
    public void logInfo(String s) {
        this.mWrapped.forEach((Consumer<ProgressIndicator> & Serializable)progress -> progress.logInfo(s));
    }

    @VisibleForTesting
    public Set<ProgressIndicator> getDelegates() {
        return this.mWrapped;
    }
}

