/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.Channel;
import com.android.repository.api.DelegatingProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.Repository;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.RemoteRepoLoader;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;

public class RemoteRepoLoaderImpl
implements RemoteRepoLoader {
    private static final int FETCH_PACKAGES_WAITING_ITERATION_SECONDS = 10;
    private static final String FETCH_PACKAGES_WAITING_MESSAGE = "Still waiting for package manifests to be fetched remotely.";
    private final FallbackRemoteRepoLoader mFallback;
    private final Collection<RepositorySourceProvider> mSourceProviders;

    public RemoteRepoLoaderImpl(Collection<RepositorySourceProvider> sources, FallbackRemoteRepoLoader fallback) {
        this.mSourceProviders = sources;
        this.mFallback = fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RemotePackage> fetchPackages(ProgressIndicator progress, Downloader downloader, SettingsController settings) {
        HashMap<RepositorySource, Collection<? extends RemotePackage>> parsedPackages = new HashMap<RepositorySource, Collection<? extends RemotePackage>>();
        HashMap<RepositorySource, Collection<? extends RemotePackage>> legacyParsedPackages = new HashMap<RepositorySource, Collection<? extends RemotePackage>>();
        ArrayList sources = Lists.newArrayList();
        double progressMax = 0.0;
        for (RepositorySourceProvider provider : this.mSourceProviders) {
            sources.addAll(provider.getSources(downloader, progress.createSubProgress(progressMax += 0.1 / (double)this.mSourceProviders.size()), false));
        }
        boolean wasIndeterminate = progress.isIndeterminate();
        progress.setIndeterminate(true);
        LoggingOnlyProgressIndicator loggingOnlyProgress = new LoggingOnlyProgressIndicator(progress);
        ArrayBlockingQueue downloadedRepoManifests = new ArrayBlockingQueue(sources.size());
        ExecutorService sourceThreadPool = Executors.newCachedThreadPool();
        int threadsSubmitted = 0;
        int resultsReceived = 0;
        try {
            for (RepositorySource source : sources) {
                if (!source.isEnabled()) continue;
                ++threadsSubmitted;
                sourceThreadPool.submit((Runnable & Serializable)() -> {
                    String errorMessage = null;
                    Exception error = null;
                    try {
                        InputStream repoStream = downloader.downloadAndStream(new URL(source.getUrl()), loggingOnlyProgress);
                        downloadedRepoManifests.put(new AbstractMap.SimpleImmutableEntry<RepositorySource, InputStream>(source, repoStream));
                    }
                    catch (MalformedURLException e) {
                        errorMessage = "Malformed URL";
                        error = e;
                    }
                    catch (IOException e) {
                        errorMessage = "IO exception while downloading manifest";
                        error = e;
                    }
                    catch (InterruptedException e) {
                        errorMessage = "Thread interrupted while enqueuing downloaded manifest";
                        error = e;
                    }
                    if (errorMessage != null) {
                        source.setFetchError(errorMessage);
                        progress.logWarning(errorMessage, error);
                    }
                });
            }
            sourceThreadPool.shutdown();
            progress.setIndeterminate(false);
            double progressIncrement = 0.9 / (double)(sources.size() * 2);
            while (!sourceThreadPool.isTerminated() && resultsReceived < threadsSubmitted || !downloadedRepoManifests.isEmpty()) {
                Map.Entry repoResult = null;
                try {
                    for (int waitedSeconds = 0; waitedSeconds < 10 && (repoResult = (Map.Entry)downloadedRepoManifests.poll(1L, TimeUnit.SECONDS)) == null && !sourceThreadPool.isTerminated(); ++waitedSeconds) {
                    }
                }
                catch (InterruptedException waitedSeconds) {
                    // empty catch block
                }
                if (repoResult == null) {
                    progress.logWarning(FETCH_PACKAGES_WAITING_MESSAGE);
                    continue;
                }
                ++resultsReceived;
                RepositorySource source = (RepositorySource)repoResult.getKey();
                InputStream repoStream = (InputStream)repoResult.getValue();
                this.parseSource(source, repoStream, downloader, settings, parsedPackages, legacyParsedPackages, progress, progressMax += progressIncrement);
                progress.setFraction(progressMax += progressIncrement);
            }
        }
        finally {
            RemoteRepoLoaderImpl.shutdownAndJoin(sourceThreadPool, progress);
            progress.setIndeterminate(wasIndeterminate);
        }
        HashMap<String, RemotePackage> result = new HashMap<String, RemotePackage>();
        for (RepositorySource source : sources) {
            Collection regularPackages = (Collection)parsedPackages.get(source);
            if (regularPackages == null) continue;
            this.mergePackages(regularPackages, source, settings, result);
        }
        for (RepositorySource source : sources) {
            Collection legacyPackages = (Collection)legacyParsedPackages.get(source);
            if (legacyPackages == null) continue;
            this.mergePackages(legacyPackages, source, settings, result);
        }
        return result;
    }

    private void parseSource(RepositorySource source, InputStream repoStream, Downloader downloader, SettingsController settings, Map<RepositorySource, Collection<? extends RemotePackage>> result, Map<RepositorySource, Collection<? extends RemotePackage>> legacyResult, ProgressIndicator progress, double progressMax) {
        final ArrayList errors = Lists.newArrayList();
        ProgressIndicatorAdapter unmarshalProgress = new ProgressIndicatorAdapter(){

            @Override
            public void logWarning(String s, Throwable e) {
                errors.add(s);
                if (e != null) {
                    errors.add(e.toString());
                }
            }

            @Override
            public void logError(String s, Throwable e) {
                errors.add(s);
                if (e != null) {
                    errors.add(e.toString());
                }
            }
        };
        Repository repo = null;
        try {
            repo = (Repository)SchemaModuleUtil.unmarshal(repoStream, source.getPermittedModules(), true, unmarshalProgress, source.getUrl());
        }
        catch (JAXBException e) {
            errors.add(e.toString());
        }
        Collection<RemotePackage> parsedPackages = null;
        boolean legacy = false;
        if (repo != null) {
            parsedPackages = repo.getRemotePackage();
            progress.setFraction(progressMax);
        } else if (this.mFallback != null) {
            parsedPackages = this.mFallback.parseLegacyXml(source, downloader, settings, progress.createSubProgress(progressMax));
            legacy = true;
        }
        if (parsedPackages != null && !parsedPackages.isEmpty()) {
            (legacy ? legacyResult : result).put(source, parsedPackages);
        } else {
            progress.logWarning("Errors during XML parse:");
            for (String error : errors) {
                progress.logWarning(error);
            }
            if (this.mFallback != null) {
                progress.logWarning("Additionally, the fallback loader failed to parse the XML.");
            }
            source.setFetchError(errors.isEmpty() ? "unknown error" : (String)errors.get(0));
        }
    }

    private void mergePackages(Collection<? extends RemotePackage> packagesFromSource, RepositorySource source, SettingsController settings, Map<String, RemotePackage> result) {
        for (RemotePackage remotePackage : packagesFromSource) {
            Channel settingsChannel;
            RemotePackage existing = result.get(remotePackage.getPath());
            if (existing != null) {
                int compare = existing.getVersion().compareTo(remotePackage.getVersion());
                if (compare > 0) continue;
                if (compare == 0) {
                    try {
                        URL newUrl = new URL(source.getUrl());
                        String newProtocol = newUrl.getProtocol();
                        if (!newProtocol.equals("file")) {
                        }
                    }
                    catch (MalformedURLException ignore) {}
                    continue;
                }
            }
            Channel channel = settingsChannel = settings == null || settings.getChannel() == null ? remotePackage.createFactory().createChannelType(0) : settings.getChannel();
            if (remotePackage.getArchive() != null && remotePackage.getChannel().compareTo(settingsChannel) <= 0) {
                remotePackage.setSource(source);
                result.put(remotePackage.getPath(), remotePackage);
            }
            source.setFetchError(null);
        }
    }

    private static void shutdownAndJoin(ExecutorService threadPool, ProgressIndicator progress) {
        if (threadPool.isTerminated()) {
            return;
        }
        threadPool.shutdown();
        try {
            while (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                progress.logWarning(FETCH_PACKAGES_WAITING_MESSAGE);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class LoggingOnlyProgressIndicator
    extends DelegatingProgressIndicator {
        LoggingOnlyProgressIndicator(ProgressIndicator progress) {
            super(progress);
        }

        @Override
        public void setFraction(double fraction) {
        }

        @Override
        public double getFraction() {
            return 0.0;
        }

        @Override
        public void setText(String text) {
        }

        @Override
        public void setSecondaryText(String text) {
        }

        @Override
        public ProgressIndicator createSubProgress(double max) {
            return this;
        }
    }
}

