/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.jimfs.PathURLConnection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.gradle.internal.classpath.Instrumented;

public final class Handler
extends URLStreamHandler {
    private static final String JAVA_PROTOCOL_HANDLER_PACKAGES = "java.protocol.handler.pkgs";

    static void register() {
        Handler.register(Handler.class);
    }

    static void register(Class<? extends URLStreamHandler> handlerClass) {
        Preconditions.checkArgument((boolean)"Handler".equals(handlerClass.getSimpleName()));
        String pkg = handlerClass.getPackage().getName();
        int lastDot = pkg.lastIndexOf(46);
        Preconditions.checkArgument((lastDot > 0 ? 1 : 0) != 0, (String)"package for Handler (%s) must have a parent package", (Object[])new Object[]{pkg});
        String parentPackage = pkg.substring(0, lastDot);
        String packages = Instrumented.systemProperty((String)JAVA_PROTOCOL_HANDLER_PACKAGES, (String)"com.google.common.jimfs.Handler");
        packages = packages == null ? parentPackage : packages + "|" + parentPackage;
        Instrumented.setSystemProperty((String)JAVA_PROTOCOL_HANDLER_PACKAGES, (String)packages, (String)"com.google.common.jimfs.Handler");
    }

    @Deprecated
    public Handler() {
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new PathURLConnection(url);
    }
}

