/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSReadable;
import org.bouncycastle.cms.CMSTypedData;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;

public class CMSProcessableFile
implements CMSTypedData,
CMSReadable {
    private static final int DEFAULT_BUF_SIZE = 32768;
    private final ASN1ObjectIdentifier type;
    private final File file;
    private final byte[] buf;

    public CMSProcessableFile(File file) {
        this(file, 32768);
    }

    public CMSProcessableFile(File file, int n) {
        this(CMSObjectIdentifiers.data, file, n);
    }

    public CMSProcessableFile(ASN1ObjectIdentifier aSN1ObjectIdentifier, File file, int n) {
        this.type = aSN1ObjectIdentifier;
        this.file = file;
        this.buf = new byte[n];
    }

    public InputStream getInputStream() throws IOException, CMSException {
        File file = this.file;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"org.bouncycastle.cms.CMSProcessableFile");
        return new BufferedInputStream(fileInputStream, 32768);
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        int n;
        File file = this.file;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"org.bouncycastle.cms.CMSProcessableFile");
        FileInputStream fileInputStream2 = fileInputStream;
        while ((n = fileInputStream2.read(this.buf, 0, this.buf.length)) > 0) {
            outputStream.write(this.buf, 0, n);
        }
        fileInputStream2.close();
    }

    public Object getContent() {
        return this.file;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

