/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class ZipReader
implements Closeable {
    private final Path file;
    private FileChannel channel;
    private boolean isOpen;

    ZipReader(Path file) {
        this.file = file;
        this.isOpen = false;
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.channel.close();
    }

    void read(ByteBuffer byteBuffer, long offset) throws IOException {
        this.ensureOpen();
        this.channel.read(byteBuffer, offset);
        byteBuffer.rewind();
    }

    void ensureOpen() throws IOException {
        if (this.isOpen) {
            return;
        }
        this.channel = NioFileInterceptors.intercept_open((Path)this.file, (OpenOption[])new OpenOption[]{StandardOpenOption.READ}, (String)"com.android.zipflinger.ZipReader");
        if (!this.channel.isOpen()) {
            throw new IllegalStateException("Unable to open Channel to " + this.file.toAbsolutePath());
        }
        this.isOpen = true;
    }

    FileChannel getChannel() throws IOException {
        this.ensureOpen();
        return this.channel;
    }
}

