/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public class ZipWriter
implements Closeable {
    private final Path file;
    private FileChannel channel;
    private boolean isOpen;

    public ZipWriter(Path file) {
        this.file = file;
        this.isOpen = false;
    }

    @Deprecated
    public ZipWriter(File file) {
        this(file.toPath());
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.channel.close();
    }

    void truncate(long size) throws IOException {
        this.ensureOpen();
        this.channel.truncate(size);
    }

    void position(long position) throws IOException {
        this.ensureOpen();
        this.channel.position(position);
    }

    long position() throws IOException {
        this.ensureOpen();
        return this.channel.position();
    }

    int write(ByteBuffer buffer, long position) throws IOException {
        this.ensureOpen();
        return this.channel.write(buffer, position);
    }

    public int write(ByteBuffer buffer) throws IOException {
        this.ensureOpen();
        return this.channel.write(buffer);
    }

    public void transferFrom(FileChannel src, long position, long count) throws IOException {
        this.ensureOpen();
        for (long copied = 0L; copied != count; copied += src.transferTo(position + copied, count - copied, this.channel)) {
        }
    }

    public void transferFrom(ReadableByteChannel src, long count) throws IOException {
        long copied;
        this.ensureOpen();
        long position = this.channel.position();
        for (copied = 0L; copied != count; copied += this.channel.transferFrom(src, position + copied, count - copied)) {
        }
        this.channel.position(position + copied);
    }

    private void ensureOpen() throws IOException {
        if (this.isOpen) {
            return;
        }
        this.channel = NioFileInterceptors.intercept_open((Path)this.file, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE}, (String)"com.android.zipflinger.ZipWriter");
        if (!this.channel.isOpen()) {
            throw new IllegalStateException("Unable to open Channel to " + this.file.toAbsolutePath());
        }
        this.isOpen = true;
    }
}

