/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.io.CancellableFileIo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public abstract class FileOp {
    public abstract FileSystem getFileSystem();

    public final void deleteFileOrFolder(File fileOrFolder) {
        if (this.isDirectory(fileOrFolder)) {
            for (File item : this.listFiles(fileOrFolder)) {
                this.deleteFileOrFolder(item);
            }
        }
        this.delete(fileOrFolder);
    }

    public final boolean exists(File file) {
        return CancellableFileIo.exists((Path)this.toPath(file), (LinkOption[])new LinkOption[0]);
    }

    public final boolean isFile(File file) {
        return CancellableFileIo.isRegularFile((Path)this.toPath(file), (LinkOption[])new LinkOption[0]);
    }

    public final boolean isDirectory(File file) {
        return CancellableFileIo.isDirectory((Path)this.toPath(file), (LinkOption[])new LinkOption[0]);
    }

    public final long length(File file) throws IOException {
        return CancellableFileIo.size((Path)this.toPath(file));
    }

    public boolean delete(File file) {
        try {
            Files.delete(this.toPath(file));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public final boolean mkdirs(File file) {
        try {
            Files.createDirectories(this.toPath(file), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public final File[] listFiles(File file) {
        File[] fileArray;
        block8: {
            Stream children = CancellableFileIo.list((Path)this.toPath(file));
            try {
                fileArray = (File[])children.map((Function<Path, File> & Serializable)path -> new File(path.toString())).toArray((IntFunction<A[]>)((IntFunction<File[]> & Serializable)(File[]::new)));
                if (children == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (children != null) {
                        try {
                            children.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new File[0];
                }
            }
            children.close();
        }
        return fileArray;
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return this.newFileOutputStream(file, false);
    }

    public OutputStream newFileOutputStream(File file, boolean append) throws IOException {
        if (append) {
            return Files.newOutputStream(this.toPath(file), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(this.toPath(file), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public final InputStream newFileInputStream(File file) throws IOException {
        return this.newFileInputStream(this.toPath(file));
    }

    public final InputStream newFileInputStream(Path path) throws IOException {
        return CancellableFileIo.newInputStream((Path)path, (OpenOption[])new OpenOption[0]);
    }

    public final long lastModified(File file) {
        try {
            return CancellableFileIo.getLastModifiedTime((Path)this.toPath(file), (LinkOption[])new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public final String readText(File f) throws IOException {
        return CancellableFileIo.readString((Path)this.toPath(f));
    }

    public final boolean setLastModified(Path file, long time) throws IOException {
        Files.setLastModifiedTime(file, FileTime.fromMillis(time));
        return true;
    }

    public Path toPath(File file) {
        return this.toPath(file.getPath());
    }

    public Path toPath(String path) {
        return this.getFileSystem().getPath(path, new String[0]);
    }
}

