/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal.archives;

import com.android.repository.Revision;
import com.android.sdklib.repository.legacy.remote.internal.archives.BitSize;
import com.android.sdklib.repository.legacy.remote.internal.archives.HostOs;
import com.google.common.base.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.classpath.Instrumented;

@Deprecated
public class ArchFilter {
    private static final String OS_OVERRIDE_ENV_VAR = "REPO_OS_OVERRIDE";
    private static final String PROP_HOST_OS = "Archive.HostOs";
    private static final String PROP_HOST_BITS = "Archive.HostBits";
    private static final String PROP_JVM_BITS = "Archive.JvmBits";
    private static final String PROP_MIN_JVM_VERSION = "Archive.MinJvmVers";
    public static final String LEGACY_PROP_OS = "Archive.Os";
    public static final String LEGACY_PROP_ARCH = "Archive.Arch";
    private final HostOs mHostOs;
    private final BitSize mHostBits;
    private final BitSize mJvmBits;
    private final Revision mMinJvmVersion;

    public ArchFilter(HostOs hostOs, BitSize hostBits, BitSize jvmBits, Revision minJvmVersion) {
        this.mHostOs = hostOs;
        this.mHostBits = hostBits;
        this.mJvmBits = jvmBits;
        this.mMinJvmVersion = minJvmVersion;
    }

    public ArchFilter(Properties props) {
        HostOs hostOs = null;
        BitSize hostBits = null;
        BitSize jvmBits = null;
        Revision minJvmVers = null;
        if (props != null) {
            hostOs = HostOs.fromXmlName(props.getProperty(PROP_HOST_OS));
            hostBits = BitSize.fromXmlName(props.getProperty(PROP_HOST_BITS));
            jvmBits = BitSize.fromXmlName(props.getProperty(PROP_JVM_BITS));
            try {
                minJvmVers = Revision.parseRevision((String)props.getProperty(PROP_MIN_JVM_VERSION));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!props.containsKey(PROP_HOST_OS) && props.containsKey(LEGACY_PROP_OS)) {
                hostOs = HostOs.fromXmlName(props.getProperty(LEGACY_PROP_OS));
            }
            if (!props.containsKey(PROP_HOST_BITS) && props.containsKey(LEGACY_PROP_ARCH)) {
                String v = props.getProperty(LEGACY_PROP_ARCH).toLowerCase();
                if (v.indexOf("x86_64") > 0) {
                    hostBits = jvmBits = BitSize._64;
                } else if (v.indexOf("x86") > 0) {
                    jvmBits = BitSize._32;
                }
            }
        }
        this.mHostOs = hostOs;
        this.mHostBits = hostBits;
        this.mJvmBits = jvmBits;
        this.mMinJvmVersion = minJvmVers;
    }

    public HostOs getHostOS() {
        return this.mHostOs;
    }

    public BitSize getHostBits() {
        return this.mHostBits;
    }

    public BitSize getJvmBits() {
        return this.mJvmBits;
    }

    public Revision getMinJvmVersion() {
        return this.mMinJvmVersion;
    }

    public boolean isCompatibleWith(ArchFilter required) {
        if (this.mHostOs != null && required.mHostOs != null && !this.mHostOs.equals((Object)required.mHostOs)) {
            return false;
        }
        if (this.mHostBits != null && required.mHostBits != null && !this.mHostBits.equals((Object)required.mHostBits)) {
            return false;
        }
        if (this.mJvmBits != null && required.mJvmBits != null && !this.mJvmBits.equals((Object)required.mJvmBits)) {
            return false;
        }
        return this.mMinJvmVersion == null || required.mMinJvmVersion == null || this.mMinJvmVersion.compareTo(required.mMinJvmVersion) <= 0;
    }

    public static ArchFilter getCurrent() {
        String os = Instrumented.getenv((String)OS_OVERRIDE_ENV_VAR, (String)"com.android.sdklib.repository.legacy.remote.internal.archives.ArchFilter");
        if (os == null) {
            os = Instrumented.systemProperty((String)"os.name", (String)"com.android.sdklib.repository.legacy.remote.internal.archives.ArchFilter");
        }
        HostOs hostOS = null;
        if (os.startsWith("Mac")) {
            hostOS = HostOs.MACOSX;
        } else if (os.startsWith("Windows")) {
            hostOS = HostOs.WINDOWS;
        } else if (os.startsWith("Linux")) {
            hostOS = HostOs.LINUX;
        }
        String arch = Instrumented.systemProperty((String)"os.arch", (String)"com.android.sdklib.repository.legacy.remote.internal.archives.ArchFilter");
        BitSize jvmBits = arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("ia64") || arch.equalsIgnoreCase("amd64") ? BitSize._64 : BitSize._32;
        BitSize hostBits = jvmBits;
        Revision minJvmVersion = null;
        String javav = Instrumented.systemProperty((String)"java.version", (String)"com.android.sdklib.repository.legacy.remote.internal.archives.ArchFilter");
        Pattern p = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
        Matcher m = p.matcher(javav);
        if (m.matches()) {
            minJvmVersion = Revision.parseRevision((String)m.group(1));
        }
        return new ArchFilter(hostOS, hostBits, jvmBits, minJvmVersion);
    }

    void saveProperties(Properties props) {
        if (this.mHostOs != null) {
            props.setProperty(PROP_HOST_OS, this.mHostOs.getXmlName());
        }
        if (this.mHostBits != null) {
            props.setProperty(PROP_HOST_BITS, this.mHostBits.getXmlName());
        }
        if (this.mJvmBits != null) {
            props.setProperty(PROP_JVM_BITS, this.mJvmBits.getXmlName());
        }
        if (this.mMinJvmVersion != null) {
            props.setProperty(PROP_MIN_JVM_VERSION, this.mMinJvmVersion.toShortString());
        }
    }

    public String toString() {
        return "<ArchFilter mHostOs=" + this.mHostOs + ", mHostBits=" + this.mHostBits + ", mJvmBits=" + this.mJvmBits + ", mMinJvmVersion=" + this.mMinJvmVersion + ">";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mHostOs, this.mHostBits, this.mJvmBits, this.mMinJvmVersion});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArchFilter)) {
            return false;
        }
        ArchFilter other = (ArchFilter)obj;
        return this.mHostBits == other.mHostBits && this.mHostOs == other.mHostOs && this.mJvmBits == other.mJvmBits && Objects.equal((Object)this.mMinJvmVersion, (Object)other.mMinJvmVersion);
    }
}

