/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal.sources;

import com.android.io.NonClosingInputStream;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.sdklib.repository.legacy.remote.RemotePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.PlatformToolRemotePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteAddonPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteBuildToolPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteDocPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteExtraPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteLLDBPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteNdkPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemotePlatformPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteSamplePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteSourcePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteSystemImagePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.packages.RemoteToolPkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.sources.SdkSourceProperties;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Deprecated
public abstract class SdkSource
implements Comparable<SdkSource> {
    private String mUrl;
    private RemotePkgInfo[] mPackages;
    private String mFetchError;
    private final String mUiName;
    private static final SdkSourceProperties sSourcesProps = new SdkSourceProperties();

    public SdkSource(String url, String uiName) {
        String[] names;
        if (url == null) {
            url = "";
        }
        if (((String)(url = ((String)url).trim())).endsWith("/") && (names = this.getDefaultXmlFileUrls()).length > 0) {
            url = (String)url + names[0];
        }
        if (uiName == null) {
            uiName = sSourcesProps.getProperty("@name@", (String)url, null);
        } else {
            sSourcesProps.setProperty("@name@", (String)url, uiName);
        }
        this.mUrl = url;
        this.mUiName = uiName;
    }

    public abstract boolean isAddonSource();

    public abstract boolean isSysImgSource();

    protected abstract String[] getDefaultXmlFileUrls();

    protected abstract int getNsLatestVersion();

    protected abstract String getNsUri();

    protected abstract String getNsPattern();

    protected abstract String getSchemaUri(int var1);

    protected abstract String getRootElementName();

    protected abstract StreamSource[] getXsdStream(int var1);

    protected abstract Document findAlternateToolsXml(InputStream var1) throws IOException;

    public boolean equals(Object obj) {
        if (obj instanceof SdkSource) {
            SdkSource rs = (SdkSource)obj;
            return rs.getUrl().equals(this.getUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.mUrl.hashCode();
    }

    @Override
    public int compareTo(SdkSource rhs) {
        return this.getUrl().compareTo(rhs.getUrl());
    }

    public String getUrl() {
        return this.mUrl;
    }

    public RemotePkgInfo[] getPackages() {
        return this.mPackages;
    }

    @VisibleForTesting
    protected void setPackages(RemotePkgInfo[] packages) {
        this.mPackages = packages;
        if (this.mPackages != null) {
            Arrays.sort(this.mPackages, null);
        }
    }

    public void clearPackages() {
        this.setPackages(null);
    }

    public boolean isEnabled() {
        return sSourcesProps.getProperty("@disabled@", this.mUrl, null) == null;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.clearPackages();
            sSourcesProps.setProperty("@disabled@", this.mUrl, enabled ? null : "disabled");
        }
    }

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    public String getShortDescription() {
        if (this.mUiName != null && !this.mUiName.isEmpty()) {
            String host = "malformed URL";
            try {
                URL u = new URL(this.mUrl);
                host = u.getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return String.format("%1$s (%2$s)", this.mUiName, host);
        }
        return this.mUrl;
    }

    public String getFetchError() {
        return this.mFetchError;
    }

    public void load(Downloader downloader, SettingsController settings, ProgressIndicator progress) {
        int version;
        if (!this.isEnabled()) {
            this.setPackages(new RemotePkgInfo[0]);
            progress.setFraction(1.0);
            return;
        }
        Object url = this.mUrl;
        if (settings != null && settings.getForceHttp()) {
            url = ((String)url).replaceAll("https://", "http://");
        }
        progress.setSecondaryText("Fetching URL: " + (String)url);
        progress.setFraction(0.14285714285714285);
        this.mFetchError = null;
        Boolean[] validatorFound = new Boolean[]{Boolean.FALSE};
        String[] validationError = new String[]{null};
        Exception[] exception = new Exception[]{null};
        Document validatedDoc = null;
        boolean usingAlternateXml = false;
        boolean usingAlternateUrl = false;
        String validatedUri = null;
        String[] defaultNames = this.getDefaultXmlFileUrls();
        String firstDefaultName = defaultNames.length > 0 ? defaultNames[0] : "";
        InputStream xml = this.fetchXmlUrl((String)url, downloader, progress.createSubProgress(0.2857142857142857), exception);
        if (xml != null && (version = this.getXmlSchemaVersion(xml)) == 0) {
            this.closeStream(xml);
            xml = null;
        }
        if (xml == null && defaultNames.length > 0) {
            int pos;
            ProgressIndicator subProgress = progress.createSubProgress(0.42857142857142855);
            Object baseUrl = url;
            if (!((String)baseUrl).endsWith("/") && (pos = ((String)baseUrl).lastIndexOf(47)) > 0) {
                baseUrl = ((String)baseUrl).substring(0, pos + 1);
            }
            double nameProgress = 0.0;
            for (String name : defaultNames) {
                String newUrl = (String)baseUrl + name;
                if (newUrl.equals(url) || (xml = this.fetchXmlUrl(newUrl, downloader, subProgress.createSubProgress(nameProgress + 1.0 / (double)defaultNames.length), exception)) == null) continue;
                int version2 = this.getXmlSchemaVersion(xml);
                if (version2 == 0) {
                    this.closeStream(xml);
                    xml = null;
                    continue;
                }
                url = newUrl;
                subProgress.setFraction(1.0);
                break;
            }
        } else {
            progress.setFraction(0.42857142857142855);
        }
        if (xml == null && !((String)url).endsWith(firstDefaultName)) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + firstDefaultName;
            xml = this.fetchXmlUrl((String)url, downloader, progress.createSubProgress(0.5714285714285714), exception);
            usingAlternateUrl = true;
        } else {
            progress.setFraction(0.5714285714285714);
        }
        if (xml != null) {
            progress.setSecondaryText("Validate XML: " + (String)url);
            ProgressIndicator subProgress = progress.createSubProgress(0.7142857142857143);
            for (int tryOtherUrl = 0; tryOtherUrl < 2; ++tryOtherUrl) {
                int version3 = this.getXmlSchemaVersion(xml);
                if (version3 >= 1 && version3 <= this.getNsLatestVersion()) {
                    String uri = this.validateXml(xml, (String)url, version3, validationError, validatorFound);
                    if (uri != null) {
                        validatedDoc = this.getDocument(xml, progress);
                        validatedUri = uri;
                        if (!usingAlternateUrl || validatedDoc == null) break;
                        progress.logInfo("Repository found at " + (String)url);
                        this.mUrl = url;
                        break;
                    }
                    if (!validatorFound[0].equals(Boolean.FALSE)) break;
                    this.mFetchError = validationError[0];
                    break;
                }
                if (version3 > this.getNsLatestVersion()) {
                    try {
                        validatedDoc = this.findAlternateToolsXml(xml);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (validatedDoc == null) break;
                    validationError[0] = null;
                    validatedUri = this.getNsUri();
                    usingAlternateXml = true;
                    break;
                }
                if (version3 < 1 && tryOtherUrl == 0 && !usingAlternateUrl) {
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", url);
                    if (((String)url).endsWith(firstDefaultName)) break;
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    url = (String)url + firstDefaultName;
                    this.closeStream(xml);
                    xml = this.fetchXmlUrl((String)url, downloader, subProgress, null);
                    if (xml == null) break;
                } else {
                    if (version3 >= 1 || !usingAlternateUrl || this.mFetchError != null) break;
                    this.mFetchError = String.format("Failed to validate the XML for the repository at URL '%1$s'", url);
                    break;
                }
                usingAlternateUrl = true;
            }
        }
        if (exception[0] != null) {
            this.mFetchError = "Failed to fetch URL";
            Object reason = null;
            if (exception[0] instanceof FileNotFoundException) {
                reason = "File not found";
                this.mFetchError = this.mFetchError + ": " + (String)reason;
            } else if (exception[0] instanceof SSLKeyException) {
                reason = "HTTPS SSL error. You might want to force download through HTTP in the settings.";
                this.mFetchError = this.mFetchError + ": HTTPS SSL error";
            } else {
                reason = exception[0].getMessage() != null ? exception[0].getClass().getSimpleName().replace("Exception", "") + " " + exception[0].getMessage() : exception[0].toString();
            }
            progress.logWarning(String.format("Failed to fetch URL %1$s, reason: %2$s", url, reason));
        }
        if (validationError[0] != null) {
            progress.logError(validationError[0]);
        }
        if (validatedDoc == null) {
            return;
        }
        if (usingAlternateXml) {
            boolean isADT = false;
            try {
                Class<?> adt = Class.forName("com.android.ide.eclipse.adt.AdtPlugin");
                isADT = adt != null;
            }
            catch (ClassNotFoundException adt) {
                // empty catch block
            }
            String info = isADT ? "This repository requires a more recent version of ADT. Please update the Eclipse Android plugin." : "This repository requires a more recent version of the Tools. Please update.";
            this.mFetchError = this.mFetchError == null ? info : this.mFetchError + ". " + info;
        }
        progress.setFraction(0.8571428571428571);
        if (xml != null) {
            progress.setSecondaryText("Parse XML:    " + (String)url);
            this.parsePackages(validatedDoc, validatedUri, progress);
        }
        progress.setFraction(1.0);
        this.closeStream(xml);
    }

    private InputStream fetchXmlUrl(String urlString, Downloader downloader, ProgressIndicator progress, Exception[] outException) {
        try {
            Path downloaded = downloader.downloadFully(new URL(urlString), progress);
            BufferedInputStream xml = null;
            if (downloaded != null) {
                xml = new BufferedInputStream(NioFileInterceptors.intercept_newInputStream((Path)downloaded, (OpenOption[])new OpenOption[0], (String)"com.android.sdklib.repository.legacy.remote.internal.sources.SdkSource"));
                ((InputStream)xml).mark(500000);
                xml = new NonClosingInputStream((InputStream)xml);
                ((NonClosingInputStream)xml).setCloseBehavior(NonClosingInputStream.CloseBehavior.RESET);
            }
            return xml;
        }
        catch (Exception e) {
            if (outException != null) {
                outException[0] = e;
            }
            return null;
        }
    }

    private void closeStream(InputStream is) {
        if (is != null) {
            if (is instanceof NonClosingInputStream) {
                ((NonClosingInputStream)is).setCloseBehavior(NonClosingInputStream.CloseBehavior.CLOSE);
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    protected String validateXml(InputStream xml, String url, int version, String[] outError, Boolean[] validatorFound) {
        if (xml == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(version);
            if (validator == null) {
                validatorFound[0] = Boolean.FALSE;
                outError[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", url);
                return null;
            }
            validatorFound[0] = Boolean.TRUE;
            assert (xml.markSupported());
            xml.reset();
            validator.validate(new StreamSource(xml));
            return this.getSchemaUri(version);
        }
        catch (SAXParseException e) {
            outError[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", url, e.getLineNumber(), e.getColumnNumber(), e.toString());
        }
        catch (Exception e) {
            outError[0] = String.format("XML verification failed for %1$s.\nError: %2$s", url, e.toString());
        }
        return null;
    }

    @VisibleForTesting
    protected int getXmlSchemaVersion(InputStream xml) {
        if (xml == null) {
            return 0;
        }
        Node doc = null;
        try {
            assert (xml.markSupported());
            xml.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            doc = builder.parse(xml);
            factory.setNamespaceAware(true);
        }
        catch (Exception factory) {
            // empty catch block
        }
        if (doc == null) {
            return 0;
        }
        Pattern nsPattern = Pattern.compile(this.getNsPattern());
        String prefix = null;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            Matcher m;
            String uri;
            Node attr;
            if (child.getNodeType() != 1) continue;
            prefix = null;
            String name = child.getNodeName();
            int pos = name.indexOf(58);
            if (pos > 0 && pos < name.length() - 1) {
                prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
            }
            if (!this.getRootElementName().equals(name)) continue;
            NamedNodeMap attrs = child.getAttributes();
            Object xmlns = "xmlns";
            if (prefix != null) {
                xmlns = (String)xmlns + ":" + prefix;
            }
            if ((attr = attrs.getNamedItem((String)xmlns)) == null || (uri = attr.getNodeValue()) == null || !(m = nsPattern.matcher(uri)).matches()) continue;
            String version = m.group(1);
            try {
                return Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    private Validator getValidator(int version) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (factory == null) {
            return null;
        }
        Source[] xsdStreams = this.getXsdStream(version);
        Schema schema = factory.newSchema(xsdStreams);
        Validator validator = schema == null ? null : schema.newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return validator;
    }

    @VisibleForTesting
    protected boolean parsePackages(Document doc, String nsUri, ProgressIndicator progress) {
        Node root = this.getFirstChild(doc, nsUri, this.getRootElementName());
        if (root != null) {
            Node child;
            ArrayList<RemoteAddonPkgInfo> packages = new ArrayList<RemoteAddonPkgInfo>();
            HashMap<String, String> licenses = new HashMap<String, String>();
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                Node id;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !child.getLocalName().equals("license") || (id = child.getAttributes().getNamedItem("id")) == null) continue;
                licenses.put(id.getNodeValue(), child.getTextContent());
            }
            for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI())) continue;
                String name = child.getLocalName();
                RemotePkgInfo p = null;
                try {
                    if ("add-on".equals(name)) {
                        p = new RemoteAddonPkgInfo(this, child, nsUri, licenses);
                    } else if ("extra".equals(name)) {
                        p = new RemoteExtraPkgInfo(this, child, nsUri, licenses);
                    } else if (!this.isAddonSource()) {
                        if ("platform".equals(name)) {
                            p = new RemotePlatformPkgInfo(this, child, nsUri, licenses);
                        } else if ("doc".equals(name)) {
                            p = new RemoteDocPkgInfo(this, child, nsUri, licenses);
                        } else if ("tool".equals(name)) {
                            p = new RemoteToolPkgInfo(this, child, nsUri, licenses);
                        } else if ("platform-tool".equals(name)) {
                            p = new PlatformToolRemotePkgInfo(this, child, nsUri, licenses);
                        } else if ("build-tool".equals(name)) {
                            p = new RemoteBuildToolPkgInfo(this, child, nsUri, licenses);
                        } else if ("sample".equals(name)) {
                            p = new RemoteSamplePkgInfo(this, child, nsUri, licenses);
                        } else if ("system-image".equals(name)) {
                            p = new RemoteSystemImagePkgInfo(this, child, nsUri, licenses);
                        } else if ("source".equals(name)) {
                            p = new RemoteSourcePkgInfo(this, child, nsUri, licenses);
                        } else if ("ndk".equals(name)) {
                            p = new RemoteNdkPkgInfo(this, child, nsUri, licenses);
                        } else if ("lldb".equals(name)) {
                            p = new RemoteLLDBPkgInfo(this, child, nsUri, licenses);
                        }
                    }
                    if (p == null) continue;
                    packages.add((RemoteAddonPkgInfo)p);
                    progress.logVerbose("Found " + p.getShortDescription());
                    continue;
                }
                catch (Exception e) {
                    String msg = String.format("Ignoring invalid %1$s element: %2$s", name, e.toString());
                    progress.logError(msg);
                }
            }
            this.setPackages(packages.toArray(new RemotePkgInfo[0]));
            return true;
        }
        return false;
    }

    private Node getFirstChild(Node node, String nsUri, String xmlLocalName) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || xmlLocalName != null && !child.getLocalName().equals(xmlLocalName)) continue;
            return child;
        }
        return null;
    }

    @VisibleForTesting
    protected Document getDocument(InputStream xml, ProgressIndicator progress) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            assert (xml.markSupported());
            xml.reset();
            Document doc = builder.parse(new InputSource(xml));
            return doc;
        }
        catch (ParserConfigurationException e) {
            progress.logError("Failed to create XML document builder");
        }
        catch (SAXException e) {
            progress.logError("Failed to parse XML document");
        }
        catch (IOException e) {
            progress.logError("Failed to read XML document");
        }
        return null;
    }
}

