/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public class TableFormatter<T> {
    private final List<Column<T>> mColumns = new ArrayList<Column<T>>();

    public void addColumn(String title, Function<T, String> valueGetter, int prefixLimit, int suffixLimit) {
        this.mColumns.add(new Column<T>(title, valueGetter, prefixLimit, suffixLimit));
    }

    public void print(Collection<T> values, PrintStream out) {
        assert (!this.mColumns.isEmpty());
        String separator = "-------";
        Map maxLengths = this.mColumns.stream().collect(Collectors.toMap(Function.identity(), (Function<Column, Integer> & Serializable)column -> Math.max(values.stream().mapToInt((ToIntFunction<Object> & Serializable)value -> column.getValue(value).length()).map((IntUnaryOperator & Serializable)length -> Math.min(length, column.getMaxLength())).max().orElse(0), Math.max(separator.length(), column.getTitle().length()))));
        String pattern = "  " + String.join((CharSequence)" | ", this.mColumns.stream().map(maxLengths::get).map((Function<Integer, String> & Serializable)max -> String.format("%%-%ds", max)).collect(Collectors.toList())) + "\n";
        out.printf(pattern, this.mColumns.stream().map(Column::getTitle).toArray());
        out.printf(pattern, this.mColumns.stream().map((Function<Column, String> & Serializable)column -> separator).toArray());
        values.forEach((Consumer<Object> & Serializable)value -> out.printf(pattern, this.mColumns.stream().map((Function<Column, String> & Serializable)column -> column.getValue(value)).toArray()));
    }

    private static class Column<T> {
        private final String mTitle;
        private final Function<T, String> mValueGetter;
        private final int mPrefixLimit;
        private final int mSuffixLimit;

        public Column(String title, Function<T, String> valueGetter, int prefixLimit, int suffixLimit) {
            this.mTitle = title;
            this.mValueGetter = valueGetter;
            this.mPrefixLimit = prefixLimit;
            this.mSuffixLimit = suffixLimit;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public int getMaxLength() {
            return this.mPrefixLimit + this.mSuffixLimit + 3;
        }

        public String getValue(T input) {
            Object value = this.mValueGetter.apply(input);
            if (((String)value).length() > this.getMaxLength()) {
                value = ((String)value).substring(0, this.mPrefixLimit) + "..." + ((String)value).substring(((String)value).length() - this.mSuffixLimit);
            }
            return value;
        }
    }
}

