/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.archive.ArchivedSplashScreenLayout;
import com.android.tools.build.bundletool.io.ResourceReader;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;

public final class ArchivedResourcesHelper {
    public static final String APP_STORE_PACKAGE_NAME_RESOURCE_NAME = "reactivation_app_store_package_name";
    public static final String PLAY_STORE_PACKAGE_NAME = "com.android.vending";
    public static final String OPACITY_LAYER_DRAWABLE_NAME = "com_android_vending_archive_icon_opacity_layer";
    public static final String CLOUD_SYMBOL_DRAWABLE_NAME = "com_android_vending_archive_icon_cloud_symbol";
    public static final String ARCHIVED_ICON_DRAWABLE_NAME = "com_android_vending_archive_application_icon";
    public static final String ARCHIVED_ROUND_ICON_DRAWABLE_NAME = "com_android_vending_archive_application_round_icon";
    public static final String ARCHIVED_SPLASH_SCREEN_LAYOUT_NAME = "com_android_vending_archive_splash_screen_layout";
    public static final String ARCHIVED_TV_THEME_NAME = "com_android_vending_archive_tv_theme";
    public static final String ARCHIVED_CLASSES_DEX_PATH_PREFIX = "/com/android/tools/build/bundletool/archive/dex";
    private static final String ARCHIVED_CLASSES_DEX_PATH_SUFFIX = "classes.dex";
    public static final String CLOUD_SYMBOL_PATH = "/com/android/tools/build/bundletool/archive/drawable/cloud_symbol_xml.pb";
    public static final String OPACITY_LAYER_PATH = "/com/android/tools/build/bundletool/archive/drawable/opacity_layer_xml.pb";
    private static final Logger logger = Logger.getLogger(ArchivedResourcesHelper.class.getName());
    private final ResourceReader resourceReader;

    public ArchivedResourcesHelper(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    public String findArchivedClassesDexPath(Version bundleToolVersion, boolean transparencyEnabled) throws IOException {
        try {
            ImmutableList<Path> allResources = this.resourceReader.listResourceFilesInFolder(ARCHIVED_CLASSES_DEX_PATH_PREFIX);
            ImmutableList availableVersions = (ImmutableList)allResources.stream().map((Function<Path, String> & Serializable)dir -> dir.getFileName().toString().replace('_', '.')).map(Version::of).sorted(Comparator.reverseOrder()).collect(ImmutableList.toImmutableList());
            Preconditions.checkState((!availableVersions.isEmpty() ? 1 : 0) != 0, (Object)"Archived DEXes are not present in bundletool JAR.");
            Optional<Version> resultVersion = transparencyEnabled ? availableVersions.stream().filter((Predicate<Version> & Serializable)version -> version.compareTo(bundleToolVersion) <= 0).findFirst() : Optional.of((Version)availableVersions.get(0));
            Preconditions.checkState((boolean)resultVersion.isPresent(), (String)"Not found the appropriate version of DEX file for bundletool version: %s", (Object)bundleToolVersion.toString());
            return ArchivedResourcesHelper.getArchivedClassesDexPath(resultVersion.get());
        }
        catch (URISyntaxException e11) {
            logger.warning("Exception occurred while finding the right archived classes.dex file: " + e11);
            throw InvalidBundleException.builder().withUserMessage("Failed to find a DEX file for an archived APK").build();
        }
    }

    public static String getArchivedClassesDexPath(Version version) {
        return String.format("%s/%s/%s", ARCHIVED_CLASSES_DEX_PATH_PREFIX, version.toString().replace('.', '_'), ARCHIVED_CLASSES_DEX_PATH_SUFFIX);
    }

    public static ImmutableMap<String, Integer> injectExtraResources(ResourceInjector resourceInjector, Optional<String> customAppStorePackageName, Optional<XmlProtoAttribute> iconAttribute, Optional<XmlProtoAttribute> roundIconAttribute) {
        ImmutableMap.Builder resourceNameToIdMapBuilder = ImmutableMap.builder().put((Object)APP_STORE_PACKAGE_NAME_RESOURCE_NAME, (Object)resourceInjector.addStringResource(APP_STORE_PACKAGE_NAME_RESOURCE_NAME, ArchivedResourcesHelper.getAppStorePackageName(customAppStorePackageName)).getFullResourceId()).put((Object)OPACITY_LAYER_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(OPACITY_LAYER_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", OPACITY_LAYER_DRAWABLE_NAME)).toString()).getFullResourceId()).put((Object)CLOUD_SYMBOL_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(CLOUD_SYMBOL_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", CLOUD_SYMBOL_DRAWABLE_NAME)).toString()).getFullResourceId()).put((Object)ARCHIVED_TV_THEME_NAME, (Object)resourceInjector.addStyleResource(ARCHIVED_TV_THEME_NAME, ArchivedResourcesHelper.buildArchivedTvActivityTheme()).getFullResourceId());
        iconAttribute.ifPresent((Consumer<XmlProtoAttribute> & Serializable)attribute -> {
            resourceNameToIdMapBuilder.put((Object)ARCHIVED_ICON_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(ARCHIVED_ICON_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ICON_DRAWABLE_NAME)).toString()).getFullResourceId());
            resourceNameToIdMapBuilder.put((Object)ARCHIVED_SPLASH_SCREEN_LAYOUT_NAME, (Object)resourceInjector.addLayoutResource(ARCHIVED_SPLASH_SCREEN_LAYOUT_NAME, BundleModule.RESOURCES_DIRECTORY.resolve(String.format("layout/%s.xml", ARCHIVED_SPLASH_SCREEN_LAYOUT_NAME)).toString()).getFullResourceId());
        });
        roundIconAttribute.ifPresent((Consumer<XmlProtoAttribute> & Serializable)attribute -> resourceNameToIdMapBuilder.put((Object)ARCHIVED_ROUND_ICON_DRAWABLE_NAME, (Object)resourceInjector.addXmlDrawableResource(ARCHIVED_ROUND_ICON_DRAWABLE_NAME, BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ROUND_ICON_DRAWABLE_NAME)).toString()).getFullResourceId()));
        return resourceNameToIdMapBuilder.build();
    }

    public ImmutableMap<ZipPath, ByteSource> buildAdditionalResourcesByByteSourceMap(int cloudResourceId, int opacityLayerResourceId, Optional<XmlProtoAttribute> iconAttribute, Optional<XmlProtoAttribute> roundIconAttribute, String archivedClassesDexPath) throws IOException {
        ImmutableMap.Builder additionalResourcesByDestinationPathBuilder = new ImmutableMap.Builder().put((Object)BundleModule.DEX_DIRECTORY.resolve(ARCHIVED_CLASSES_DEX_PATH_SUFFIX), (Object)this.resourceReader.getResourceByteSource(archivedClassesDexPath)).put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", OPACITY_LAYER_DRAWABLE_NAME)), (Object)this.resourceReader.getResourceByteSource(OPACITY_LAYER_PATH)).put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", CLOUD_SYMBOL_DRAWABLE_NAME)), (Object)this.resourceReader.getResourceByteSource(CLOUD_SYMBOL_PATH));
        if (iconAttribute.isPresent()) {
            additionalResourcesByDestinationPathBuilder.put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ICON_DRAWABLE_NAME)), (Object)ByteSource.wrap((byte[])ArchivedResourcesHelper.buildArchiveIconXmlNode(cloudResourceId, opacityLayerResourceId, iconAttribute.get().getValueAsRefId()).getProto().toByteArray()));
        }
        if (roundIconAttribute.isPresent()) {
            additionalResourcesByDestinationPathBuilder.put((Object)BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", ARCHIVED_ROUND_ICON_DRAWABLE_NAME)), (Object)ByteSource.wrap((byte[])ArchivedResourcesHelper.buildArchiveIconXmlNode(cloudResourceId, opacityLayerResourceId, roundIconAttribute.get().getValueAsRefId()).getProto().toByteArray()));
        }
        if (roundIconAttribute.isPresent() || iconAttribute.isPresent()) {
            int iconResId = iconAttribute.isPresent() ? iconAttribute.get().getValueAsRefId() : roundIconAttribute.get().getValueAsRefId();
            XmlProtoNode node = ArchivedResourcesHelper.buildFrameLayoutXmlNode(iconResId);
            additionalResourcesByDestinationPathBuilder.put((Object)BundleModule.RESOURCES_DIRECTORY.resolve(String.format("layout/%s.xml", ARCHIVED_SPLASH_SCREEN_LAYOUT_NAME)), (Object)ByteSource.wrap((byte[])node.getProto().toByteArray()));
        }
        return additionalResourcesByDestinationPathBuilder.build();
    }

    private static XmlProtoNode buildArchiveIconXmlNode(int cloudResourceId, int opacityLayerResourceId, int iconReferenceId) {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("layer-list").addNamespaceDeclaration("android", "http://schemas.android.com/apk/res/android").addChildElement(XmlProtoElementBuilder.create("item").addAttribute(ArchivedResourcesHelper.createDrawableAttribute(iconReferenceId))).addChildElement(XmlProtoElementBuilder.create("item").addAttribute(ArchivedResourcesHelper.createDrawableAttribute(opacityLayerResourceId))).addChildElement(XmlProtoElementBuilder.create("item").addAttribute(ArchivedResourcesHelper.createDrawableAttribute(cloudResourceId))).build());
    }

    private static XmlProtoNode buildFrameLayoutXmlNode(int imageResId) {
        return XmlProtoNode.createElementNode(ArchivedSplashScreenLayout.builder().setLayoutWidth(-1).setLayoutHeight(-1).setAnimateLayoutChanges(false).setFitsSystemWindows(false).setImageResourceId(imageResId).build().asXmlProtoElement());
    }

    private static Resources.Style buildArchivedTvActivityTheme() {
        return Resources.Style.newBuilder().setParent(Resources.Reference.newBuilder().setId(16974065)).addEntry(ArchivedResourcesHelper.createStyleEntryBuilder(16842840, (Consumer<Resources.Item.Builder> & Serializable)item -> item.setPrim(Resources.Primitive.newBuilder().setBooleanValue(true)))).addEntry(ArchivedResourcesHelper.createStyleEntryBuilder(16842836, (Consumer<Resources.Item.Builder> & Serializable)item -> item.setRef(Resources.Reference.newBuilder().setId(17301673)))).addEntry(ArchivedResourcesHelper.createStyleEntryBuilder(16843295, (Consumer<Resources.Item.Builder> & Serializable)item -> item.setPrim(Resources.Primitive.newBuilder().setBooleanValue(true)))).build();
    }

    private static Resources.Style.Entry.Builder createStyleEntryBuilder(int resourceId, Consumer<Resources.Item.Builder> itemConsumer) {
        Resources.Item.Builder itemBuilder = Resources.Item.newBuilder();
        itemConsumer.accept(itemBuilder);
        return Resources.Style.Entry.newBuilder().setKey(Resources.Reference.newBuilder().setId(resourceId)).setItem(itemBuilder);
    }

    private static XmlProtoAttributeBuilder createDrawableAttribute(int referenceId) {
        return XmlProtoAttributeBuilder.create("drawable").setResourceId(0x1010199).setValueAsRefId(referenceId);
    }

    public static String getAppStorePackageName(Optional<String> customAppStorePackageName) {
        return customAppStorePackageName.orElse(PLAY_STORE_PACKAGE_NAME);
    }
}

