/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.AbiMatcher;
import com.android.tools.build.bundletool.device.AutoValue_ApkMatcher_GeneratedApk;
import com.android.tools.build.bundletool.device.CountrySetApkMatcher;
import com.android.tools.build.bundletool.device.DeviceFeatureMatcher;
import com.android.tools.build.bundletool.device.DeviceGroupModuleMatcher;
import com.android.tools.build.bundletool.device.DeviceTierApkMatcher;
import com.android.tools.build.bundletool.device.LanguageMatcher;
import com.android.tools.build.bundletool.device.ModuleMatcher;
import com.android.tools.build.bundletool.device.MultiAbiMatcher;
import com.android.tools.build.bundletool.device.OpenGlFeatureMatcher;
import com.android.tools.build.bundletool.device.ScreenDensityMatcher;
import com.android.tools.build.bundletool.device.SdkRuntimeMatcher;
import com.android.tools.build.bundletool.device.SdkVersionMatcher;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.device.TextureCompressionFormatMatcher;
import com.android.tools.build.bundletool.device.VariantMatcher;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.IncompatibleDeviceException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ModuleDependenciesUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ApkMatcher {
    private final ImmutableList<? extends TargetingDimensionMatcher<?>> apkMatchers;
    private final Optional<ImmutableSet<String>> requestedModuleNames;
    private final boolean matchInstant;
    private final boolean includeInstallTimeAssetModules;
    private final ModuleMatcher moduleMatcher;
    private final VariantMatcher variantMatcher;
    private final boolean ensureDensityAndAbiApksMatched;

    public ApkMatcher(Devices.DeviceSpec deviceSpec) {
        this(deviceSpec, Optional.empty(), true, false, false);
    }

    public ApkMatcher(Devices.DeviceSpec deviceSpec, Optional<ImmutableSet<String>> requestedModuleNames, boolean includeInstallTimeAssetModules, boolean matchInstant, boolean ensureDensityAndAbiApksMatched) {
        Preconditions.checkArgument((!requestedModuleNames.isPresent() || !requestedModuleNames.get().isEmpty() ? 1 : 0) != 0, (Object)"Set of requested split modules cannot be empty.");
        SdkVersionMatcher sdkVersionMatcher = new SdkVersionMatcher(deviceSpec);
        AbiMatcher abiMatcher = new AbiMatcher(deviceSpec);
        MultiAbiMatcher multiAbiMatcher = new MultiAbiMatcher(deviceSpec);
        ScreenDensityMatcher screenDensityMatcher = new ScreenDensityMatcher(deviceSpec);
        LanguageMatcher languageMatcher = new LanguageMatcher(deviceSpec);
        DeviceFeatureMatcher deviceFeatureMatcher = new DeviceFeatureMatcher(deviceSpec);
        OpenGlFeatureMatcher openGlFeatureMatcher = new OpenGlFeatureMatcher(deviceSpec);
        TextureCompressionFormatMatcher textureCompressionFormatMatcher = new TextureCompressionFormatMatcher(deviceSpec);
        DeviceTierApkMatcher deviceTierApkMatcher = new DeviceTierApkMatcher(deviceSpec);
        CountrySetApkMatcher countrySetApkMatcher = new CountrySetApkMatcher(deviceSpec);
        DeviceGroupModuleMatcher deviceGroupModuleMatcher = new DeviceGroupModuleMatcher(deviceSpec);
        this.apkMatchers = ImmutableList.of((Object)sdkVersionMatcher, (Object)abiMatcher, (Object)multiAbiMatcher, (Object)screenDensityMatcher, (Object)languageMatcher, (Object)textureCompressionFormatMatcher, (Object)deviceTierApkMatcher, (Object)countrySetApkMatcher);
        this.requestedModuleNames = requestedModuleNames;
        this.includeInstallTimeAssetModules = includeInstallTimeAssetModules;
        this.matchInstant = matchInstant;
        this.ensureDensityAndAbiApksMatched = ensureDensityAndAbiApksMatched;
        this.moduleMatcher = new ModuleMatcher(sdkVersionMatcher, deviceFeatureMatcher, openGlFeatureMatcher, deviceGroupModuleMatcher);
        this.variantMatcher = new VariantMatcher(sdkVersionMatcher, abiMatcher, multiAbiMatcher, screenDensityMatcher, textureCompressionFormatMatcher, new SdkRuntimeMatcher(deviceSpec), matchInstant);
    }

    public ImmutableList<GeneratedApk> getMatchingApks(Commands.BuildApksResult buildApksResult) {
        Optional<Commands.Variant> matchingVariant = this.variantMatcher.getMatchingVariant(buildApksResult);
        matchingVariant.ifPresent((Consumer<Commands.Variant> & Serializable)variant -> this.validateVariant((Commands.Variant)variant, buildApksResult));
        ImmutableList<GeneratedApk> variantApks = matchingVariant.isPresent() ? this.getMatchingApksFromVariant(matchingVariant.get(), Version.of(buildApksResult.getBundletool().getVersion())) : ImmutableList.of();
        ImmutableList<GeneratedApk> assetModuleApks = this.getMatchingApksFromAssetModules(buildApksResult.getAssetSliceSetList());
        return ImmutableList.builder().addAll(variantApks).addAll(assetModuleApks).build();
    }

    public ImmutableList<GeneratedApk> getMatchingApksFromVariant(Commands.Variant variant, Version bundleVersion) {
        ImmutableSet<String> modulesToMatch = this.matchInstant ? this.getRequestedInstantModulesWithDependencies(variant) : this.getInstallTimeAndRequestedModulesWithDependencies(variant, bundleVersion);
        return (ImmutableList)variant.getApkSetList().stream().filter((Predicate<Commands.ApkSet> & Serializable)apkSet -> modulesToMatch.contains((Object)apkSet.getModuleMetadata().getName())).flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> this.getMatchingApksFromModule((Commands.ApkSet)apkSet).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<GeneratedApk> getMatchingApksFromModule(Commands.ApkSet moduleApks) {
        ImmutableSet<OptimizationDimension> matchedDimensions;
        ImmutableSet<OptimizationDimension> availableDimensions;
        String moduleName = moduleApks.getModuleMetadata().getName();
        ImmutableList matchedApks = (ImmutableList)moduleApks.getApkDescriptionList().stream().peek((Consumer<Commands.ApkDescription> & Serializable)apkDescription -> this.checkCompatibleWithApkTargeting(apkDescription.getTargeting())).filter((Predicate<Commands.ApkDescription> & Serializable)apkDescription -> this.matchesApkTargeting(apkDescription.getTargeting())).collect(ImmutableList.toImmutableList());
        if (this.ensureDensityAndAbiApksMatched && !(availableDimensions = ApkMatcher.getApkTargetingOnlyAbiAndDensity(moduleApks.getApkDescriptionList())).equals(matchedDimensions = ApkMatcher.getApkTargetingOnlyAbiAndDensity((Collection<Commands.ApkDescription>)matchedApks))) {
            throw IncompatibleDeviceException.builder().withUserMessage("Missing APKs for %s dimensions in the module '%s' for the provided device.", Sets.difference(availableDimensions, matchedDimensions), moduleName).build();
        }
        return (ImmutableList)matchedApks.stream().map((Function<Commands.ApkDescription, GeneratedApk> & Serializable)apkDescription -> GeneratedApk.create(ZipPath.create(apkDescription.getPath()), moduleName, moduleApks.getModuleMetadata().getDeliveryType())).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableSet<OptimizationDimension> getApkTargetingOnlyAbiAndDensity(Collection<Commands.ApkDescription> apks) {
        return (ImmutableSet)apks.stream().map(Commands.ApkDescription::getTargeting).flatMap((Function<Targeting.ApkTargeting, Stream> & Serializable)targeting -> {
            Stream.Builder<OptimizationDimension> dimensions = Stream.builder();
            if (targeting.hasAbiTargeting()) {
                dimensions.add(OptimizationDimension.ABI);
            }
            if (targeting.hasScreenDensityTargeting()) {
                dimensions.add(OptimizationDimension.SCREEN_DENSITY);
            }
            return dimensions.build();
        }).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<String> getRequestedInstantModulesWithDependencies(Commands.Variant variant) {
        if (!this.requestedModuleNames.isPresent()) {
            return (ImmutableSet)variant.getApkSetList().stream().map((Function<Commands.ApkSet, String> & Serializable)apkSet -> apkSet.getModuleMetadata().getName()).collect(ImmutableSet.toImmutableSet());
        }
        return ModuleDependenciesUtils.getModulesIncludingDependencies(variant, (Set)this.requestedModuleNames.get());
    }

    private ImmutableSet<String> getInstallTimeAndRequestedModulesWithDependencies(Commands.Variant variant, Version bundleVersion) {
        ImmutableSet<String> installTimeModules = this.buildModulesDeliveredInstallTime(variant, bundleVersion);
        ImmutableSet<String> explicitlyRequested = this.requestedModuleNames.orElse((ImmutableSet<String>)ImmutableSet.of());
        return ModuleDependenciesUtils.getModulesIncludingDependencies(variant, (Set<String>)Sets.union(installTimeModules, explicitlyRequested));
    }

    private void validateVariant(Commands.Variant variant, Commands.BuildApksResult buildApksResult) {
        if (this.requestedModuleNames.isPresent()) {
            boolean isStandaloneVariant = variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).anyMatch((Predicate<Commands.ApkDescription> & Serializable)apkDescription -> apkDescription.hasStandaloneApkMetadata() || apkDescription.hasApexApkMetadata());
            if (isStandaloneVariant) {
                throw InvalidCommandException.builder().withInternalMessage("Cannot restrict modules when the device matches a non-split APK.").build();
            }
            Sets.SetView availableModules = Sets.union((Set)Sets.union((Set)((Set)variant.getApkSetList().stream().map(Commands.ApkSet::getModuleMetadata).map(Commands.ModuleMetadata::getName).collect(ImmutableSet.toImmutableSet())), (Set)((Set)buildApksResult.getAssetSliceSetList().stream().map(Commands.AssetSliceSet::getAssetModuleMetadata).map(Commands.AssetModuleMetadata::getName).collect(ImmutableSet.toImmutableSet()))), (Set)((Set)buildApksResult.getPermanentlyFusedModulesList().stream().map(Commands.PermanentlyFusedModule::getName).collect(ImmutableSet.toImmutableSet())));
            Sets.SetView unknownModules = Sets.difference((Set)((Set)this.requestedModuleNames.get()), (Set)availableModules);
            if (!unknownModules.isEmpty()) {
                throw InvalidCommandException.builder().withInternalMessage("The APK Set archive does not contain the following modules: %s", unknownModules).build();
            }
        }
    }

    private ImmutableSet<String> buildModulesDeliveredInstallTime(Commands.Variant variant, Version bundleVersion) {
        return (ImmutableSet)variant.getApkSetList().stream().map(Commands.ApkSet::getModuleMetadata).filter((Predicate<Commands.ModuleMetadata> & Serializable)moduleMetadata -> this.willBeDeliveredInstallTime((Commands.ModuleMetadata)moduleMetadata, bundleVersion)).map(Commands.ModuleMetadata::getName).collect(ImmutableSet.toImmutableSet());
    }

    private boolean willBeDeliveredInstallTime(Commands.ModuleMetadata moduleMetadata, Version bundleVersion) {
        boolean installTime = VersionGuardedFeature.NEW_DELIVERY_TYPE_MANIFEST_TAG.enabledForVersion(bundleVersion) ? moduleMetadata.getDeliveryType().equals((Object)Commands.DeliveryType.INSTALL_TIME) : !moduleMetadata.getOnDemandDeprecated();
        return installTime && this.moduleMatcher.matchesModuleTargeting(moduleMetadata.getTargeting());
    }

    private boolean matchesApkTargeting(Targeting.ApkTargeting apkTargeting) {
        return this.apkMatchers.stream().allMatch((Predicate<TargetingDimensionMatcher> & Serializable)matcher -> matcher.getApkTargetingPredicate().test(apkTargeting));
    }

    public boolean matchesModuleSplitByTargeting(ModuleSplit moduleSplit) {
        this.variantMatcher.checkCompatibleWithVariantTargeting(moduleSplit.getVariantTargeting());
        this.checkCompatibleWithApkTargeting(moduleSplit.getApkTargeting());
        return this.variantMatcher.matchesVariantTargeting(moduleSplit.getVariantTargeting()) && this.matchesApkTargeting(moduleSplit.getApkTargeting());
    }

    public void checkCompatibleWithApkTargeting(ModuleSplit moduleSplit) {
        this.checkCompatibleWithApkTargeting(moduleSplit.getApkTargeting());
    }

    private void checkCompatibleWithApkTargeting(Targeting.ApkTargeting apkTargeting) {
        this.apkMatchers.forEach((Consumer<TargetingDimensionMatcher> & Serializable)matcher -> ApkMatcher.checkCompatibleWithApkTargetingHelper(matcher, apkTargeting));
    }

    private static <T> void checkCompatibleWithApkTargetingHelper(TargetingDimensionMatcher<T> matcher, Targeting.ApkTargeting apkTargeting) {
        matcher.checkDeviceCompatible(matcher.getTargetingValue(apkTargeting));
    }

    public ImmutableList<GeneratedApk> getMatchingApksFromAssetModules(Collection<Commands.AssetSliceSet> assetModules) {
        Sets.SetView assetModulesToMatch = Sets.union((Set)((Set)this.requestedModuleNames.orElse((ImmutableSet<String>)ImmutableSet.of())), this.includeInstallTimeAssetModules ? ApkMatcher.getUpfrontAssetModules(assetModules) : ImmutableSet.of());
        return (ImmutableList)assetModules.stream().filter(arg_0 -> ApkMatcher.lambda$getMatchingApksFromAssetModules$13((Set)assetModulesToMatch, arg_0)).flatMap((Function<Commands.AssetSliceSet, Stream> & Serializable)assetModule -> assetModule.getApkDescriptionList().stream().filter((Predicate<Commands.ApkDescription> & Serializable)apkDescription -> this.matchesApkTargeting(apkDescription.getTargeting())).map((Function<Commands.ApkDescription, GeneratedApk> & Serializable)apkDescription -> GeneratedApk.create(ZipPath.create(apkDescription.getPath()), assetModule.getAssetModuleMetadata().getName(), assetModule.getAssetModuleMetadata().getDeliveryType()))).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableSet<String> getUpfrontAssetModules(Collection<Commands.AssetSliceSet> assetModules) {
        return (ImmutableSet)assetModules.stream().filter((Predicate<Commands.AssetSliceSet> & Serializable)sliceSet -> sliceSet.getAssetModuleMetadata().getDeliveryType().equals((Object)Commands.DeliveryType.INSTALL_TIME)).map((Function<Commands.AssetSliceSet, String> & Serializable)sliceSet -> sliceSet.getAssetModuleMetadata().getName()).collect(ImmutableSet.toImmutableSet());
    }

    private static /* synthetic */ boolean lambda$getMatchingApksFromAssetModules$13(Set assetModulesToMatch, Commands.AssetSliceSet assetModule) {
        return assetModulesToMatch.contains(assetModule.getAssetModuleMetadata().getName());
    }

    @AutoValue
    public static abstract class GeneratedApk {
        public abstract ZipPath getPath();

        public abstract String getModuleName();

        public abstract Commands.DeliveryType getDeliveryType();

        public static GeneratedApk create(ZipPath path, String moduleName, Commands.DeliveryType deliveryType) {
            return new AutoValue_ApkMatcher_GeneratedApk(path, moduleName, deliveryType);
        }
    }
}

