/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.DdmlibDevice;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.nio.file.Path;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.internal.classpath.Instrumented;
import shadow.bundletool.com.android.ddmlib.AdbInitOptions;
import shadow.bundletool.com.android.ddmlib.AndroidDebugBridge;
import shadow.bundletool.com.android.ddmlib.Log;

public class DdmlibAdbServer
extends AdbServer {
    private static final DdmlibAdbServer instance = new DdmlibAdbServer();
    @Nullable
    private AndroidDebugBridge adb;
    @GuardedBy(value="this")
    private State state = State.UNINITIALIZED;
    private Path pathToAdb;

    private DdmlibAdbServer() {
    }

    public static DdmlibAdbServer getInstance() {
        return instance;
    }

    @Override
    public synchronized void init(Path pathToAdb) {
        Preconditions.checkState((this.state != State.CLOSED ? 1 : 0) != 0, (Object)"Android Debug Bridge has been closed.");
        if (this.state.equals((Object)State.INITIALIZED)) {
            Preconditions.checkState((boolean)pathToAdb.equals(this.pathToAdb), (String)"Re-initializing DdmlibAdbServer with a different ADB path. Expected: '%s', got '%s'.", (Object)this.pathToAdb, (Object)pathToAdb);
            return;
        }
        AdbInitOptions.Builder builder = AdbInitOptions.builder().setClientSupportEnabled(false).useJdwpProxyService(false);
        String env = Instrumented.getenv((String)"ANDROID_ADB_SERVER_PORT", (String)"com.android.tools.build.bundletool.device.DdmlibAdbServer");
        if (env != null) {
            try {
                builder.enableUserManagedAdbMode(Integer.decode(env));
            }
            catch (NumberFormatException e11) {
                throw CommandExecutionException.builder().withCause(e11).withInternalMessage("Failed to parse ANDROID_ADB_SERVER_PORT environment variable (%s)", env).build();
            }
        }
        Log.addLogger(new FilteredLogOutput());
        AndroidDebugBridge.init(builder.build());
        this.adb = AndroidDebugBridge.createBridge(pathToAdb.toString(), false);
        if (this.adb == null) {
            throw CommandExecutionException.builder().withInternalMessage("Failed to start ADB server.").build();
        }
        this.pathToAdb = pathToAdb;
        this.state = State.INITIALIZED;
    }

    @Override
    public synchronized ImmutableList<Device> getDevicesInternal() {
        Preconditions.checkState((boolean)this.state.equals((Object)State.INITIALIZED), (Object)"Android Debug Bridge is not initialized.");
        return (ImmutableList)Arrays.stream(this.adb.getDevices()).map(DdmlibDevice::new).collect(ImmutableList.toImmutableList());
    }

    @Override
    public synchronized boolean hasInitialDeviceList() {
        Preconditions.checkState((boolean)this.state.equals((Object)State.INITIALIZED), (Object)"Android Debug Bridge is not initialized.");
        return this.adb.hasInitialDeviceList();
    }

    @Override
    public synchronized void close() {
        if (this.state.equals((Object)State.INITIALIZED)) {
            AndroidDebugBridge.terminate();
        }
        this.state = State.CLOSED;
    }

    private static class FilteredLogOutput
    implements Log.ILogOutput {
        private FilteredLogOutput() {
        }

        @Override
        public void printLog(Log.LogLevel logLevel, String tag, String message2) {
            if (!this.shouldIgnore(logLevel, message2)) {
                Log.printLog(logLevel, tag, message2);
            }
        }

        @Override
        public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message2) {
            if (!this.shouldIgnore(logLevel, message2)) {
                Log.printLog(logLevel, tag, message2);
            }
        }

        private boolean shouldIgnore(Log.LogLevel logLevel, String message2) {
            return Log.LogLevel.ERROR.equals((Object)logLevel) && message2.contains("bad sub-command") && message2.contains("EmulatorConsole.getAvdPath");
        }
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZED,
        CLOSED;

    }
}

