/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Serializable;

public abstract class TargetingDimensionMatcher<T> {
    private final Devices.DeviceSpec deviceSpec;

    public TargetingDimensionMatcher(Devices.DeviceSpec deviceSpec) {
        this.deviceSpec = deviceSpec;
    }

    protected Devices.DeviceSpec getDeviceSpec() {
        return this.deviceSpec;
    }

    public java.util.function.Predicate<Targeting.ApkTargeting> getApkTargetingPredicate() {
        return Predicates.compose(this::matchesTargeting, this::getTargetingValue);
    }

    public java.util.function.Predicate<Targeting.VariantTargeting> getVariantTargetingPredicate() {
        return (java.util.function.Predicate<Targeting.VariantTargeting> & Serializable)variantTargeting -> !this.isDeviceDimensionPresent() || this.matchesTargeting(this.getTargetingValue((Targeting.VariantTargeting)variantTargeting));
    }

    public java.util.function.Predicate<Targeting.ModuleTargeting> getModuleTargetingPredicate() {
        return Predicates.compose((Predicate & Serializable)targetingValue -> !this.isDeviceDimensionPresent() || this.matchesTargeting(targetingValue), this::getTargetingValue);
    }

    protected T getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        throw new UnsupportedOperationException();
    }

    protected T getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        throw new UnsupportedOperationException();
    }

    protected T getTargetingValue(Targeting.ModuleTargeting moduleTargeting) {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean isDeviceDimensionPresent();

    public abstract boolean matchesTargeting(T var1);

    public void checkDeviceCompatible(T targetingValue) {
        if (this.isDeviceDimensionPresent()) {
            this.checkDeviceCompatibleInternal(targetingValue);
        }
    }

    protected abstract void checkDeviceCompatibleInternal(T var1);
}

