/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class WearApkLocator {
    static final String WEAR_APK_1_0_METADATA_KEY = "com.google.android.wearable.beta.app";

    public static ImmutableCollection<ZipPath> findEmbeddedWearApkPaths(ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return ImmutableList.of();
        }
        Resources.ResourceTable resourceTable = split.getResourceTable().get();
        AndroidManifest manifest = split.getAndroidManifest();
        ImmutableCollection embeddedWearApkPaths = (ImmutableCollection)manifest.getMetadataResourceId(WEAR_APK_1_0_METADATA_KEY).map((Function<Integer, Resources.Entry> & Serializable)resourceId -> WearApkLocator.findXmlDescriptionResourceEntry(resourceTable, resourceId)).map((Function<Resources.Entry, String> & Serializable)entry -> WearApkLocator.getXmlDescriptionPath(entry)).map((Function<String, ModuleEntry> & Serializable)xmlDescriptionPath -> WearApkLocator.findXmlDescriptionZipEntry(split, xmlDescriptionPath)).flatMap((Function<ModuleEntry, Optional> & Serializable)xmlDescriptionEntry -> WearApkLocator.extractWearApkName(xmlDescriptionEntry)).flatMap((Function<String, Optional> & Serializable)resourceName -> ResourcesUtils.lookupEntryByResourceTypeAndName(resourceTable, "raw", resourceName)).map((Function<Resources.Entry, ImmutableList> & Serializable)entry -> (ImmutableList)entry.getConfigValueList().stream().map((Function<Resources.ConfigValue, String> & Serializable)configValue -> configValue.getValue().getItem().getFile().getPath()).filter(Predicates.not(String::isEmpty)).map(ZipPath::create).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        embeddedWearApkPaths.forEach((Consumer<ZipPath> & Serializable)path -> {
            if (!split.findEntry((ZipPath)path).isPresent()) {
                throw InvalidBundleException.builder().withUserMessage("Wear APK expected at location '%s' but was not found.", path).build();
            }
        });
        return embeddedWearApkPaths;
    }

    private static Resources.Entry findXmlDescriptionResourceEntry(Resources.ResourceTable resourceTable, int resourceId) {
        return ResourcesUtils.lookupEntryByResourceId(resourceTable, resourceId).orElseThrow((Supplier<InvalidBundleException> & Serializable)() -> InvalidBundleException.builder().withUserMessage("Resource 0x%08x is referenced in the manifest in the '%s' metadata, but was not found in the resource table.", resourceId, WEAR_APK_1_0_METADATA_KEY).build());
    }

    private static String getXmlDescriptionPath(Resources.Entry entry) {
        Preconditions.checkState((entry.getConfigValueCount() > 0 ? 1 : 0) != 0, (String)"Resource table entry without value: %s", (Object)entry);
        if (entry.getConfigValueCount() > 1) {
            throw InvalidBundleException.createWithUserMessage("More than one embedded Wear APK is not supported.");
        }
        Resources.ConfigValue configValue = (Resources.ConfigValue)Iterables.getOnlyElement((Iterable)entry.getConfigValueList());
        String xmlDescriptionPath = configValue.getValue().getItem().getFile().getPath();
        if (xmlDescriptionPath.isEmpty()) {
            throw InvalidBundleException.createWithUserMessage("No XML description file path found for Wear APK.");
        }
        return xmlDescriptionPath;
    }

    private static ModuleEntry findXmlDescriptionZipEntry(ModuleSplit split, String xmlDescPath) {
        return split.findEntry(xmlDescPath).orElseThrow((Supplier<InvalidBundleException> & Serializable)() -> InvalidBundleException.builder().withUserMessage("Wear APK XML description file expected at '%s' but was not found.", xmlDescPath).build());
    }

    private static Optional<String> extractWearApkName(ModuleEntry wearApkDescriptionXmlEntry) {
        XmlProtoNode root;
        try (InputStream content = wearApkDescriptionXmlEntry.getContent().openStream();){
            root = new XmlProtoNode(Resources.XmlNode.parseFrom((InputStream)content));
        }
        catch (InvalidProtocolBufferException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The wear APK description file '%s' could not be parsed.", wearApkDescriptionXmlEntry.getPath()).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException(String.format("An unexpected error occurred while reading APK description file '%s'.", wearApkDescriptionXmlEntry.getPath()), e12);
        }
        if (((XmlProtoElement)root.getElement()).getOptionalChildElement("unbundled").isPresent()) {
            return Optional.empty();
        }
        Optional rawPathResId = ((XmlProtoElement)root.getElement()).getOptionalChildElement("rawPathResId");
        if (!rawPathResId.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("The wear APK description file '%s' does not contain 'unbundled' or 'rawPathResId'.", wearApkDescriptionXmlEntry.getPath()).build();
        }
        return Optional.of(((XmlProtoNode)((XmlProtoElement)rawPathResId.get()).getChildText().get()).getText());
    }

    private WearApkLocator() {
    }
}

