/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Config;
import com.android.bundle.SdkBundleConfigProto;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ClassesDexSanitizer;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleParser {
    public static final ZipPath METADATA_DIRECTORY = ZipPath.create("BUNDLE-METADATA");
    public static final String BUNDLE_CONFIG_FILE_NAME = "BundleConfig.pb";
    public static final String SDK_MODULES_CONFIG_FILE_NAME = "SdkModulesConfig.pb";
    public static final String SDK_BUNDLE_CONFIG_FILE_NAME = "SdkBundleConfig.pb";
    public static final String SDK_INTERFACE_DESCRIPTORS_FILE_NAME = "sdk-interface-descriptors.jar";
    public static final String SDK_MODULES_FILE_NAME = "modules.resm";
    public static final String EXTRACTED_SDK_MODULES_FILE_NAME = "extracted-modules.resm";

    private BundleParser() {
    }

    public static Optional<BundleModuleName> extractModuleName(ZipEntry entry, ImmutableSet<ZipPath> nonModuleDirectories) {
        ZipPath path = ZipPath.create(entry.getName());
        for (ZipPath nonModuleDirectory : nonModuleDirectories) {
            if (!path.startsWith(nonModuleDirectory)) continue;
            return Optional.empty();
        }
        if (path.getNameCount() <= 1) {
            return Optional.empty();
        }
        if (path.toString().endsWith(".class")) {
            return Optional.empty();
        }
        return Optional.of(BundleModuleName.create(path.getName(0).toString()));
    }

    public static ImmutableList<BundleModule> extractModules(ZipFile bundleFile, Config.BundleConfig.BundleType bundleType, Version bundletoolVersion, Optional<Config.ApexConfig> apexConfig, Optional<SdkModulesConfigOuterClass.SdkModulesConfig> sdkModulesConfig, ImmutableSet<ZipPath> nonModuleDirectories) {
        HashMap moduleBuilders = new HashMap();
        Enumeration<? extends ZipEntry> entries = bundleFile.entries();
        while (entries.hasMoreElements()) {
            Optional<BundleModuleName> moduleName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(moduleName = BundleParser.extractModuleName(entry, nonModuleDirectories)).isPresent()) continue;
            BundleModule.Builder moduleBuilder = (BundleModule.Builder)moduleBuilders.computeIfAbsent(moduleName.get(), (Function<BundleModuleName, BundleModule.Builder> & Serializable)name -> {
                BundleModule.Builder bundleModuleBuilder = BundleModule.builder().setName((BundleModuleName)name).setBundleType(bundleType).setBundletoolVersion(bundletoolVersion);
                apexConfig.ifPresent(bundleModuleBuilder::setBundleApexConfig);
                sdkModulesConfig.ifPresent(bundleModuleBuilder::setSdkModulesConfig);
                return bundleModuleBuilder;
            });
            moduleBuilder.addEntry(ModuleEntry.builder().setFileLocation(ModuleEntry.ModuleEntryLocationInZipSource.create(Paths.get(bundleFile.getName(), new String[0]), ZipPath.create(entry.getName()))).setPath(ZipUtils.convertBundleToModulePath(ZipPath.create(entry.getName()))).setContent(ZipUtils.asByteSource(bundleFile, entry)).build());
        }
        BundleParser.checkModulesHaveManifest(moduleBuilders.values());
        return (ImmutableList)moduleBuilders.values().stream().map(BundleModule.Builder::build).collect(ImmutableList.toImmutableList());
    }

    private static void checkModulesHaveManifest(Collection<BundleModule.Builder> bundleModules) {
        ImmutableSet modulesWithoutManifest = (ImmutableSet)bundleModules.stream().filter((Predicate<BundleModule.Builder> & Serializable)bundleModule -> !bundleModule.hasAndroidManifest()).map((Function<BundleModule.Builder, String> & Serializable)module -> module.getName().getName()).collect(ImmutableSet.toImmutableSet());
        if (!modulesWithoutManifest.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Found modules in the App Bundle without an AndroidManifest.xml: %s", modulesWithoutManifest).build();
        }
    }

    public static Config.BundleConfig readBundleConfig(ZipFile bundleFile) {
        ZipEntry bundleConfigEntry = bundleFile.getEntry(BUNDLE_CONFIG_FILE_NAME);
        if (bundleConfigEntry == null) {
            throw InvalidBundleException.builder().withUserMessage("File '%s' was not found.", BUNDLE_CONFIG_FILE_NAME).build();
        }
        try {
            return Config.BundleConfig.parseFrom(ZipUtils.asByteSource(bundleFile, bundleConfigEntry).read());
        }
        catch (InvalidProtocolBufferException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("Bundle config '%s' could not be parsed.", BUNDLE_CONFIG_FILE_NAME).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException(String.format("Error reading file '%s'.", BUNDLE_CONFIG_FILE_NAME), e12);
        }
    }

    public static SdkModulesConfigOuterClass.SdkModulesConfig readSdkModulesConfig(ZipFile modulesFile) {
        ZipEntry sdkModulesConfigEntry = modulesFile.getEntry(SDK_MODULES_CONFIG_FILE_NAME);
        if (sdkModulesConfigEntry == null) {
            throw InvalidBundleException.builder().withUserMessage("File '%s' was not found.", SDK_MODULES_CONFIG_FILE_NAME).build();
        }
        try {
            return SdkModulesConfigOuterClass.SdkModulesConfig.parseFrom(ZipUtils.asByteSource(modulesFile, sdkModulesConfigEntry).read());
        }
        catch (InvalidProtocolBufferException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("SDK modules config file '%s' could not be parsed.", SDK_MODULES_CONFIG_FILE_NAME).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException(String.format("Error reading file '%s'.", SDK_MODULES_CONFIG_FILE_NAME), e12);
        }
    }

    public static SdkBundleConfigProto.SdkBundleConfig readSdkBundleConfig(ZipFile bundleFile) {
        ZipEntry sdkBundleConfigEntry = bundleFile.getEntry(SDK_BUNDLE_CONFIG_FILE_NAME);
        if (sdkBundleConfigEntry == null) {
            return SdkBundleConfigProto.SdkBundleConfig.getDefaultInstance();
        }
        try {
            return SdkBundleConfigProto.SdkBundleConfig.parseFrom(ZipUtils.asByteSource(bundleFile, sdkBundleConfigEntry).read());
        }
        catch (InvalidProtocolBufferException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("SDK bundle config file '%s' could not be parsed.", SDK_BUNDLE_CONFIG_FILE_NAME).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException(String.format("Error reading file '%s'.", SDK_BUNDLE_CONFIG_FILE_NAME), e12);
        }
    }

    public static BundleMetadata readBundleMetadata(ZipFile bundleFile) {
        BundleMetadata.Builder metadata = BundleMetadata.builder();
        ZipUtils.allFileEntries(bundleFile).filter((Predicate<? extends ZipEntry>)(Predicate<ZipEntry> & Serializable)entry -> ZipPath.create(entry.getName()).startsWith(METADATA_DIRECTORY)).forEach((Consumer<? extends ZipEntry>)(Consumer<ZipEntry> & Serializable)zipEntry -> {
            ZipPath bundlePath = ZipPath.create(zipEntry.getName());
            ZipPath metadataPath = bundlePath.subpath(1, bundlePath.getNameCount());
            metadata.addFile(metadataPath, ZipUtils.asByteSource(bundleFile, zipEntry));
        });
        return metadata.build();
    }

    public static Optional<ByteSource> readSdkInterfaceDescriptors(ZipFile bundleFile) {
        ZipEntry entry = bundleFile.getEntry(SDK_INTERFACE_DESCRIPTORS_FILE_NAME);
        return Optional.ofNullable(entry).map((Function<ZipEntry, ByteSource> & Serializable)value -> ZipUtils.asByteSource(bundleFile, value));
    }

    @CheckReturnValue
    public static ImmutableList<BundleModule> sanitize(ImmutableList<BundleModule> modules) {
        modules = (ImmutableList)modules.stream().map((Function<BundleModule, BundleModule> & Serializable)module -> new ClassesDexSanitizer().applyMutation((BundleModule)module)).collect(ImmutableList.toImmutableList());
        return modules;
    }

    public static ZipFile getModulesZip(ZipFile bundleZip, Path modulesPath) throws IOException {
        ZipEntry modulesEntry = bundleZip.getEntry(SDK_MODULES_FILE_NAME);
        try (InputStream modulesInputStream = bundleZip.getInputStream(modulesEntry);){
            Files.copy(modulesInputStream, modulesPath, new CopyOption[0]);
            ZipFile zipFile = new ZipFile(modulesPath.toFile());
            return zipFile;
        }
    }
}

