/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public final class ResultUtils {
    public static Commands.BuildApksResult readTableOfContents(Path apksPath) {
        try {
            ResultUtils.ensureSingleToc(apksPath);
            Commands.BuildApksResult result = NioFileInterceptors.intercept_isDirectory((Path)apksPath, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.ResultUtils") ? ResultUtils.readTableOfContentFromApksDirectory(apksPath) : ResultUtils.readTableOfContentFromApksArchive(apksPath);
            return ResultUtils.applyDefaultValues(result);
        }
        catch (IOException e11) {
            throw new UncheckedIOException(String.format("Error while reading the table of contents file from '%s'.", apksPath), e11);
        }
    }

    private static Commands.BuildApksResult readTableOfContentFromApksArchive(Path apksArchivePath) throws IOException {
        try (ZipFile apksArchive = new ZipFile(apksArchivePath.toFile());){
            boolean tocJsonExists = apksArchive.getEntry("toc.json") != null;
            byte[] tocBytes = tocJsonExists ? ZipUtils.asByteSource(apksArchive, new ZipEntry("toc.json")).read() : ZipUtils.asByteSource(apksArchive, new ZipEntry("toc.pb")).read();
            Commands.BuildApksResult buildApksResult = tocJsonExists ? ResultUtils.parseJsonToc(tocBytes) : ResultUtils.parseProtoToc(tocBytes);
            return buildApksResult;
        }
    }

    private static Commands.BuildApksResult readTableOfContentFromApksDirectory(Path apksDirectoryPath) throws IOException {
        boolean tocJsonExists = NioFileInterceptors.intercept_exists((Path)apksDirectoryPath.resolve("toc.json"), (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.ResultUtils");
        byte[] tocBytes = tocJsonExists ? NioFileInterceptors.intercept_readAllBytes((Path)apksDirectoryPath.resolve("toc.json"), (String)"com.android.tools.build.bundletool.model.utils.ResultUtils") : NioFileInterceptors.intercept_readAllBytes((Path)apksDirectoryPath.resolve("toc.pb"), (String)"com.android.tools.build.bundletool.model.utils.ResultUtils");
        return tocJsonExists ? ResultUtils.parseJsonToc(tocBytes) : ResultUtils.parseProtoToc(tocBytes);
    }

    private static Commands.BuildApksResult parseJsonToc(byte[] bytes) throws IOException {
        String jsonToc = new String(bytes, StandardCharsets.UTF_8);
        Commands.BuildApksResult.Builder builder = Commands.BuildApksResult.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(jsonToc, (Message.Builder)builder);
        return builder.build();
    }

    @VisibleForTesting
    static Commands.BuildApksResult applyDefaultValues(Commands.BuildApksResult buildApksResult) {
        Commands.BuildApksResult.Builder builder = buildApksResult.toBuilder();
        if (builder.getBundletool().getVersion().isEmpty()) {
            builder.getBundletoolBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString());
        }
        return builder.build();
    }

    private static Commands.BuildApksResult parseProtoToc(byte[] bytes) throws IOException {
        try {
            return Commands.BuildApksResult.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e11) {
            return ResultUtils.toBuildApksResult(Commands.BuildSdkApksResult.parseFrom(bytes));
        }
    }

    private static void ensureSingleToc(Path file) throws IOException {
        if (NioFileInterceptors.intercept_isDirectory((Path)file, (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.ResultUtils")) {
            if (NioFileInterceptors.intercept_exists((Path)file.resolve("toc.pb"), (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.ResultUtils") && NioFileInterceptors.intercept_exists((Path)file.resolve("toc.json"), (LinkOption[])new LinkOption[0], (String)"com.android.tools.build.bundletool.model.utils.ResultUtils")) {
                throw new IllegalStateException("Apks directory cannot have both toc.pb and toc.json at the same time.");
            }
        } else {
            try (ZipFile apksArchive = new ZipFile(file.toFile());){
                if (apksArchive.getEntry("toc.pb") != null && apksArchive.getEntry("toc.json") != null) {
                    throw new IllegalStateException("Apks archive cannot have both toc.pb and toc.json at the same time.");
                }
            }
        }
    }

    public static ImmutableList<Commands.Variant> splitApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.splitApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> splitApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isSplitApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> instantApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.instantApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> instantApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isInstantApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> standaloneApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.standaloneApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> standaloneApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isStandaloneApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> apexApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.apexApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> apexApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isApexApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> systemApkVariants(Commands.BuildApksResult result) {
        return ResultUtils.systemApkVariants((ImmutableList<Commands.Variant>)ImmutableList.copyOf(result.getVariantList()));
    }

    public static ImmutableList<Commands.Variant> systemApkVariants(ImmutableList<Commands.Variant> variants) {
        return (ImmutableList)variants.stream().filter(ResultUtils::isSystemApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<Commands.Variant> archivedApkVariants(Commands.BuildApksResult result) {
        return (ImmutableList)result.getVariantList().stream().filter(ResultUtils::isArchivedApkVariant).collect(ImmutableList.toImmutableList());
    }

    public static boolean isSplitApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasSplitApkMetadata);
    }

    public static boolean isStandaloneApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasStandaloneApkMetadata);
    }

    public static boolean isApexApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasApexApkMetadata);
    }

    public static boolean isInstantApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).allMatch(Commands.ApkDescription::hasInstantApkMetadata);
    }

    public static boolean isSystemApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).anyMatch(Commands.ApkDescription::hasSystemApkMetadata);
    }

    public static boolean isArchivedApkVariant(Commands.Variant variant) {
        return variant.getApkSetList().stream().flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream()).anyMatch(Commands.ApkDescription::hasArchivedApkMetadata);
    }

    public static ImmutableSet<String> getAllTargetedLanguages(Commands.BuildApksResult result) {
        return (ImmutableSet)Streams.concat((Stream[])new Stream[]{result.getAssetSliceSetList().stream().flatMap((Function<Commands.AssetSliceSet, Stream> & Serializable)assetSliceSet -> assetSliceSet.getApkDescriptionList().stream()), result.getVariantList().stream().flatMap((Function<Commands.Variant, Stream> & Serializable)variant -> variant.getApkSetList().stream()).flatMap((Function<Commands.ApkSet, Stream> & Serializable)apkSet -> apkSet.getApkDescriptionList().stream())}).flatMap((Function<Commands.ApkDescription, Stream> & Serializable)apkDescription -> apkDescription.getTargeting().getLanguageTargeting().getValueList().stream()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<String> getAllBaseMasterSplitPaths(Commands.BuildApksResult toc) {
        return (ImmutableSet)ResultUtils.splitApkVariants(toc).stream().map(Commands.Variant::getApkSetList).flatMap(Collection::stream).filter((Predicate<Commands.ApkSet> & Serializable)apkSet -> apkSet.getModuleMetadata().getName().equals(BundleModuleName.BASE_MODULE_NAME.getName())).map(Commands.ApkSet::getApkDescriptionList).flatMap(Collection::stream).filter((Predicate<Commands.ApkDescription> & Serializable)apkDescription -> apkDescription.getSplitApkMetadata().getIsMasterSplit()).map(Commands.ApkDescription::getPath).collect(ImmutableSet.toImmutableSet());
    }

    private static Commands.BuildApksResult toBuildApksResult(Commands.BuildSdkApksResult result) {
        return Commands.BuildApksResult.newBuilder().setBundletool(result.getBundletool()).setPackageName(result.getPackageName()).addAllVariant(result.getVariantList()).build();
    }

    private ResultUtils() {
    }
}

