/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.SplitsProtoXmlBuilder;
import com.android.tools.build.bundletool.model.VariantKey;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class SplitsXmlInjector {
    private static final String XML_TYPE_NAME = "xml";
    private static final String XML_PATH_PATTERN = "res/xml/splits%s.xml";
    private static final String METADATA_KEY = "com.android.vending.splits";

    public ImmutableList<ModuleSplit> process(VariantKey variantKey, Collection<ModuleSplit> splits) {
        switch (variantKey.getSplitType()) {
            case SYSTEM: 
            case SPLIT: {
                return SplitsXmlInjector.processSplitApkVariant(splits);
            }
            case STANDALONE: {
                return (ImmutableList)splits.stream().map(SplitsXmlInjector::processStandaloneVariant).collect(ImmutableList.toImmutableList());
            }
            case STANDALONE_FEATURE_MODULE: {
                return (ImmutableList)splits.stream().map((Function<ModuleSplit, ModuleSplit> & Serializable)split -> split.isBaseModuleSplit() ? SplitsXmlInjector.processStandaloneVariant(split) : split).collect(ImmutableList.toImmutableList());
            }
            case INSTANT: 
            case ARCHIVE: {
                return ImmutableList.copyOf(splits);
            }
            case ASSET_SLICE: {
                throw new IllegalStateException("Unexpected Asset Slice inside variant.");
            }
        }
        throw new IllegalStateException(String.format("Unknown split type %s", new Object[]{variantKey.getSplitType()}));
    }

    private static ModuleSplit processStandaloneVariant(ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return split;
        }
        SplitsProtoXmlBuilder splitsProtoXmlBuilder = new SplitsProtoXmlBuilder();
        SplitsXmlInjector.addLanguageSplitsFromResourceTable(splitsProtoXmlBuilder, split);
        return SplitsXmlInjector.injectSplitsXml(split, splitsProtoXmlBuilder.build());
    }

    private static ImmutableList<ModuleSplit> processSplitApkVariant(Collection<ModuleSplit> splits) {
        boolean hasLanguageSplits = splits.stream().anyMatch((Predicate<ModuleSplit> & Serializable)split -> split.getApkTargeting().hasLanguageTargeting());
        Resources.XmlNode splitsXmlContent = hasLanguageSplits ? SplitsXmlInjector.getSplitsXmlContentFromLanguageTargeting(splits) : SplitsXmlInjector.getSplitsXmlContentFromResourceTables(splits);
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (ModuleSplit split2 : splits) {
            if (split2.isMasterSplit() && split2.isBaseModuleSplit()) {
                result.add((Object)SplitsXmlInjector.injectSplitsXml(split2, splitsXmlContent));
                continue;
            }
            result.add((Object)split2);
        }
        return result.build();
    }

    private static Resources.XmlNode getSplitsXmlContentFromLanguageTargeting(Collection<ModuleSplit> splits) {
        SplitsProtoXmlBuilder splitsProtoXmlBuilder = new SplitsProtoXmlBuilder();
        for (ModuleSplit split : splits) {
            String splitId = split.getAndroidManifest().getSplitId().orElse("");
            for (String language : split.getApkTargeting().getLanguageTargeting().getValueList()) {
                splitsProtoXmlBuilder.addLanguageMapping(split.getModuleName(), language, splitId);
            }
        }
        return splitsProtoXmlBuilder.build();
    }

    private static Resources.XmlNode getSplitsXmlContentFromResourceTables(Collection<ModuleSplit> splits) {
        SplitsProtoXmlBuilder splitsProtoXmlBuilder = new SplitsProtoXmlBuilder();
        splits.stream().filter(ModuleSplit::isMasterSplit).forEach((Consumer<ModuleSplit> & Serializable)split -> SplitsXmlInjector.addLanguageSplitsFromResourceTable(splitsProtoXmlBuilder, split));
        return splitsProtoXmlBuilder.build();
    }

    private static void addLanguageSplitsFromResourceTable(SplitsProtoXmlBuilder splitsProtoXmlBuilder, ModuleSplit split) {
        if (!split.getResourceTable().isPresent()) {
            return;
        }
        String splitId = split.getAndroidManifest().getSplitId().orElse("");
        ResourcesUtils.getAllLanguages(split.getResourceTable().get()).stream().filter((Predicate<String> & Serializable)language -> !language.isEmpty()).forEach((Consumer<String> & Serializable)language -> splitsProtoXmlBuilder.addLanguageMapping(split.getModuleName(), (String)language, splitId));
    }

    private static ModuleSplit injectSplitsXml(ModuleSplit split, Resources.XmlNode xmlNode) {
        ZipPath resourcePath = SplitsXmlInjector.getUniqueResourcePath(split);
        ResourceInjector resourceInjector = ResourceInjector.fromModuleSplit(split);
        ResourceId resourceId = resourceInjector.addResource(XML_TYPE_NAME, SplitsXmlInjector.createXmlEntry(resourcePath));
        return split.toBuilder().setResourceTable(resourceInjector.build()).setEntries((List<ModuleEntry>)ImmutableList.builder().addAll(split.getEntries()).add((Object)ModuleEntry.builder().setPath(resourcePath).setContent(ByteSource.wrap((byte[])xmlNode.toByteArray())).build()).build()).setAndroidManifest(split.getAndroidManifest().toEditor().addMetaDataResourceId(METADATA_KEY, resourceId.getFullResourceId()).save()).build();
    }

    private static Resources.Entry createXmlEntry(ZipPath resourcePath) {
        return Resources.Entry.newBuilder().setName(resourcePath.getFileName().toString().split("\\.", 2)[0]).addConfigValue(Resources.ConfigValue.newBuilder().setValue(Resources.Value.newBuilder().setItem(Resources.Item.newBuilder().setFile(Resources.FileReference.newBuilder().setPath(resourcePath.toString()).setType(Resources.FileReference.Type.PROTO_XML))))).build();
    }

    private static ZipPath getUniqueResourcePath(ModuleSplit split) {
        return (ZipPath)Stream.iterate(0, (UnaryOperator & Serializable)i11 -> i11 + 1).map((Function<Integer, ZipPath> & Serializable)number -> ZipPath.create(String.format(XML_PATH_PATTERN, number))).filter((Predicate<ZipPath> & Serializable)path -> !split.findEntry((ZipPath)path).isPresent()).findFirst().get();
    }
}

