/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.preprocessors;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.preprocessors.AppBundlePreprocessor;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

public class EmbeddedApkSigningPreprocessor
implements AppBundlePreprocessor {
    @Inject
    EmbeddedApkSigningPreprocessor() {
    }

    @Override
    public AppBundle preprocess(AppBundle bundle) {
        ImmutableSet unsignedEmbeddedApkPaths = (ImmutableSet)bundle.getBundleConfig().getUnsignedEmbeddedApkConfigList().stream().map(Config.UnsignedEmbeddedApkConfig::getPath).map(ZipPath::create).collect(ImmutableSet.toImmutableSet());
        ImmutableSet.Builder foundApkPaths = ImmutableSet.builder();
        AppBundle appBundle = bundle.toBuilder().setRawModules((Collection<BundleModule>)EmbeddedApkSigningPreprocessor.setShouldSign((ImmutableCollection<BundleModule>)bundle.getModules().values(), (ImmutableSet<ZipPath>)unsignedEmbeddedApkPaths, (ImmutableSet.Builder<ZipPath>)foundApkPaths)).build();
        Sets.SetView missingApks = Sets.difference((Set)unsignedEmbeddedApkPaths, (Set)foundApkPaths.build());
        if (!missingApks.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Unsigned embedded APKs specified in bundle config but missing from bundle: %s", missingApks).build();
        }
        return appBundle;
    }

    @CheckReturnValue
    private static ImmutableList<BundleModule> setShouldSign(ImmutableCollection<BundleModule> modules, ImmutableSet<ZipPath> unsignedEmbeddedApkPaths, ImmutableSet.Builder<ZipPath> foundApkPaths) {
        return (ImmutableList)modules.stream().map((Function<BundleModule, BundleModule> & Serializable)module -> EmbeddedApkSigningPreprocessor.setShouldSign(module, unsignedEmbeddedApkPaths, foundApkPaths)).collect(ImmutableList.toImmutableList());
    }

    private static BundleModule setShouldSign(BundleModule module, ImmutableSet<ZipPath> unsignedEmbeddedApkPaths, ImmutableSet.Builder<ZipPath> foundApkPaths) {
        return module.toBuilder().setRawEntries((Collection)module.getEntries().stream().map((Function<ModuleEntry, ModuleEntry> & Serializable)entry -> EmbeddedApkSigningPreprocessor.setShouldSign(entry, unsignedEmbeddedApkPaths, foundApkPaths)).collect(ImmutableList.toImmutableList())).build();
    }

    private static ModuleEntry setShouldSign(ModuleEntry moduleEntry, ImmutableSet<ZipPath> unsignedEmbeddedApkPaths, ImmutableSet.Builder<ZipPath> foundApkPaths) {
        boolean shouldSign = unsignedEmbeddedApkPaths.contains((Object)moduleEntry.getPath());
        if (shouldSign) {
            foundApkPaths.add((Object)moduleEntry.getPath());
        }
        return moduleEntry.toBuilder().setShouldSign(shouldSign).build();
    }
}

