/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.preprocessors;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.preprocessors.AppBundlePreprocessor;
import com.android.tools.build.bundletool.preprocessors.ModuleCompressionManager;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import javax.inject.Inject;

public class EntryCompressionPreprocessor
implements AppBundlePreprocessor {
    private final ModuleCompressionManager moduleCompressionManager;

    @Inject
    EntryCompressionPreprocessor(ModuleCompressionManager moduleCompressionManager) {
        this.moduleCompressionManager = moduleCompressionManager;
    }

    @Override
    public AppBundle preprocess(AppBundle bundle) {
        return bundle.toBuilder().setRawModules((Collection<BundleModule>)this.setEntryCompression((ImmutableCollection<BundleModule>)bundle.getModules().values(), bundle.getBundleConfig())).build();
    }

    @CheckReturnValue
    private ImmutableList<BundleModule> setEntryCompression(ImmutableCollection<BundleModule> modules, Config.BundleConfig bundleConfig) {
        return (ImmutableList)modules.stream().map((Function<BundleModule, BundleModule> & Serializable)module -> this.setEntryCompression((BundleModule)module, bundleConfig)).collect(ImmutableList.toImmutableList());
    }

    private BundleModule setEntryCompression(BundleModule module, Config.BundleConfig bundleConfig) {
        if (this.moduleCompressionManager.shouldForceUncompressAssets(bundleConfig, module.getAndroidManifest())) {
            return module.toBuilder().setRawEntries((Collection)module.getEntries().stream().map((Function<ModuleEntry, ModuleEntry> & Serializable)entry -> entry.toBuilder().setForceUncompressed(entry.getPath().startsWith(BundleModule.ASSETS_DIRECTORY)).build()).collect(ImmutableList.toImmutableList())).build();
        }
        return module;
    }
}

