/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.preprocessors;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.preprocessors.AppBundlePreprocessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;

public class LocalRuntimeEnabledSdkConfigPreprocessor
implements AppBundlePreprocessor {
    private final ImmutableMap<String, String> certificateOverridesBySdkName;
    private final String defaultCertificateOverride;

    @Inject
    LocalRuntimeEnabledSdkConfigPreprocessor(Optional<RuntimeEnabledSdkConfigProto.LocalDeploymentRuntimeEnabledSdkConfig> localRuntimeEnabledSdkConfig) {
        this.defaultCertificateOverride = localRuntimeEnabledSdkConfig.map((Function<RuntimeEnabledSdkConfigProto.LocalDeploymentRuntimeEnabledSdkConfig, String> & Serializable)config -> config.getCertificateOverrides().getDefaultCertificateOverride()).orElse("");
        this.certificateOverridesBySdkName = localRuntimeEnabledSdkConfig.map(LocalRuntimeEnabledSdkConfigPreprocessor::unnestCertificateOverrides).orElse(ImmutableMap.of());
    }

    @Override
    public AppBundle preprocess(AppBundle bundle) {
        if (this.certificateOverridesBySdkName.isEmpty() && this.defaultCertificateOverride.isEmpty()) {
            return bundle;
        }
        ImmutableList updatedModules = (ImmutableList)bundle.getModules().values().stream().map(this::updateRuntimeEnabledSdkConfig).collect(ImmutableList.toImmutableList());
        return bundle.toBuilder().setRawModules((Collection<BundleModule>)updatedModules).setRuntimeEnabledSdkDependencies(this.getAllRuntimeEnabledSdkDependencies((ImmutableList<BundleModule>)updatedModules)).build();
    }

    private BundleModule updateRuntimeEnabledSdkConfig(BundleModule module) {
        if (module.getRuntimeEnabledSdkConfig().isPresent()) {
            return module.toBuilder().setRuntimeEnabledSdkConfig(this.updateRuntimeEnabledSdkConfig(module.getRuntimeEnabledSdkConfig().get())).build();
        }
        return module;
    }

    private RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig updateRuntimeEnabledSdkConfig(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig config) {
        RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig.Builder configBuilder = config.toBuilder();
        configBuilder.getRuntimeEnabledSdkBuilderList().forEach(this::updateRuntimeEnabledSdk);
        return configBuilder.build();
    }

    private void updateRuntimeEnabledSdk(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk.Builder runtimeEnabledSdkBuilder) {
        String sdkPackageName = runtimeEnabledSdkBuilder.getPackageName();
        if (this.certificateOverridesBySdkName.containsKey((Object)sdkPackageName)) {
            runtimeEnabledSdkBuilder.setCertificateDigest((String)this.certificateOverridesBySdkName.get((Object)sdkPackageName));
        } else if (!this.defaultCertificateOverride.isEmpty()) {
            runtimeEnabledSdkBuilder.setCertificateDigest(this.defaultCertificateOverride);
        }
    }

    private static ImmutableMap<String, String> unnestCertificateOverrides(RuntimeEnabledSdkConfigProto.LocalDeploymentRuntimeEnabledSdkConfig localRuntimeEnabledSdkConfig) {
        return (ImmutableMap)localRuntimeEnabledSdkConfig.getCertificateOverrides().getPerSdkCertificateOverrideList().stream().collect(ImmutableMap.toImmutableMap(RuntimeEnabledSdkConfigProto.CertificateOverride::getSdkPackageName, RuntimeEnabledSdkConfigProto.CertificateOverride::getCertificateDigest));
    }

    private ImmutableMap<String, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk> getAllRuntimeEnabledSdkDependencies(ImmutableList<BundleModule> modules) {
        return (ImmutableMap)modules.stream().filter((Predicate<BundleModule> & Serializable)module -> module.getRuntimeEnabledSdkConfig().isPresent()).map((Function<BundleModule, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig> & Serializable)module -> module.getRuntimeEnabledSdkConfig().get()).flatMap((Function<RuntimeEnabledSdkConfigProto.RuntimeEnabledSdkConfig, Stream> & Serializable)runtimeEnabledSdkConfig -> runtimeEnabledSdkConfig.getRuntimeEnabledSdkList().stream()).collect(ImmutableMap.toImmutableMap(RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk::getPackageName, Function.identity()));
    }
}

