/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.io.ByteSource;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;

public final class BinaryArtProfilesInjector {
    static final String APK_LOCATION = "assets/dexopt";
    static final String METADATA_NAMESPACE = "com.android.tools.build.profiles";
    static final String LEGACY_METADATA_NAMESPACE = "assets.dexopt";
    static final String BINARY_ART_PROFILE_NAME = "baseline.prof";
    static final String BINARY_ART_PROFILE_METADATA_NAME = "baseline.profm";
    private final Optional<ByteSource> binaryArtProfile;
    private final Optional<ByteSource> binaryArtProfileMetadata;

    public BinaryArtProfilesInjector(AppBundle appBundle) {
        this.binaryArtProfile = BinaryArtProfilesInjector.extract(appBundle.getBundleMetadata(), BINARY_ART_PROFILE_NAME);
        this.binaryArtProfileMetadata = BinaryArtProfilesInjector.extract(appBundle.getBundleMetadata(), BINARY_ART_PROFILE_METADATA_NAME);
    }

    public ModuleSplit inject(ModuleSplit split) {
        if (!this.binaryArtProfileMetadata.isPresent() && !this.binaryArtProfile.isPresent()) {
            return split;
        }
        if (!BinaryArtProfilesInjector.shouldInjectBinaryArtProfile(split)) {
            return split;
        }
        ModuleSplit.Builder builder = split.toBuilder();
        this.binaryArtProfile.ifPresent((Consumer<ByteSource> & Serializable)content -> builder.addEntry(ModuleEntry.builder().setForceUncompressed(true).setContent((ByteSource)content).setPath(ZipPath.create(APK_LOCATION).resolve(BINARY_ART_PROFILE_NAME)).build()));
        this.binaryArtProfileMetadata.ifPresent((Consumer<ByteSource> & Serializable)content -> builder.addEntry(ModuleEntry.builder().setForceUncompressed(true).setContent((ByteSource)content).setPath(ZipPath.create(APK_LOCATION).resolve(BINARY_ART_PROFILE_METADATA_NAME)).build()));
        return builder.build();
    }

    private static boolean shouldInjectBinaryArtProfile(ModuleSplit split) {
        return split.getSplitType().equals((Object)ModuleSplit.SplitType.STANDALONE) || split.isMasterSplit() && split.isBaseModuleSplit();
    }

    private static Optional<ByteSource> extract(BundleMetadata metadata, String entryName) {
        Optional<ByteSource> entry = metadata.getFileAsByteSource(METADATA_NAMESPACE, entryName);
        return entry.isPresent() ? entry : metadata.getFileAsByteSource(LEGACY_METADATA_NAMESPACE, entryName);
    }
}

