/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.transparency.ApkSignatureVerifier;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.transparency.CodeTransparencyFactory;
import com.android.tools.build.bundletool.transparency.CodeTransparencyVersion;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jose4j.jws.JsonWebSignature;

public final class ApkTransparencyCheckUtils {
    private static final String TRANSPARENCY_FILE_ZIP_ENTRY_NAME = "META-INF/code_transparency_signed.jwt";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransparencyCheckResult checkTransparency(ImmutableList<Path> deviceSpecificApks) {
        Optional<Path> baseApkPath = ApkTransparencyCheckUtils.getBaseApkPath(deviceSpecificApks);
        if (!baseApkPath.isPresent()) {
            throw InvalidCommandException.builder().withInternalMessage("The provided list of device specific APKs must either contain a single APK, or, if multiple APK files are present, base.apk file.").build();
        }
        TransparencyCheckResult.Builder result = TransparencyCheckResult.builder();
        ApkSignatureVerifier.Result apkSignatureVerificationResult = ApkSignatureVerifier.verify(deviceSpecificApks);
        if (!apkSignatureVerificationResult.verified()) {
            return result.errorMessage("Verification failed: " + apkSignatureVerificationResult.getErrorMessage()).build();
        }
        result.apkSigningKeyCertificateFingerprint(apkSignatureVerificationResult.getApkSigningKeyCertificateFingerprint());
        try (ZipFile baseApkFile = ZipUtils.openZipFile(baseApkPath.get());){
            Optional<ZipEntry> transparencyFileEntry = Optional.ofNullable(baseApkFile.getEntry(TRANSPARENCY_FILE_ZIP_ENTRY_NAME));
            if (!transparencyFileEntry.isPresent()) {
                throw InvalidCommandException.builder().withInternalMessage("Could not verify code transparency because transparency file is not present in the APK.").build();
            }
            JsonWebSignature jws = CodeTransparencyCryptoUtils.parseJws(ZipUtils.asByteSource(baseApkFile, transparencyFileEntry.get()));
            boolean signatureVerified = CodeTransparencyCryptoUtils.verifySignature(jws);
            if (!signatureVerified) {
                TransparencyCheckResult transparencyCheckResult2 = result.errorMessage("Verification failed because code transparency signature is invalid.").build();
                return transparencyCheckResult2;
            }
            result.transparencySignatureVerified(true).transparencyKeyCertificateFingerprint(CodeTransparencyCryptoUtils.getCertificateFingerprint(jws));
            CodeTransparencyOuterClass.CodeTransparency codeTransparencyMetadata = CodeTransparencyFactory.parseFrom(jws.getUnverifiedPayload());
            CodeTransparencyVersion.checkVersion(codeTransparencyMetadata);
            ImmutableSet<String> pathsToModifiedFiles = ApkTransparencyCheckUtils.getModifiedFiles(codeTransparencyMetadata, deviceSpecificApks);
            result.fileContentsVerified(pathsToModifiedFiles.isEmpty());
            if (!pathsToModifiedFiles.isEmpty()) {
                result.errorMessage("Verification failed because code was modified after code transparency metadata generation. Modified files: " + pathsToModifiedFiles);
            }
            TransparencyCheckResult transparencyCheckResult = result.build();
            return transparencyCheckResult;
        }
        catch (IOException e11) {
            throw new UncheckedIOException("An error occurred when processing the file.", e11);
        }
    }

    private static Optional<Path> getBaseApkPath(ImmutableList<Path> apkPaths) {
        if (apkPaths.size() == 1) {
            return ((Path)apkPaths.get(0)).getFileName().toString().endsWith(".apk") ? Optional.of((Path)apkPaths.get(0)) : Optional.empty();
        }
        return apkPaths.stream().filter((Predicate<Path> & Serializable)apkPath -> apkPath.getFileName().toString().equals("base.apk")).findAny();
    }

    private static ImmutableSet<String> getModifiedFiles(CodeTransparencyOuterClass.CodeTransparency codeTransparencyMetadata, ImmutableList<Path> allApkPaths) {
        ImmutableSet.Builder pathsToModifiedFilesBuilder = ImmutableSet.builder();
        for (Path apkPath : allApkPaths) {
            try {
                ZipFile apkFile = ZipUtils.openZipFile(apkPath);
                try {
                    pathsToModifiedFilesBuilder.addAll(ApkTransparencyCheckUtils.getModifiedDexFiles(apkFile, codeTransparencyMetadata));
                    pathsToModifiedFilesBuilder.addAll(ApkTransparencyCheckUtils.getModifiedNativeLibraries(apkFile, codeTransparencyMetadata));
                }
                finally {
                    if (apkFile == null) continue;
                    apkFile.close();
                }
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        }
        return pathsToModifiedFilesBuilder.build();
    }

    private static ImmutableSet<String> getModifiedDexFiles(ZipFile apkFile, CodeTransparencyOuterClass.CodeTransparency codeTransparencyMetadata) {
        ImmutableSet<String> expectedDexFiles = ApkTransparencyCheckUtils.getDexFiles(codeTransparencyMetadata);
        ImmutableSet.Builder pathsToModifiedFilesBuilder = ImmutableSet.builder();
        apkFile.stream().forEach((Consumer<? extends ZipEntry>)(Consumer<ZipEntry> & Serializable)zipEntry -> {
            String fileHash = ApkTransparencyCheckUtils.getFileHash(apkFile, zipEntry);
            if (ApkTransparencyCheckUtils.isDexFile(zipEntry) && !expectedDexFiles.contains((Object)fileHash)) {
                pathsToModifiedFilesBuilder.add((Object)zipEntry.getName());
            }
        });
        return pathsToModifiedFilesBuilder.build();
    }

    private static ImmutableSet<String> getModifiedNativeLibraries(ZipFile apkFile, CodeTransparencyOuterClass.CodeTransparency codeTransparencyMetadata) {
        ImmutableMap<String, String> expectedNativeLibrariesByApkPath = ApkTransparencyCheckUtils.getNativeLibrariesByApkPath(codeTransparencyMetadata);
        ImmutableSet.Builder pathsToModifiedFilesBuilder = ImmutableSet.builder();
        apkFile.stream().forEach((Consumer<? extends ZipEntry>)(Consumer<ZipEntry> & Serializable)zipEntry -> {
            String fileHash = ApkTransparencyCheckUtils.getFileHash(apkFile, zipEntry);
            if (ApkTransparencyCheckUtils.isNativeLibrary(zipEntry) && !Optional.ofNullable((String)expectedNativeLibrariesByApkPath.get((Object)zipEntry.getName())).equals(Optional.of(fileHash))) {
                pathsToModifiedFilesBuilder.add((Object)zipEntry.getName());
            }
        });
        return pathsToModifiedFilesBuilder.build();
    }

    private static ImmutableSet<String> getDexFiles(CodeTransparencyOuterClass.CodeTransparency codeTransparency) {
        return (ImmutableSet)codeTransparency.getCodeRelatedFileList().stream().filter(ApkTransparencyCheckUtils::isDexFile).map(CodeTransparencyOuterClass.CodeRelatedFile::getSha256).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableMap<String, String> getNativeLibrariesByApkPath(CodeTransparencyOuterClass.CodeTransparency codeTransparency) {
        return (ImmutableMap)codeTransparency.getCodeRelatedFileList().stream().filter((Predicate<CodeTransparencyOuterClass.CodeRelatedFile> & Serializable)codeRelatedFile -> codeRelatedFile.getType().equals((Object)CodeTransparencyOuterClass.CodeRelatedFile.Type.NATIVE_LIBRARY)).collect(ImmutableMap.toImmutableMap(CodeTransparencyOuterClass.CodeRelatedFile::getApkPath, CodeTransparencyOuterClass.CodeRelatedFile::getSha256));
    }

    private static boolean isDexFile(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith(".dex");
    }

    private static boolean isDexFile(CodeTransparencyOuterClass.CodeRelatedFile codeRelatedFile) {
        return codeRelatedFile.getType().equals((Object)CodeTransparencyOuterClass.CodeRelatedFile.Type.DEX) || codeRelatedFile.getType().equals((Object)CodeTransparencyOuterClass.CodeRelatedFile.Type.TYPE_UNSPECIFIED) && codeRelatedFile.getPath().endsWith(".dex");
    }

    private static boolean isNativeLibrary(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith(".so");
    }

    private static String getFileHash(ZipFile apkFile, ZipEntry zipEntry) {
        try {
            return ZipUtils.asByteSource(apkFile, zipEntry).hash(Hashing.sha256()).toString();
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
    }

    private ApkTransparencyCheckUtils() {
    }
}

