/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

public final class PathUtils {
    private static final int EMPTY_DIRECTORY_DELETION_ATTEMPTS = 10;

    private PathUtils() {
    }

    public static void deleteRecursivelyIfExists(Path path) throws IOException {
        block18: {
            if (NioFileInterceptors.intercept_isDirectory((Path)path, (LinkOption[])new LinkOption[0], (String)"shadow.bundletool.com.android.utils.PathUtils") && !Files.isSymbolicLink(path)) {
                try (Stream pathsInDir = NioFileInterceptors.intercept_list((Path)path, (String)"shadow.bundletool.com.android.utils.PathUtils");){
                    Iterator iterator2 = pathsInDir.iterator();
                    while (iterator2.hasNext()) {
                        PathUtils.deleteRecursivelyIfExists((Path)iterator2.next());
                    }
                }
            }
            try {
                try {
                    Files.deleteIfExists(path);
                }
                catch (AccessDeniedException exception) {
                    path.toFile().setWritable(true);
                    Files.deleteIfExists(path);
                }
            }
            catch (DirectoryNotEmptyException exception) {
                int failedAttempts;
                for (failedAttempts = 1; failedAttempts < 10; ++failedAttempts) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e11) {
                        Thread.currentThread().interrupt();
                        throw new IOException(e11);
                    }
                    try {
                        Files.deleteIfExists(path);
                        break;
                    }
                    catch (DirectoryNotEmptyException e12) {
                        continue;
                    }
                }
                if (failedAttempts < 10) break block18;
                throw new RuntimeException(String.format("Unable to delete directory '%s' after %d attempts", path.toString(), failedAttempts), exception);
            }
        }
    }

    public static String toSystemIndependentPath(Path path) {
        String filePath = path.toString();
        if (!path.getFileSystem().getSeparator().equals("/")) {
            return filePath.replace(path.getFileSystem().getSeparator(), "/");
        }
        return filePath;
    }

    public static Path createTmpToRemoveOnShutdown(String prefix) throws IOException {
        Path tmpFile = Files.createTempFile(prefix, "", new FileAttribute[0]);
        PathUtils.addRemovePathHook(tmpFile);
        return tmpFile;
    }

    public static Path createTmpDirToRemoveOnShutdown(String prefix) throws IOException {
        Path tmpDir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        PathUtils.addRemovePathHook(tmpDir);
        return tmpDir;
    }

    public static List<Path> getClassPathItems(String classPath) {
        Iterable components = Splitter.on((String)File.pathSeparator).split((CharSequence)classPath);
        ArrayList classPathJars = Lists.newArrayList();
        PathMatcher zipOrJar = FileSystems.getDefault().getPathMatcher(String.format("glob:**{%s,%s}", "zip", "jar"));
        for (String component : components) {
            Path componentPath = Paths.get(component, new String[0]);
            if (NioFileInterceptors.intercept_isRegularFile((Path)componentPath, (LinkOption[])new LinkOption[0], (String)"shadow.bundletool.com.android.utils.PathUtils")) {
                classPathJars.add(componentPath);
                continue;
            }
            try {
                Stream<Path> paths = Files.walk(componentPath, new FileVisitOption[0]);
                try {
                    paths.filter(zipOrJar::matches).forEach(classPathJars::add);
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException iOException) {}
        }
        return classPathJars;
    }

    public static void addRemovePathHook(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable & Serializable)() -> {
            try {
                PathUtils.deleteRecursivelyIfExists(path);
            }
            catch (IOException e11) {
                Logger.getLogger(PathUtils.class.getName()).log(Level.WARNING, "Unable to delete " + path, e11);
            }
        }));
    }
}

