/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TraceUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);

    public static String getCurrentStack() {
        return TraceUtils.getCurrentStack(1);
    }

    public static String getCurrentStack(int numberOfTopFramesToRemove) {
        int pos;
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            Throwable throwable = new Throwable(){

                @Override
                public String toString() {
                    return "";
                }
            };
            throwable.printStackTrace(writer);
        }
        String fullStack = stringWriter.toString();
        int start = 0;
        if (numberOfTopFramesToRemove < 0) {
            numberOfTopFramesToRemove = 0;
        }
        for (int i11 = 0; i11 < numberOfTopFramesToRemove + 2 && (pos = fullStack.indexOf(10, start)) >= 0; ++i11) {
            start = pos + 1;
        }
        return fullStack.substring(start);
    }

    public static String getStackTrace(Throwable t11) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            t11.printStackTrace(writer);
            String string = stringWriter.toString();
            return string;
        }
    }

    public static String getSimpleId(Object obj) {
        return obj == null ? "null" : String.format("%s@%08X", obj.getClass().getSimpleName(), System.identityHashCode(obj));
    }

    public static String currentTime() {
        return DATE_FORMAT.format(new Date());
    }

    private TraceUtils() {
    }
}

