/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexUtilsKt;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import kotlin.jvm.functions.Function1;
import org.gradle.internal.classpath.declarations.NioFileInterceptors;

final class NonIncrementalJarDexArchive
implements DexArchive {
    private static final FileTime ZERO_TIME = FileTime.fromMillis(0L);
    private final Path targetPath;
    private JarOutputStream jarOutputStream;

    public NonIncrementalJarDexArchive(Path targetPath) throws IOException {
        this.targetPath = targetPath;
        this.jarOutputStream = NioFileInterceptors.intercept_isRegularFile((Path)targetPath, (LinkOption[])new LinkOption[0], (String)"com.android.builder.dexing.NonIncrementalJarDexArchive") ? null : new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(targetPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW)));
    }

    @Override
    public Path getRootPath() {
        return this.targetPath;
    }

    @Override
    public void addFile(String relativePath, byte[] bytes, int offset, int end) throws IOException {
        Preconditions.checkNotNull((Object)this.jarOutputStream, (String)"Archive is not writeable : %s", (Object)this.targetPath);
        CRC32 checksum = new CRC32();
        checksum.update(bytes, offset, end);
        ZipEntry zipEntry = new ZipEntry(relativePath);
        zipEntry.setLastModifiedTime(ZERO_TIME);
        zipEntry.setLastAccessTime(ZERO_TIME);
        zipEntry.setCreationTime(ZERO_TIME);
        zipEntry.setCrc(checksum.getValue());
        zipEntry.setSize(end - offset);
        zipEntry.setCompressedSize(end - offset);
        zipEntry.setMethod(0);
        this.jarOutputStream.putNextEntry(zipEntry);
        this.jarOutputStream.write(bytes, offset, end);
        this.jarOutputStream.flush();
        this.jarOutputStream.closeEntry();
    }

    @Override
    public List<DexArchiveEntry> getSortedDexArchiveEntries() {
        Preconditions.checkState((this.jarOutputStream == null ? 1 : 0) != 0, (String)"Archive is not for reading: %s", (Object)this.targetPath);
        SortedMap<String, byte[]> dexEntries = DexUtilsKt.getSortedRelativePathsInJarWithContents(this.targetPath.toFile(), (Function1<? super String, Boolean>)(Function1 & Serializable)relativePath -> relativePath.toLowerCase(Locale.ENGLISH).endsWith(".dex"));
        ArrayList<DexArchiveEntry> dexArchiveEntries = new ArrayList<DexArchiveEntry>(dexEntries.size());
        for (String relativePath2 : dexEntries.keySet()) {
            dexArchiveEntries.add(new DexArchiveEntry((byte[])dexEntries.get(relativePath2), relativePath2, this));
        }
        return dexArchiveEntries;
    }

    @Override
    public void close() throws IOException {
        if (this.jarOutputStream != null) {
            this.jarOutputStream.flush();
            this.jarOutputStream.close();
        }
    }
}

