/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.internal.packaging.ApkFlinger;
import com.android.builder.internal.packaging.DexIncrementalRenameManager;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.builder.internal.packaging.PackagedFileUpdates;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kotlin.text.StringsKt;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class IncrementalPackager
implements Closeable {
    public static final String APP_METADATA_FILE_NAME = "app-metadata.properties";
    public static final String APP_METADATA_ENTRY_PATH = "META-INF/com/android/build/gradle/app-metadata.properties";
    public static final String VERSION_CONTROL_INFO_FILE_NAME = "version-control-info.textproto";
    public static final String VERSION_CONTROL_INFO_ENTRY_PATH = "META-INF/version-control-info.textproto";
    private ApkCreator mApkCreator;
    private final ApkCreatorFactory.CreationData mCreationData;
    private final ApkCreatorFactory mApkCreatorFactory;
    private final boolean mIsDebuggableBuild;
    private final boolean mDeterministicEntryOrder;
    private final boolean mEnableV3Signing;
    private final boolean mEnableV4Signing;
    private boolean mClosed;
    private final DexIncrementalRenameManager mDexRenamer;
    private final NativeLibraryAbiPredicate mAbiPredicate;
    private final Map<RelativeFile, FileStatus> mChangedDexFiles;
    private final Map<RelativeFile, FileStatus> mChangedJavaResources;
    private final List<SerializableChange> mChangedAssets;
    private final Map<RelativeFile, FileStatus> mChangedAndroidResources;
    private final Map<RelativeFile, FileStatus> mChangedNativeLibs;
    private final List<SerializableChange> mChangedAppMetadata;
    private final List<SerializableChange> mChangedArtProfile;
    private final List<SerializableChange> mChangedArtProfileMetadata;
    private final List<SerializableChange> mChangedVersionControlInfo;

    private ApkCreator getApkCreator() {
        if (this.mApkCreator == null) {
            int compressionLevel = this.mIsDebuggableBuild ? 1 : -1;
            this.mApkCreator = new ApkFlinger(this.mCreationData, compressionLevel, this.mDeterministicEntryOrder, this.mEnableV3Signing, this.mEnableV4Signing);
        }
        return this.mApkCreator;
    }

    public IncrementalPackager(ApkCreatorFactory.CreationData creationData, File intermediateDir, ApkCreatorFactory factory, Set<String> acceptedAbis, boolean jniDebugMode, boolean debuggableBuild, boolean deterministicEntryOrder, boolean enableV3Signing, boolean enableV4Signing, Map<RelativeFile, FileStatus> changedDexFiles, Map<RelativeFile, FileStatus> changedJavaResources, List<SerializableChange> changedAssets, Map<RelativeFile, FileStatus> changedAndroidResources, Map<RelativeFile, FileStatus> changedNativeLibs, List<SerializableChange> changedAppMetadata, List<SerializableChange> changedArtProfile, List<SerializableChange> changedArtProfileMetadata, List<SerializableChange> changedVersionControlInfo) throws IOException {
        if (!FileInterceptorsDeclaration.intercept_isDirectory((File)intermediateDir, (String)"com.android.builder.internal.packaging.IncrementalPackager")) {
            throw new IllegalArgumentException("!intermediateDir.isDirectory(): " + intermediateDir);
        }
        IncrementalPackager.checkOutputFile(creationData.getApkPath());
        this.mCreationData = creationData;
        this.mApkCreatorFactory = factory;
        this.mIsDebuggableBuild = debuggableBuild;
        this.mDeterministicEntryOrder = deterministicEntryOrder;
        this.mEnableV3Signing = enableV3Signing;
        this.mEnableV4Signing = enableV4Signing;
        this.mClosed = false;
        this.mChangedDexFiles = changedDexFiles;
        this.mChangedJavaResources = changedJavaResources;
        this.mChangedAssets = changedAssets;
        this.mChangedAndroidResources = changedAndroidResources;
        this.mChangedNativeLibs = changedNativeLibs;
        this.mChangedAppMetadata = changedAppMetadata;
        this.mDexRenamer = new DexIncrementalRenameManager(intermediateDir);
        this.mAbiPredicate = new NativeLibraryAbiPredicate(acceptedAbis, jniDebugMode);
        this.mChangedArtProfile = changedArtProfile;
        this.mChangedArtProfileMetadata = changedArtProfileMetadata;
        this.mChangedVersionControlInfo = changedVersionControlInfo;
    }

    public void updateFiles() throws IOException {
        ArrayList<PackagedFileUpdate> packagedFileUpdates = new ArrayList<PackagedFileUpdate>();
        packagedFileUpdates.addAll(this.mDexRenamer.update(this.mChangedDexFiles));
        packagedFileUpdates.addAll(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(this.mChangedJavaResources, (com.google.common.base.Predicate & Serializable)rf2 -> !rf2.getRelativePath().endsWith(".class"))));
        packagedFileUpdates.addAll(PackagedFileUpdates.fromIncrementalRelativeFileSet(this.mChangedAndroidResources));
        packagedFileUpdates.addAll(PackagedFileUpdates.fromIncrementalRelativeFileSet(Maps.filterKeys(this.mChangedNativeLibs, (com.google.common.base.Predicate & Serializable)rf2 -> this.mAbiPredicate.test(rf2.getRelativePath()))));
        packagedFileUpdates.addAll(IncrementalPackager.getAppMetadataUpdates(this.mChangedAppMetadata));
        packagedFileUpdates.addAll(IncrementalPackager.getArtProfileUpdates(this.mChangedArtProfile));
        packagedFileUpdates.addAll(IncrementalPackager.getArtProfileMetadataUpdates(this.mChangedArtProfileMetadata));
        packagedFileUpdates.addAll(IncrementalPackager.getVersionControlInfoUpdates(this.mChangedVersionControlInfo));
        this.deleteFiles(packagedFileUpdates);
        this.updateSingleEntryJars(this.mChangedAssets);
        this.addFiles(packagedFileUpdates);
    }

    private void updateSingleEntryJars(Collection<SerializableChange> changes) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"IncrementalPackager has already been closed.");
        Predicate<SerializableChange> & Serializable deletePredicate = (Predicate<SerializableChange> & Serializable)it -> it.getFileStatus() == FileStatus.REMOVED || it.getFileStatus() == FileStatus.CHANGED;
        Iterable deletedJars = changes.stream().filter(deletePredicate).map(SerializableChange::getNormalizedPath).collect(Collectors.toList());
        for (String deletedJar : deletedJars) {
            Preconditions.checkState((boolean)deletedJar.endsWith(".jar"));
            this.getApkCreator().deleteFile(StringsKt.removeSuffix((String)deletedJar, (CharSequence)".jar"));
        }
        Predicate<SerializableChange> & Serializable isNewOrChanged = (Predicate<SerializableChange> & Serializable)it -> it.getFileStatus() == FileStatus.NEW || it.getFileStatus() == FileStatus.CHANGED;
        Iterable addedJars = changes.stream().filter(isNewOrChanged).map(SerializableChange::getFile).collect(Collectors.toList());
        for (File addedJar : addedJars) {
            this.getApkCreator().writeZip(addedJar, null, null);
        }
    }

    private static List<PackagedFileUpdate> getAppMetadataUpdates(Collection<SerializableChange> changes) {
        return changes.stream().map((Function<SerializableChange, PackagedFileUpdate> & Serializable)change -> new PackagedFileUpdate(new RelativeFile(change.getFile().getParentFile(), change.getFile()), APP_METADATA_ENTRY_PATH, change.getFileStatus())).collect(Collectors.toList());
    }

    private static List<PackagedFileUpdate> getArtProfileUpdates(Collection<SerializableChange> changes) {
        return changes.stream().map((Function<SerializableChange, PackagedFileUpdate> & Serializable)change -> new PackagedFileUpdate(new RelativeFile(change.getFile().getParentFile(), change.getFile()), "assets/dexopt/baseline.prof", change.getFileStatus())).collect(Collectors.toList());
    }

    private static List<PackagedFileUpdate> getArtProfileMetadataUpdates(Collection<SerializableChange> changes) {
        return changes.stream().map((Function<SerializableChange, PackagedFileUpdate> & Serializable)change -> new PackagedFileUpdate(new RelativeFile(change.getFile().getParentFile(), change.getFile()), "assets/dexopt/baseline.profm", change.getFileStatus())).collect(Collectors.toList());
    }

    private static List<PackagedFileUpdate> getVersionControlInfoUpdates(Collection<SerializableChange> changes) {
        return changes.stream().map((Function<SerializableChange, PackagedFileUpdate> & Serializable)change -> new PackagedFileUpdate(new RelativeFile(change.getFile().getParentFile(), change.getFile()), VERSION_CONTROL_INFO_ENTRY_PATH, change.getFileStatus())).collect(Collectors.toList());
    }

    private void deleteFiles(Collection<PackagedFileUpdate> updates) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"IncrementalPackager has already been closed.");
        Predicate<PackagedFileUpdate> & Serializable deletePredicate = (Predicate<PackagedFileUpdate> & Serializable)p11 -> p11.getStatus() == FileStatus.REMOVED || p11.getStatus() == FileStatus.CHANGED;
        Iterable deletedPaths = updates.stream().filter(deletePredicate).map(PackagedFileUpdate::getName).collect(Collectors.toList());
        for (String deletedPath : deletedPaths) {
            this.getApkCreator().deleteFile(deletedPath);
        }
    }

    private void addFiles(Collection<PackagedFileUpdate> updates) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"IncrementalPackager has already been closed.");
        Predicate<PackagedFileUpdate> & Serializable isNewOrChanged = (Predicate<PackagedFileUpdate> & Serializable)pfu -> pfu.getStatus() == FileStatus.NEW || pfu.getStatus() == FileStatus.CHANGED;
        Iterable newOrChangedNonArchiveFiles = updates.stream().filter((Predicate<PackagedFileUpdate> & Serializable)pfu -> pfu.getSource().getType() == RelativeFile.Type.DIRECTORY && isNewOrChanged.test(pfu)).collect(Collectors.toList());
        for (PackagedFileUpdate rf2 : newOrChangedNonArchiveFiles) {
            File out = rf2.getSource().getFile();
            this.getApkCreator().writeFile(out, rf2.getName());
        }
        Iterable newOrChangedArchiveFiles = updates.stream().filter((Predicate<PackagedFileUpdate> & Serializable)pfu -> pfu.getSource().getType() == RelativeFile.Type.JAR && isNewOrChanged.test(pfu)).collect(Collectors.toList());
        Set archives = StreamSupport.stream(newOrChangedArchiveFiles.spliterator(), false).map((Function<PackagedFileUpdate, File> & Serializable)pfu -> pfu.getSource().getBase()).collect(Collectors.toSet());
        HashSet names = Sets.newHashSet((Iterable)Iterables.transform((Iterable)newOrChangedArchiveFiles, PackagedFileUpdate::getName));
        HashMap pathNameMap = Maps.newHashMap();
        for (PackagedFileUpdate archiveUpdate : newOrChangedArchiveFiles) {
            pathNameMap.put(archiveUpdate.getSource().getRelativePath(), archiveUpdate.getName());
        }
        for (File arch : archives) {
            this.getApkCreator().writeZip(arch, pathNameMap::get, (com.google.common.base.Predicate & Serializable)name -> !names.contains(name));
        }
    }

    private static void checkOutputFile(File file) throws IOException {
        if (FileInterceptorsDeclaration.intercept_isDirectory((File)file, (String)"com.android.builder.internal.packaging.IncrementalPackager")) {
            throw new IOException(String.format("'%s' is a directory", file.getAbsolutePath()));
        }
        if (FileInterceptorsDeclaration.intercept_exists((File)file, (String)"com.android.builder.internal.packaging.IncrementalPackager")) {
            if (!file.canWrite()) {
                throw new IOException(String.format("'%s' is not writeable", file.getAbsolutePath()));
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()));
                }
                if (!file.delete()) {
                    throw new IOException(String.format("Failed to delete newly created '%s'", file.getAbsolutePath()));
                }
            }
            catch (IOException e11) {
                throw new IOException(String.format("Failed to create '%s'", file.getAbsolutePath()), e11);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try (Closer closer = Closer.create();){
            if (!this.mCreationData.isIncremental()) {
                this.getApkCreator();
            }
            closer.register((Closeable)this.mApkCreator);
            closer.register((Closeable)this.mDexRenamer);
            this.mClosed = true;
        }
    }
}

