/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.DuplicateRelativeFileException;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.MergeOutputWriter;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class IncrementalFileMergerOutputs {
    private IncrementalFileMergerOutputs() {
    }

    public static IncrementalFileMergerOutput fromAlgorithmAndWriter(final StreamMergeAlgorithm algorithm, final MergeOutputWriter writer) {
        return new IncrementalFileMergerOutput(){

            @Override
            public void open() {
                writer.open();
            }

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void remove(String path) {
                writer.remove(path);
            }

            @Override
            public void create(String path, List<IncrementalFileMergerInput> inputs, boolean compress) {
                try (Closer closer = Closer.create();){
                    List inStreams = inputs.stream().map((Function<IncrementalFileMergerInput, InputStream> & Serializable)i11 -> i11.openPath(path)).collect(Collectors.toList());
                    InputStream mergedStream = algorithm.merge(path, (List<InputStream>)ImmutableList.copyOf(inStreams), closer);
                    writer.create(path, mergedStream, compress);
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(e11);
                }
                catch (DuplicateRelativeFileException e12) {
                    throw new DuplicateRelativeFileException(inputs, e12);
                }
            }

            @Override
            public void update(String path, List<String> prevInputNames, List<IncrementalFileMergerInput> inputs, boolean compress) {
                try (Closer closer = Closer.create();){
                    List inStreams = inputs.stream().map((Function<IncrementalFileMergerInput, InputStream> & Serializable)i11 -> i11.openPath(path)).collect(Collectors.toList());
                    InputStream mergedStream = algorithm.merge(path, (List<InputStream>)ImmutableList.copyOf(inStreams), closer);
                    writer.replace(path, mergedStream, compress);
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(e11);
                }
            }
        };
    }
}

