/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.files.RelativeFile;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public class LazyIncrementalFileMergerInput
implements IncrementalFileMergerInput {
    private final String name;
    @VisibleForTesting
    final CachedSupplier<Map<RelativeFile, FileStatus>> updates;
    @VisibleForTesting
    final CachedSupplier<ImmutableMap<String, RelativeFile>> updatePaths;
    @VisibleForTesting
    final CachedSupplier<ImmutableMap<String, RelativeFile>> filePaths;
    @VisibleForTesting
    final CachedSupplier<ImmutableSet<File>> zips;
    Map<File, ZFile> openZips;

    public LazyIncrementalFileMergerInput(String name, CachedSupplier<Map<RelativeFile, FileStatus>> updates, CachedSupplier<Set<RelativeFile>> files) {
        this.name = name;
        this.updates = updates;
        this.updatePaths = new CachedSupplier((Supplier & Serializable)() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (Map.Entry e11 : ((Map)updates.get()).entrySet()) {
                pathsBuilder.put((Object)((RelativeFile)e11.getKey()).getRelativePath(), (Object)((RelativeFile)e11.getKey()));
            }
            return pathsBuilder.build();
        });
        this.filePaths = new CachedSupplier((Supplier & Serializable)() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (RelativeFile rf2 : (Set)files.get()) {
                pathsBuilder.put((Object)rf2.getRelativePath(), (Object)rf2);
            }
            return pathsBuilder.build();
        });
        this.zips = new CachedSupplier((Supplier & Serializable)() -> {
            HashSet<File> zips = new HashSet<File>();
            HashSet<File> visitedZips = new HashSet<File>();
            for (RelativeFile rf2 : (Set)files.get()) {
                if (rf2.getType() != RelativeFile.Type.JAR || visitedZips.contains(rf2.getBase())) continue;
                visitedZips.add(rf2.getBase());
                if (!FileInterceptorsDeclaration.intercept_isFile((File)rf2.getBase(), (String)"com.android.builder.merge.LazyIncrementalFileMergerInput")) continue;
                zips.add(rf2.getBase());
            }
            return ImmutableSet.copyOf(zips);
        });
        this.openZips = null;
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return ((ImmutableMap)this.updatePaths.get()).keySet();
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return ((ImmutableMap)this.filePaths.get()).keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileStatus getFileStatus(String path) {
        RelativeFile rf2 = (RelativeFile)((ImmutableMap)this.updatePaths.get()).get((Object)path);
        if (rf2 == null) {
            return null;
        }
        return (FileStatus)((Map)this.updates.get()).get(rf2);
    }

    @Override
    public InputStream openPath(String path) {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        RelativeFile rf2 = (RelativeFile)((ImmutableMap)this.filePaths.get()).get((Object)path);
        Preconditions.checkState((rf2 != null ? 1 : 0) != 0, (String)"Unknown file: %s", (Object)path);
        if (rf2.getType() == RelativeFile.Type.JAR) {
            ZFile zf2 = this.openZips.get(rf2.getBase());
            Preconditions.checkState((zf2 != null ? 1 : 0) != 0, (String)"Unknown base: %s", (Object)rf2.getBase().getName());
            StoredEntry entry = zf2.get(path);
            Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Unknown path %s in zip file %s", (Object)path, (Object)zf2.getFile().getAbsolutePath());
            try {
                return entry.open();
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        }
        try {
            File file = rf2.getFile();
            FileInputStream fileInputStream = new FileInputStream(file);
            FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)fileInputStream, (File)file, (String)"com.android.builder.merge.LazyIncrementalFileMergerInput");
            return fileInputStream;
        }
        catch (IOException e12) {
            throw new UncheckedIOException(e12);
        }
    }

    @Override
    public void open() {
        Preconditions.checkState((this.openZips == null ? 1 : 0) != 0, (Object)"input already open");
        HashMap<File, ZFile> open = new HashMap<File, ZFile>();
        UncheckedIOException failure = null;
        for (File f11 : (ImmutableSet)this.zips.get()) {
            try {
                ZFile zf2 = ZFile.openReadOnly((File)f11);
                open.put(f11, zf2);
            }
            catch (IOException e11) {
                failure = new UncheckedIOException(e11);
                break;
            }
        }
        if (failure != null) {
            for (ZFile zf3 : open.values()) {
                try {
                    zf3.close();
                }
                catch (IOException e12) {
                    failure.addSuppressed(e12);
                }
            }
            throw failure;
        }
        this.openZips = open;
    }

    @Override
    public void close() {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        try (Closer closer = Closer.create();){
            for (ZFile zf2 : this.openZips.values()) {
                closer.register((Closeable)zf2);
            }
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
        finally {
            this.openZips = null;
        }
    }
}

