/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.CombinedInputStream;
import com.android.builder.merge.DuplicateRelativeFileException;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.function.Function;

public final class StreamMergeAlgorithms {
    private StreamMergeAlgorithms() {
    }

    public static StreamMergeAlgorithm pickFirst() {
        return (StreamMergeAlgorithm & Serializable)(path, from, closer) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            from.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            return (InputStream)from.get(0);
        };
    }

    public static StreamMergeAlgorithm concat() {
        return (StreamMergeAlgorithm & Serializable)(path, from, closer) -> {
            CombinedInputStream mergedStream = new CombinedInputStream(from, true);
            closer.register((Closeable)mergedStream);
            return mergedStream;
        };
    }

    public static StreamMergeAlgorithm acceptOnlyOne() {
        return (StreamMergeAlgorithm & Serializable)(path, from, closer) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            from.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            if (from.size() > 1) {
                throw new DuplicateRelativeFileException(path, from.size());
            }
            return (InputStream)from.get(0);
        };
    }

    public static StreamMergeAlgorithm select(Function<String, StreamMergeAlgorithm> select) {
        return (StreamMergeAlgorithm & Serializable)(path, from, closer) -> {
            StreamMergeAlgorithm algorithm = (StreamMergeAlgorithm)select.apply(path);
            assert (algorithm != null);
            return algorithm.merge(path, from, closer);
        };
    }
}

