/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.gradle.internal.classpath.Instrumented;

public interface EnvironmentProvider {
    public static final DirectEnvironmentProvider DIRECT = new DirectEnvironmentProvider();

    public String getSystemProperty(String var1);

    public String getEnvVariable(String var1);

    default public FileSystem getFileSystem() {
        return FileSystems.getDefault();
    }

    @VisibleForTesting
    public static class DirectEnvironmentProvider
    implements EnvironmentProvider {
        @VisibleForTesting
        public FileSystem fileSystemOverrideForTests = null;

        @Override
        public String getSystemProperty(String key) {
            return Instrumented.systemProperty((String)key, (String)"com.android.utils.EnvironmentProvider$DirectEnvironmentProvider");
        }

        @Override
        public String getEnvVariable(String key) {
            return Instrumented.getenv((String)key, (String)"com.android.utils.EnvironmentProvider$DirectEnvironmentProvider");
        }

        @Override
        public FileSystem getFileSystem() {
            return this.fileSystemOverrideForTests != null ? this.fileSystemOverrideForTests : EnvironmentProvider.super.getFileSystem();
        }
    }
}

