/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.io;

import com.android.build.gradle.internal.cxx.io.FileFingerPrint;
import com.android.build.gradle.internal.cxx.io.IoStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.io.SynchronizeFile;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.GeneratedMessageV3;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.classpath.declarations.FileInputStreamInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.internal.classpath.declarations.KotlinFileExtensionsInterceptorsDeclaration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\"\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u001a\u0016\u0010\u0013\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u001a\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0015H\u0002\u001a\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0017\u001a2\u0010\u0019\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u001a\b\u0003\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u0003*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001f\u001a\u00020\u0003*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"SLOW_COPY_FILE_WARNING_THRESHOLD_BYTES", "", "areSameFileOrContent", "", "Lcom/android/build/gradle/internal/cxx/io/SynchronizeFile$Comparison;", "getAreSameFileOrContent", "(Lcom/android/build/gradle/internal/cxx/io/SynchronizeFile$Comparison;)Z", "fingerPrint", "Lcom/android/build/gradle/internal/cxx/io/FileFingerPrint;", "Ljava/io/File;", "getFingerPrint", "(Ljava/io/File;)Lcom/android/build/gradle/internal/cxx/io/FileFingerPrint;", "compareFileContents", "source", "destination", "compareBufferSize", "", "hardLinkOrCopyFile", "", "isSameFileOrContent", "realCreateLink", "Ljava/nio/file/Path;", "removeDuplicateFiles", "", "files", "synchronizeFile", "createLink", "Lkotlin/Function2;", "containsExactText", "text", "", "writeTextIfDifferent", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nIoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IoUtils.kt\ncom/android/build/gradle/internal/cxx/io/IoUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n1747#2,3:249\n*S KotlinDebug\n*F\n+ 1 IoUtils.kt\ncom/android/build/gradle/internal/cxx/io/IoUtilsKt\n*L\n198#1:249,3\n*E\n"})
public final class IoUtilsKt {
    private static final long SLOW_COPY_FILE_WARNING_THRESHOLD_BYTES = 0x6400000L;

    public static final void hardLinkOrCopyFile(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!FileInterceptorsDeclaration.intercept_isFile((File)source, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
            throw new IllegalStateException(("Could not hard link or copy '" + source + "' because it did not exist.").toString());
        }
        IoUtilsKt.synchronizeFile$default(source, destination, null, 4, null);
    }

    public static final void synchronizeFile(@NotNull File source, @NotNull File destination, @VisibleForTesting @NotNull Function2<? super Path, ? super Path, Unit> createLink) {
        SynchronizeFile.Outcome outcome;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(createLink, (String)"createLink");
        SynchronizeFile.Comparison comparison = IoUtilsKt.compareFileContents$default(source, destination, 0, 4, null);
        if (IoUtilsKt.getAreSameFileOrContent(comparison)) {
            outcome = SynchronizeFile.Outcome.SAME_FILE;
        } else {
            if (FileInterceptorsDeclaration.intercept_isFile((File)destination, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
                Files.deleteIfExists(destination.toPath());
            }
            if (!FileInterceptorsDeclaration.intercept_isFile((File)source, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
                outcome = SynchronizeFile.Outcome.DELETED_DESTINATION_BECAUSE_SOURCE_DID_NOT_EXIST;
            } else {
                SynchronizeFile.Outcome outcome2;
                if (!FileInterceptorsDeclaration.intercept_isDirectory((File)destination.getParentFile(), (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
                    destination.getParentFile().mkdirs();
                }
                try {
                    Path path = destination.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"destination.toPath()");
                    Path path2 = source.toPath().toRealPath(new LinkOption[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"source.toPath().toRealPath()");
                    createLink.invoke((Object)path, (Object)path2);
                    LoggingEnvironmentKt.infoln("hard linked " + source + " to " + destination, new Object[0]);
                    outcome2 = SynchronizeFile.Outcome.CREATED_HARD_LINK_FROM_SOURCE_TO_DESTINATION;
                }
                catch (IOException e) {
                    if (FileInterceptorsDeclaration.intercept_length((File)source, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt") > 0x6400000L) {
                        LoggingEnvironmentKt.warnln("Hard link from '" + source + "' to '" + destination + "' failed. Doing a slower copy instead.", new Object[0]);
                    }
                    FilesKt.copyTo$default((File)source, (File)destination, (boolean)true, (int)0, (int)4, null);
                    outcome2 = SynchronizeFile.Outcome.COPIED_FROM_SOURCE_TO_DESTINATION;
                }
                outcome = outcome2;
            }
        }
        SynchronizeFile.Outcome operationOutcome = outcome;
        LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>(source, destination, comparison, operationOutcome){
            final /* synthetic */ File $source;
            final /* synthetic */ File $destination;
            final /* synthetic */ SynchronizeFile.Comparison $comparison;
            final /* synthetic */ SynchronizeFile.Outcome $operationOutcome;
            {
                this.$source = $source;
                this.$destination = $destination;
                this.$comparison = $comparison;
                this.$operationOutcome = $operationOutcome;
                super(1);
            }

            @NotNull
            public final GeneratedMessageV3 invoke(@NotNull StringEncoder encoder) {
                Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                SynchronizeFile.Builder result2 = SynchronizeFile.newBuilder();
                result2.setWorkingDirectory(new File(".").getAbsolutePath());
                result2.setSourceFile(this.$source.getPath());
                result2.setDestinationFile(this.$destination.getPath());
                result2.setInitialFileComparison(this.$comparison);
                result2.setOutcome(this.$operationOutcome);
                SynchronizeFile synchronizeFile2 = result2.build();
                Intrinsics.checkNotNullExpressionValue((Object)synchronizeFile2, (String)"result.build()");
                return IoStructuredLogCodecKt.encode(synchronizeFile2, encoder);
            }
        }));
    }

    public static /* synthetic */ void synchronizeFile$default(File file, File file2, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = synchronizeFile.1.INSTANCE;
        }
        IoUtilsKt.synchronizeFile(file, file2, (Function2<? super Path, ? super Path, Unit>)function2);
    }

    private static final void realCreateLink(Path destination, Path source) {
        Files.createLink(destination, source);
    }

    public static final boolean isSameFileOrContent(@NotNull File source, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return IoUtilsKt.getAreSameFileOrContent(IoUtilsKt.compareFileContents$default(source, destination, 0, 4, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    @NotNull
    public static final SynchronizeFile.Comparison compareFileContents(@NotNull File source, @NotNull File destination, int compareBufferSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if ((Object)source == (Object)destination) {
            return SynchronizeFile.Comparison.SAME_PATH_BY_FILE_OBJECT_IDENTITY;
        }
        if (Intrinsics.areEqual((Object)source.getPath(), (Object)destination.getPath())) {
            return SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_LEXICAL_PATH;
        }
        if (Intrinsics.areEqual((Object)source.getCanonicalPath(), (Object)destination.getCanonicalPath())) {
            return SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_CANONICAL_PATH;
        }
        if (!FileInterceptorsDeclaration.intercept_isFile((File)source, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt") && !FileInterceptorsDeclaration.intercept_isFile((File)destination, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
            return SynchronizeFile.Comparison.SAME_SOURCE_AND_DESTINATION_DID_NOT_EXIST;
        }
        if (!FileInterceptorsDeclaration.intercept_isFile((File)source, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
            return SynchronizeFile.Comparison.NOT_SAME_SOURCE_DID_NOT_EXIST;
        }
        if (!FileInterceptorsDeclaration.intercept_isFile((File)destination, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
            return SynchronizeFile.Comparison.NOT_SAME_DESTINATION_DID_NOT_EXIST;
        }
        if (Files.isSameFile(source.toPath(), destination.toPath())) {
            return SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_FILE_SYSTEM_PROVIDER;
        }
        if (FileInterceptorsDeclaration.intercept_length((File)source, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt") != FileInterceptorsDeclaration.intercept_length((File)destination, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
            return SynchronizeFile.Comparison.NOT_SAME_LENGTH;
        }
        buffer1 = new byte[compareBufferSize];
        buffer2 = new byte[compareBufferSize];
        var20_5 = source;
        v0 = new FileInputStream(var20_5);
        FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)v0, (File)var20_5, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt");
        var5_6 = v0;
        var6_7 = null;
        try {
            input1 = (FileInputStream)var5_6;
            $i$a$-use-IoUtilsKt$compareFileContents$1 = false;
            var20_5 = destination;
            v1 = new FileInputStream(var20_5);
            FileInputStreamInterceptorsDeclaration.interceptFileInputStreamConstructor((FileInputStream)v1, (File)var20_5, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt");
            var9_12 = v1;
            var10_13 = null;
            input2 = (FileInputStream)var9_12;
            $i$a$-use-IoUtilsKt$compareFileContents$1$1 = false;
lbl40:
            // 2 sources

            while (true) {
                size1 = input1.read(buffer1);
                if (size1 == -1) {
                    var14_20 = SynchronizeFile.Comparison.SAME_CONTENT;
                }
                ** GOTO lbl-1000
                break;
            }
            {
                block24: {
                    catch (Throwable var11_15) {
                        var10_13 = var11_15;
                        throw var11_15;
                    }
                    catch (Throwable var11_16) {
                        CloseableKt.closeFinally((Closeable)var9_12, (Throwable)var10_13);
                        throw var11_16;
                    }
                    CloseableKt.closeFinally((Closeable)var9_12, (Throwable)var10_13);
                    var19_21 = var14_20;
                    return var19_21;
lbl-1000:
                    // 1 sources

                    {
                        size2 = input2.read(buffer2);
                        if (!(size1 == size2)) {
                            var16_22 = "Check failed.";
                            throw new IllegalStateException(var16_22.toString());
                        }
                        if (Arrays.equals(buffer1, buffer2)) break block24;
                        var17_23 = SynchronizeFile.Comparison.NOT_SAME_CONTENT;
                    }
                    CloseableKt.closeFinally((Closeable)var9_12, (Throwable)var10_13);
                    var18_24 = var17_23;
                    return var18_24;
                }
                ** try [egrp 5[TRYBLOCK] [10 : 354->378)] { 
lbl-1000:
                // 1 sources

                {
                    ** continue;
                }
            }
        }
lbl67:
        // 2 sources

        catch (Throwable var7_9) {
            var6_7 = var7_9;
            throw var7_9;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var5_6, (Throwable)var6_7);
        }
    }

    public static /* synthetic */ SynchronizeFile.Comparison compareFileContents$default(File file, File file2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return IoUtilsKt.compareFileContents(file, file2, n);
    }

    @NotNull
    public static final List<File> removeDuplicateFiles(@NotNull List<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (files2.size() < 2) {
            return files2;
        }
        List seen = new ArrayList();
        for (File file : files2) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = seen;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        File saw = (File)element$iv;
                        boolean bl2 = false;
                        if (!IoUtilsKt.isSameFileOrContent(saw, file)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            seen.add(file);
        }
        return seen;
    }

    public static final boolean writeTextIfDifferent(@NotNull File $this$writeTextIfDifferent, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTextIfDifferent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (IoUtilsKt.containsExactText($this$writeTextIfDifferent, text)) {
            return false;
        }
        $this$writeTextIfDifferent.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$writeTextIfDifferent, (String)text, null, (int)2, null);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsExactText(@NotNull File $this$containsExactText, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$containsExactText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!FileInterceptorsDeclaration.intercept_isFile((File)$this$containsExactText, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) return false;
        if (!Intrinsics.areEqual((Object)text, (Object)KotlinFileExtensionsInterceptorsDeclaration.intercept_readText((File)$this$containsExactText, null, (int)1, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt"))) return false;
        return true;
    }

    @NotNull
    public static final FileFingerPrint getFingerPrint(@NotNull File $this$fingerPrint) {
        Intrinsics.checkNotNullParameter((Object)$this$fingerPrint, (String)"<this>");
        FileFingerPrint.Builder fingerPrint = FileFingerPrint.newBuilder();
        fingerPrint.setFileName($this$fingerPrint.getPath());
        fingerPrint.setIsFile(FileInterceptorsDeclaration.intercept_isFile((File)$this$fingerPrint, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt"));
        if (!FileInterceptorsDeclaration.intercept_isFile((File)$this$fingerPrint, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt")) {
            FileFingerPrint fileFingerPrint = fingerPrint.build();
            Intrinsics.checkNotNullExpressionValue((Object)fileFingerPrint, (String)"fingerPrint.build()");
            return fileFingerPrint;
        }
        fingerPrint.setLastModified($this$fingerPrint.lastModified());
        fingerPrint.setLength(FileInterceptorsDeclaration.intercept_length((File)$this$fingerPrint, (String)"com.android.build.gradle.internal.cxx.io.IoUtilsKt"));
        FileFingerPrint fileFingerPrint = fingerPrint.build();
        Intrinsics.checkNotNullExpressionValue((Object)fileFingerPrint, (String)"fingerPrint.build()");
        return fileFingerPrint;
    }

    private static final boolean getAreSameFileOrContent(SynchronizeFile.Comparison $this$areSameFileOrContent) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$areSameFileOrContent.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(("Unrecognized comparison code: " + $this$areSameFileOrContent).toString());
            }
        }
        return bl;
    }

    public static final /* synthetic */ void access$realCreateLink(Path destination, Path source) {
        IoUtilsKt.realCreateLink(destination, source);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SynchronizeFile.Comparison.values().length];
            try {
                nArray[SynchronizeFile.Comparison.NOT_SAME_SOURCE_DID_NOT_EXIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.NOT_SAME_DESTINATION_DID_NOT_EXIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.NOT_SAME_LENGTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.NOT_SAME_CONTENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.SAME_SOURCE_AND_DESTINATION_DID_NOT_EXIST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.SAME_PATH_BY_FILE_OBJECT_IDENTITY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_LEXICAL_PATH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_FILE_SYSTEM_PROVIDER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.SAME_PATH_ACCORDING_TO_CANONICAL_PATH.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SynchronizeFile.Comparison.SAME_CONTENT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

