/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.bundle.SdkMetadataOuterClass;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.tools.build.bundletool.model.RuntimeEnabledSdkVersionEncoder;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToManifestSnippetTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/tasks/AsarToManifestSnippetTransform$Parameters;", "()V", "asar", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getAsar", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "gradle-core"})
public abstract class AsarToManifestSnippetTransform
implements TransformAction<Parameters> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getAsar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs2) {
        Intrinsics.checkNotNullParameter((Object)outputs2, (String)"outputs");
        File asarFile = ((FileSystemLocation)this.getAsar().get()).getAsFile();
        Closeable closeable = new ZipFile(asarFile);
        Throwable throwable = null;
        try {
            ZipFile it = (ZipFile)closeable;
            boolean bl = false;
            File file = ((FileSystemLocation)this.getAsar().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asar.get().asFile");
            Path outputFile = outputs2.file((Object)(FilesKt.getNameWithoutExtension((File)file) + "-privacy-sandbox-sdk-dependency-manifest-snippet.xml")).toPath();
            Function1 block2 = (Function1)new Function1<InputStream, Unit>(this, outputFile){
                final /* synthetic */ AsarToManifestSnippetTransform this$0;
                final /* synthetic */ Path $outputFile;
                {
                    this.this$0 = $receiver;
                    this.$outputFile = $outputFile;
                    super(1);
                }

                public final void invoke(@NotNull InputStream protoBytes) {
                    Intrinsics.checkNotNullParameter((Object)protoBytes, (String)"protoBytes");
                    SdkMetadataOuterClass.SdkMetadata metadata = SdkMetadataOuterClass.SdkMetadata.parseFrom((InputStream)protoBytes);
                    int encodedVersion = RuntimeEnabledSdkVersionEncoder.encodeSdkMajorAndMinorVersion((int)metadata.getSdkVersion().getMajor(), (int)metadata.getSdkVersion().getMinor());
                    SigningConfigData signingConfigData = (SigningConfigData)((Parameters)this.this$0.getParameters()).getSigningConfigData().get();
                    CertificateInfo certInfo = KeystoreHelper.getCertificateInfo((String)signingConfigData.getStoreType(), (File)signingConfigData.getStoreFile(), (String)signingConfigData.getStorePassword(), (String)signingConfigData.getKeyPassword(), (String)signingConfigData.getKeyAlias());
                    String string = CodeTransparencyCryptoUtils.getCertificateFingerprint((X509Certificate)certInfo.getCertificate());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCertificateFingerprint(certInfo.certificate)");
                    String certificateDigest = StringsKt.replace$default((String)string, (char)' ', (char)':', (boolean)false, (int)4, null);
                    File file = this.$outputFile.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.toFile()");
                    FilesKt.writeText$default((File)file, (String)("<manifest\n    xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <application>\n        <uses-sdk-library\n            android:name=\"" + metadata.getPackageName() + "\"\n            android:certDigest=\"" + certificateDigest + "\"\n            android:versionMajor=\"" + encodedVersion + "\" />\n    </application>\n</manifest>\n"), null, (int)2, null);
                }
            };
            Closeable closeable2 = it.getInputStream(it.getEntry("SdkMetadata.pb"));
            Throwable throwable2 = null;
            try {
                Object object = block2.invoke((Object)closeable2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToManifestSnippetTransform$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "signingConfigData", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "getSigningConfigData", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @Nested
        @NotNull
        public Property<SigningConfigData> getSigningConfigData();
    }
}

