/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION, secondaryTaskCategories={TaskCategory.MANIFEST})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckManifest;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "fakeOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getFakeOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "manifestFile", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "manifestRequired", "", "doTaskAction", "", "isManifestRequiredButNotPresent", "CreationAction", "gradle-core"})
public abstract class CheckManifest
extends NonIncrementalTask {
    private boolean manifestRequired;
    private Provider<File> manifestFile;

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFakeOutputDir();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Input
    public final boolean isManifestRequiredButNotPresent() {
        if (!this.manifestRequired) return false;
        Provider<File> provider2 = this.manifestFile;
        if (provider2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
            provider2 = null;
        }
        if (FileInterceptorsDeclaration.intercept_isFile((File)((File)provider2.get()), (String)"com.android.build.gradle.internal.tasks.CheckManifest")) return false;
        return true;
    }

    @Override
    protected void doTaskAction() {
        if (this.isManifestRequiredButNotPresent()) {
            String string = this.getVariantName();
            Provider<File> provider2 = this.manifestFile;
            if (provider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
                provider2 = null;
            }
            String string2 = "Main manifest is missing for variant " + string + ". Expected path: " + ((File)provider2.get()).getAbsolutePath();
            throw new IllegalStateException(string2.toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckManifest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckManifest;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CheckManifest, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("check", "Manifest");
        }

        @Override
        @NotNull
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<CheckManifest> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getTaskContainer().setCheckManifestTask(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.CHECK_MANIFEST_RESULT.INSTANCE);
        }

        @Override
        public void configure(@NotNull CheckManifest task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.manifestRequired = this.creationConfig.getComponentType().getRequiresManifest();
            task.manifestFile = this.creationConfig.getSources().getManifestFile();
        }
    }
}

