/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.MergeClassesTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.packaging.JarFlinger;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Tasks that merge files into a directory/jar without further processing usually do not benefit from caching. Also, their outputs are usually large, which would consume a lot of space when cached.")
@BuildAnalyzer(primaryTaskCategory=TaskCategory.COMPILED_CLASSES, secondaryTaskCategories={TaskCategory.MERGING})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeClassesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "CreationAction", "MergeClassesWorkAction", "gradle-core"})
public abstract class MergeClassesTask
extends NonIncrementalTask {
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(MergeClassesWorkAction.class, new Action(this){
            final /* synthetic */ MergeClassesTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(MergeClassesWorkAction.Parameters it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                Object[] objectArray = new Object[]{this.this$0.getInputFiles()};
                it.getInputFiles().from(objectArray);
                it.getOutputFile().set((Provider)this.this$0.getOutputFile());
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeClassesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/MergeClassesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "inputFiles", "Lorg/gradle/api/file/FileCollection;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<MergeClassesTask, ComponentCreationConfig> {
        @NotNull
        private final Class<MergeClassesTask> type;
        @NotNull
        private final String name;
        @NotNull
        private final FileCollection inputFiles;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.type = MergeClassesTask.class;
            this.name = this.computeTaskName("merge", "Classes");
            this.inputFiles = creationConfig.getArtifacts().forScope(ScopedArtifacts.Scope.ALL).getFinalArtifacts$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE);
        }

        @Override
        @NotNull
        public Class<MergeClassesTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<MergeClassesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName(this.creationConfig.getComponentType().isBaseModule() ? "base.jar" : TaskManager.Companion.getFeatureFileName(this.creationConfig.getServices().getProjectInfo().getPath(), ".jar")).on(InternalArtifactType.MODULE_AND_RUNTIME_DEPS_CLASSES.INSTANCE);
        }

        @Override
        public void configure(@NotNull MergeClassesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{this.inputFiles};
            HasConfigurableValuesKt.fromDisallowChanges(task.getInputFiles(), objectArray);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeClassesTask$MergeClassesWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/MergeClassesTask$MergeClassesWorkAction$Parameters;", "()V", "run", "", "Parameters", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nMergeClassesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeClassesTask.kt\ncom/android/build/gradle/internal/tasks/MergeClassesTask$MergeClassesWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1855#2,2:126\n*S KotlinDebug\n*F\n+ 1 MergeClassesTask.kt\ncom/android/build/gradle/internal/tasks/MergeClassesTask$MergeClassesWorkAction\n*L\n80#1:126,2\n*E\n"})
    public static abstract class MergeClassesWorkAction
    extends ProfileAwareWorkAction<Parameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Closeable closeable = (Closeable)new JarFlinger(((File)((Parameters)this.getParameters()).getOutputFile().getAsFile().get()).toPath(), ClassFileInput.CLASS_MATCHER);
            Throwable throwable = null;
            try {
                JarFlinger out = (JarFlinger)closeable;
                boolean bl = false;
                out.setCompressionLevel(0);
                Iterable $this$forEach$iv = (Iterable)((Parameters)this.getParameters()).getInputFiles();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (FileInterceptorsDeclaration.intercept_isFile((File)it, (String)"com.android.build.gradle.internal.tasks.MergeClassesTask$MergeClassesWorkAction")) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                            out.addJar(it.toPath());
                            continue;
                        }
                    }
                    if (!FileInterceptorsDeclaration.intercept_isDirectory((File)it, (String)"com.android.build.gradle.internal.tasks.MergeClassesTask$MergeClassesWorkAction")) continue;
                    out.addDirectory(it.toPath());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeClassesTask$MergeClassesWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
        public static abstract class Parameters
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract ConfigurableFileCollection getInputFiles();

            @NotNull
            public abstract RegularFileProperty getOutputFile();
        }
    }
}

