/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.platform.mac.MacFileUtils;
import com.sun.jna.platform.win32.W32FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.declarations.FileInterceptorsDeclaration;

public abstract class FileUtils {
    public boolean hasTrash() {
        return false;
    }

    public abstract void moveToTrash(File ... var1) throws IOException;

    public static FileUtils getInstance() {
        return Holder.INSTANCE;
    }

    private static class DefaultFileUtils
    extends FileUtils {
        private DefaultFileUtils() {
        }

        private File getTrashDirectory() {
            File desktop;
            File home = new File(Instrumented.systemProperty((String)"user.home", (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils"));
            File trash = new File(home, ".Trash");
            if (!(FileInterceptorsDeclaration.intercept_exists((File)trash, (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils") || FileInterceptorsDeclaration.intercept_exists((File)(trash = new File(home, "Trash")), (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils") || !FileInterceptorsDeclaration.intercept_exists((File)(desktop = new File(home, "Desktop")), (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils") || FileInterceptorsDeclaration.intercept_exists((File)(trash = new File(desktop, ".Trash")), (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils") || FileInterceptorsDeclaration.intercept_exists((File)(trash = new File(desktop, "Trash")), (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils"))) {
                trash = new File(Instrumented.systemProperty((String)"fileutils.trash", (String)"Trash", (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils"));
            }
            return trash;
        }

        @Override
        public boolean hasTrash() {
            return FileInterceptorsDeclaration.intercept_exists((File)this.getTrashDirectory(), (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils");
        }

        @Override
        public void moveToTrash(File ... files) throws IOException {
            File trash = this.getTrashDirectory();
            if (!FileInterceptorsDeclaration.intercept_exists((File)trash, (String)"com.sun.jna.platform.FileUtils$DefaultFileUtils")) {
                throw new IOException("No trash location found (define fileutils.trash to be the path to the trash)");
            }
            ArrayList<File> failed = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File src = files[i];
                File target = new File(trash, src.getName());
                if (src.renameTo(target)) continue;
                failed.add(src);
            }
            if (failed.size() > 0) {
                throw new IOException("The following files could not be trashed: " + failed);
            }
        }
    }

    private static class Holder {
        public static final FileUtils INSTANCE;

        private Holder() {
        }

        static {
            String os = Instrumented.systemProperty((String)"os.name", (String)"com.sun.jna.platform.FileUtils$Holder");
            INSTANCE = os.startsWith("Windows") ? new W32FileUtils() : (os.startsWith("Mac") ? new MacFileUtils() : new DefaultFileUtils());
        }
    }
}

