/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.AaptResourceTypeKt;
import com.android.aaptcompiler.AllowNew;
import com.android.aaptcompiler.ArrayResource;
import com.android.aaptcompiler.AttributeResource;
import com.android.aaptcompiler.BasicString;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.ConfigDescription;
import com.android.aaptcompiler.FlattenedXml;
import com.android.aaptcompiler.Id;
import com.android.aaptcompiler.Item;
import com.android.aaptcompiler.Macro;
import com.android.aaptcompiler.Overlayable;
import com.android.aaptcompiler.OverlayableItem;
import com.android.aaptcompiler.ParsedParentInfo;
import com.android.aaptcompiler.ParsedResource;
import com.android.aaptcompiler.Plural;
import com.android.aaptcompiler.RawString;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.ResourceUtilsKt;
import com.android.aaptcompiler.Source;
import com.android.aaptcompiler.StringPool;
import com.android.aaptcompiler.Style;
import com.android.aaptcompiler.Styleable;
import com.android.aaptcompiler.StyledString;
import com.android.aaptcompiler.TableExtractor;
import com.android.aaptcompiler.TableExtractorKt;
import com.android.aaptcompiler.TableExtractorOptions;
import com.android.aaptcompiler.Value;
import com.android.aaptcompiler.Visibility;
import com.android.aaptcompiler.XmlStringBuilder;
import com.android.aaptcompiler.XmlUtilKt;
import com.android.aaptcompiler.android.ResValue;
import com.android.aaptcompiler.android.ResourceTypesKt;
import com.android.resources.ResourceVisibility;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010-\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010.\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u00102\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u0018H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u00105\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u00108\u001a\u00020+H\u0002J \u00109\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010:\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0002J \u0010;\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010<\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J2\u0010=\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020+H\u0002J \u0010B\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010C\u001a\u0004\u0018\u0001002\u0006\u0010 \u001a\u00020!2\u0006\u0010D\u001a\u000200H\u0002\u00a2\u0006\u0002\u0010EJ \u0010F\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010G\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010H\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010I\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010J\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010K\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020MH\u0002J \u0010N\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010O\u001a\u00020PH\u0002J \u0010Q\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010R\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010U\u001a\u00020\u0018H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006V"}, d2={"Lcom/android/aaptcompiler/TableExtractor;", "", "table", "Lcom/android/aaptcompiler/ResourceTable;", "source", "Lcom/android/aaptcompiler/Source;", "config", "Lcom/android/aaptcompiler/ConfigDescription;", "options", "Lcom/android/aaptcompiler/TableExtractorOptions;", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "(Lcom/android/aaptcompiler/ResourceTable;Lcom/android/aaptcompiler/Source;Lcom/android/aaptcompiler/ConfigDescription;Lcom/android/aaptcompiler/TableExtractorOptions;Lcom/android/aaptcompiler/BlameLogger;)V", "getConfig", "()Lcom/android/aaptcompiler/ConfigDescription;", "getLogger", "()Lcom/android/aaptcompiler/BlameLogger;", "getOptions", "()Lcom/android/aaptcompiler/TableExtractorOptions;", "getSource", "()Lcom/android/aaptcompiler/Source;", "getTable", "()Lcom/android/aaptcompiler/ResourceTable;", "addResourceToTable", "", "parsedResource", "Lcom/android/aaptcompiler/ParsedResource;", "extract", "", "inputFile", "Ljava/io/InputStream;", "extractResource", "element", "Ljavax/xml/stream/events/StartElement;", "eventReader", "Ljavax/xml/stream/XMLEventReader;", "extractResourceValues", "flattenXmlSubTree", "Lcom/android/aaptcompiler/FlattenedXml;", "startElement", "logError", "Lcom/android/aaptcompiler/BlameLogger$Source;", "message", "", "parseAddResource", "parseArray", "parseArrayImpl", "resourceFormat", "", "parseAttr", "parseAttrImpl", "isWeak", "parseConfigVarying", "parseDeclareStyleable", "parseEnumOrFlagItem", "Lcom/android/aaptcompiler/AttributeResource$Symbol;", "tag", "parseIntegerArray", "parseItem", "parseMacro", "parseOverlayable", "parseOverlayableItem", "policies", "overlayable", "Lcom/android/aaptcompiler/Overlayable;", "comment", "parsePlural", "parsePoliciesFromElement", "oldPolicies", "(Ljavax/xml/stream/events/StartElement;I)Ljava/lang/Integer;", "parsePublic", "parsePublicGroup", "parseString", "parseStringArray", "parseStyle", "parseStyleImpl", "type", "Lcom/android/aaptcompiler/AaptResourceType;", "parseStyleItem", "style", "Lcom/android/aaptcompiler/Style;", "parseSymbol", "parseSymbolImpl", "parseXml", "Lcom/android/aaptcompiler/Item;", "allowRawString", "aaptcompiler"})
@SourceDebugExtension(value={"SMAP\nTableExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableExtractor.kt\ncom/android/aaptcompiler/TableExtractor\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,2116:1\n151#2,6:2117\n163#2,6:2123\n*S KotlinDebug\n*F\n+ 1 TableExtractor.kt\ncom/android/aaptcompiler/TableExtractor\n*L\n560#1:2117,6\n561#1:2123,6\n*E\n"})
public final class TableExtractor {
    @NotNull
    private final ResourceTable table;
    @NotNull
    private final Source source;
    @NotNull
    private final ConfigDescription config;
    @NotNull
    private final TableExtractorOptions options;
    @NotNull
    private final BlameLogger logger;

    public TableExtractor(@NotNull ResourceTable table, @NotNull Source source, @NotNull ConfigDescription config, @NotNull TableExtractorOptions options, @NotNull BlameLogger logger) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.table = table;
        this.source = source;
        this.config = config;
        this.options = options;
        this.logger = logger;
    }

    @NotNull
    public final ResourceTable getTable() {
        return this.table;
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    @NotNull
    public final ConfigDescription getConfig() {
        return this.config;
    }

    @NotNull
    public final TableExtractorOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final BlameLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull InputStream inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        XMLEventReader eventReader = null;
        try {
            eventReader = XmlUtilKt.getXmlInputFactory().createXMLEventReader(inputFile);
            XMLEvent documentStart = eventReader.nextEvent();
            if (!documentStart.isStartDocument()) {
                String userReadableSource = ((Object)StringsKt.trim((CharSequence)this.logger.getOriginalSource(BlameLoggerKt.blameSource$default(this.source, null, null, 6, null)).toString())).toString();
                throw new IllegalStateException(("Failed to find start of XML " + userReadableSource).toString());
            }
            XMLEvent rootStart = null;
            while (eventReader.hasNext() && !(rootStart = eventReader.nextEvent()).isStartElement()) {
            }
            if (rootStart == null) {
                return;
            }
            QName rootName = rootStart.asStartElement().getName();
            if (rootName.getNamespaceURI() != null && !Intrinsics.areEqual((Object)rootName.getLocalPart(), (Object)"resources")) {
                String userReadableSource = ((Object)StringsKt.trim((CharSequence)this.logger.getOriginalSource(BlameLoggerKt.blameSource$default(this.source, null, null, 6, null)).toString())).toString();
                throw new IllegalStateException(("Root xml element of resource table not labeled 'resources' (" + userReadableSource + ").").toString());
            }
            this.extractResourceValues(eventReader);
        }
        catch (XMLStreamException xmlException) {
            String string = xmlException.getMessage();
            if (!(string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"Premature end of file.", (boolean)true) : false)) {
                throw xmlException;
            }
        }
        finally {
            XMLEventReader xMLEventReader = eventReader;
            if (xMLEventReader != null) {
                xMLEventReader.close();
            }
        }
    }

    private final void logError(BlameLogger.Source source, String message) {
        BlameLogger.error$default(this.logger, message, source, null, 4, null);
    }

    private final void extractResourceValues(XMLEventReader eventReader) {
        List errors = new ArrayList();
        String comment = "";
        while (eventReader.hasNext()) {
            Collection collection;
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 5) {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type javax.xml.stream.events.Comment");
                String string = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event as Comment).text");
                comment = ((Object)StringsKt.trim((CharSequence)string)).toString();
                continue;
            }
            if (event.isCharacters()) {
                if (event.asCharacters().isWhiteSpace()) continue;
                collection = errors;
                Location location = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.location");
                collection.add("Plain text is not allowed at " + BlameLoggerKt.blameSource(this.source, location) + ".");
                continue;
            }
            if (event.isEndElement()) break;
            if (!event.isStartElement()) {
                collection = errors;
                int n = event.getEventType();
                Location location = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.location");
                String string = "Unexpected element type: " + n + ", " + BlameLoggerKt.blameSource(this.source, location) + ".";
                collection.add(string);
            }
            StartElement element = event.asStartElement();
            QName elementName = element.getName();
            String string = elementName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"elementName.namespaceURI");
            if (((CharSequence)string).length() > 0) {
                StartElement startElement = element.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)startElement, (String)"element.asStartElement()");
                XmlUtilKt.walkToEndOfElement(startElement, eventReader);
                continue;
            }
            if (Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"skip") || Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"eat-comment")) {
                comment = "";
                StartElement startElement = element.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)startElement, (String)"element.asStartElement()");
                XmlUtilKt.walkToEndOfElement(startElement, eventReader);
                continue;
            }
            ParsedResource parsedResource = new ParsedResource(this.config, this.source.withLine(element.getLocation().getLineNumber()), comment);
            comment = "";
            Attribute productName = element.getAttributeByName(new QName("product"));
            if (productName != null) {
                String string2 = productName.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"productName.value");
                parsedResource.setProductString(string2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            if (!this.extractResource(element, eventReader, parsedResource)) {
                ((Collection)errors).add("Can not extract resource from " + parsedResource + ".");
            }
            if (this.addResourceToTable(parsedResource)) continue;
            ((Collection)errors).add("Can not add resource (" + parsedResource + ") to table.");
        }
        if (CollectionsKt.any((Iterable)errors)) {
            throw new IllegalStateException(CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)",", null, null, (int)0, null, null, (int)62, null).toString());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean extractResource(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        block103: {
            block101: {
                resourceTypeName = element.getName().getLocalPart();
                resourceFormat = 0;
                canBeItem = true;
                canBeBag = true;
                if (Intrinsics.areEqual((Object)resourceTypeName, (Object)"item")) {
                    canBeBag = false;
                    resourceFormat = 65535;
                    formatAttribute = element.getAttributeByName(new QName("format"));
                    if (formatAttribute != null) {
                        v0 = formatAttribute.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"formatAttribute.value");
                        resourceFormat = TableExtractorKt.parseFormatNoEnumsOrFlags(v0);
                        if (resourceFormat == 0) {
                            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Resource has an invalid format of " + formatAttribute.getValue() + ".");
                            XmlUtilKt.walkToEndOfElement(element, eventReader);
                            return false;
                        }
                    }
                    if ((typeAttribute = element.getAttributeByName(new QName("type"))) == null) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<item> must have a 'type' attribute");
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        return false;
                    }
                    resourceTypeName = typeAttribute.getValue();
                } else if (Intrinsics.areEqual((Object)resourceTypeName, (Object)"bag")) {
                    canBeItem = false;
                    typeAttribute = element.getAttributeByName(new QName("type"));
                    if (typeAttribute == null) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<bag> must have a 'type' attribute");
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        return false;
                    }
                }
                nameAttribute = element.getAttributeByName(new QName("name"));
                if (Intrinsics.areEqual((Object)resourceTypeName, (Object)"id")) {
                    if (nameAttribute == null) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<" + element.getName() + "> is missing the 'name' attribute.");
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        return false;
                    }
                    parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.ID, nameAttribute.getValue(), 1, null));
                    this.parseItem(element, eventReader, parsedResource, resourceFormat);
                    item /* !! */  = parsedResource.getValue();
                    if (item /* !! */  instanceof BasicString && ((CharSequence)((BasicString)item /* !! */ ).getRef().value()).length() == 0) {
                        parsedResource.setValue(new Id());
                    } else if (item /* !! */  instanceof Reference && ((Reference)item /* !! */ ).getId() == null) {
                        parsedResource.setValue(new Id());
                    } else if (item /* !! */  instanceof Reference && ((Reference)item /* !! */ ).getName().getType() != AaptResourceType.ID || !(item /* !! */  instanceof Reference)) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<" + element.getName() + "> inner element must either be a resource reference or empty.");
                        return false;
                    }
                    return true;
                }
                if (!canBeItem) break block101;
                var10_10 = resourceTypeName;
                if (var10_10 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var10_10.hashCode()) {
                    case -826507106: {
                        if (var10_10.equals("drawable")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 95588145: {
                        if (var10_10.equals("dimen")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 3029738: {
                        if (var10_10.equals("bool")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 94842723: {
                        if (var10_10.equals("color")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -891985903: {
                        if (var10_10.equals("string")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 1958052158: {
                        if (var10_10.equals("integer")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -280905010: {
                        if (var10_10.equals("configVarying")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case -1653751294: {
                        if (var10_10.equals("fraction")) {
                            tmp = 8;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        v1 = new Pair((Object)AaptResourceType.BOOL, (Object)8);
                        break;
                    }
                    case 4: {
                        v1 = new Pair((Object)AaptResourceType.COLOR, (Object)16);
                        break;
                    }
                    case 7: {
                        v1 = new Pair((Object)AaptResourceType.CONFIG_VARYING, (Object)65535);
                        break;
                    }
                    case 2: {
                        v1 = new Pair((Object)AaptResourceType.DIMEN, (Object)224);
                        break;
                    }
                    case 1: {
                        v1 = new Pair((Object)AaptResourceType.DRAWABLE, (Object)16);
                        break;
                    }
                    case 8: {
                        v1 = new Pair((Object)AaptResourceType.FRACTION, (Object)224);
                        break;
                    }
                    case 6: {
                        v1 = new Pair((Object)AaptResourceType.INTEGER, (Object)4);
                        break;
                    }
                    case 5: {
                        v1 = new Pair((Object)AaptResourceType.STRING, (Object)2);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v1 = new Pair(null, (Object)65535);
                    }
                }
                item /* !! */  = v1;
                type = (AaptResourceType)item /* !! */ .component1();
                typeMask = ((Number)item /* !! */ .component2()).intValue();
                if (type != null) {
                    if (nameAttribute == null) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<" + element.getName() + "> is missing the 'name' attribute.");
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        return false;
                    }
                    parsedResource.setName(new ResourceName("", type, nameAttribute.getValue()));
                    if (resourceFormat == 0) {
                        resourceFormat = typeMask;
                    }
                    return this.parseItem(element, eventReader, parsedResource, resourceFormat);
                }
            }
            if (!canBeBag) break block103;
            var10_10 = resourceTypeName;
            if (var10_10 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var10_10.hashCode()) {
                case 103652300: {
                    if (var10_10.equals("macro")) {
                        tmp = 1;
                    }
                    break;
                }
                case -887523944: {
                    if (var10_10.equals("symbol")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2129240330: {
                    if (var10_10.equals("integer-array")) {
                        tmp = 3;
                    }
                    break;
                }
                case -475309713: {
                    if (var10_10.equals("plurals")) {
                        tmp = 4;
                    }
                    break;
                }
                case -406376022: {
                    if (var10_10.equals("overlayable")) {
                        tmp = 5;
                    }
                    break;
                }
                case -280905010: {
                    if (var10_10.equals("configVarying")) {
                        tmp = 6;
                    }
                    break;
                }
                case -1024600675: {
                    if (var10_10.equals("string-array")) {
                        tmp = 7;
                    }
                    break;
                }
                case 2080961466: {
                    if (var10_10.equals("add-resource")) {
                        tmp = 8;
                    }
                    break;
                }
                case -565605861: {
                    if (var10_10.equals("public-group")) {
                        tmp = 9;
                    }
                    break;
                }
                case -977423767: {
                    if (var10_10.equals("public")) {
                        tmp = 10;
                    }
                    break;
                }
                case 93090393: {
                    if (var10_10.equals("array")) {
                        tmp = 11;
                    }
                    break;
                }
                case 32828323: {
                    if (var10_10.equals("java-symbol")) {
                        tmp = 12;
                    }
                    break;
                }
                case 109780401: {
                    if (var10_10.equals("style")) {
                        tmp = 13;
                    }
                    break;
                }
                case 3004913: {
                    if (var10_10.equals("attr")) {
                        tmp = 14;
                    }
                    break;
                }
                case 1909939688: {
                    if (var10_10.equals("declare-styleable")) {
                        tmp = 15;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 8: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseAddResource((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 11: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseArray((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 14: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseAttr((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 6: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseConfigVarying((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 15: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseDeclareStyleable((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 3: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseIntegerArray((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 12: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseSymbol((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 1: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseMacro((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 5: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseOverlayable((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 4: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parsePlural((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 10: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parsePublic((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 9: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parsePublicGroup((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 7: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseStringArray((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 13: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseStyle((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 2: {
                    v2 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>((Object)this){

                        @NotNull
                        public final Boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseSymbol((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v2 = parseBagMethod = null;
                }
            }
            if (parseBagMethod != null) {
                if (!Intrinsics.areEqual((Object)resourceTypeName, (Object)"public-group") && !Intrinsics.areEqual((Object)resourceTypeName, (Object)"overlayable")) {
                    if (nameAttribute == null) {
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<" + element.getName() + "> is missing the 'name' attribute.");
                        return false;
                    }
                    parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, null, nameAttribute.getValue(), 3, null));
                }
                return (Boolean)((Function3)parseBagMethod).invoke((Object)element, (Object)eventReader, (Object)parsedResource);
            }
        }
        if (canBeItem) {
            v3 = resourceTypeName;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"resourceTypeName");
            parsedType = AaptResourceTypeKt.resourceTypeFromTag(v3);
            if (parsedType != null) {
                if (nameAttribute == null) {
                    this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<" + element.getName() + "> is missing the 'name' attribute.");
                    XmlUtilKt.walkToEndOfElement(element, eventReader);
                    return false;
                }
                parsedResource.setName(new ResourceName("", parsedType, nameAttribute.getValue()));
                parsedResource.setValue(this.parseXml(element, eventReader, 1, false));
                if (parsedResource.getValue() == null) {
                    this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for type '" + parsedType.getTagName() + "'. Expected a reference.");
                    return false;
                }
                return true;
            }
        }
        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Unknown resource type '" + resourceTypeName + "'");
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return false;
    }

    private final Item parseXml(StartElement element, XMLEventReader eventReader, int resourceFormat, boolean allowRawString) {
        FlattenedXml flattenedXml = this.flattenXmlSubTree(element, eventReader);
        if (!flattenedXml.getSuccess()) {
            return null;
        }
        if (!((Collection)flattenedXml.getStyleString().getSpans()).isEmpty()) {
            return new StyledString(this.table.getStringPool().makeRef(flattenedXml.getStyleString(), new StringPool.Context(StringPool.Context.Priority.NORMAL.getPriority(), this.config)), flattenedXml.getUntranslatableSections());
        }
        Item processedItem2 = ResourceUtilsKt.tryParseItemForAttribute(flattenedXml.getRawString(), resourceFormat, (Function1<? super ResourceName, Boolean>)((Function1)new Function1<ResourceName, Boolean>(this){
            final /* synthetic */ TableExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ResourceName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Id id = new Id();
                id.setSource(this.this$0.getSource());
                return this.this$0.getTable().addResource(it, new ConfigDescription(null, 1, null), "", id);
            }
        }));
        if (processedItem2 != null) {
            if (processedItem2 instanceof Reference) {
                XmlUtilKt.resolvePackage(element, (Reference)processedItem2);
            }
            return processedItem2;
        }
        if ((resourceFormat & 2) != 0) {
            return new BasicString(this.table.getStringPool().makeRef(flattenedXml.getStyleString().getStr(), new StringPool.Context(0L, this.config, 1, null)), flattenedXml.getUntranslatableSections());
        }
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)flattenedXml.getRawString())).toString()).length() == 0) {
            return ResourceUtilsKt.makeNull();
        }
        if (allowRawString) {
            int n;
            int firstNonWrappingIndex;
            String raw2;
            block11: {
                int n2;
                int n3;
                Function1 isNotWrappingChar2;
                block10: {
                    raw2 = flattenedXml.getRawString();
                    boolean bl = false;
                    isNotWrappingChar2 = parseXml.raw.1.isNotWrappingChar.1.INSTANCE;
                    CharSequence $this$indexOfFirst$iv = raw2;
                    boolean $i$f$indexOfFirst = false;
                    n3 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n3; ++index$iv) {
                        if (!((Boolean)isNotWrappingChar2.invoke((Object)Character.valueOf($this$indexOfFirst$iv.charAt(index$iv)))).booleanValue()) continue;
                        n2 = index$iv;
                        break block10;
                    }
                    n2 = -1;
                }
                firstNonWrappingIndex = n2;
                CharSequence $this$indexOfLast$iv = raw2;
                boolean $i$f$indexOfLast = false;
                n3 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n3) {
                    do {
                        int index$iv;
                        if (!((Boolean)isNotWrappingChar2.invoke((Object)Character.valueOf($this$indexOfLast$iv.charAt(index$iv = n3--)))).booleanValue()) continue;
                        n = index$iv;
                        break block11;
                    } while (0 <= n3);
                }
                n = -1;
            }
            int lastNonWrappingIndex = n;
            String string = raw2.substring(firstNonWrappingIndex == -1 ? 0 : firstNonWrappingIndex, lastNonWrappingIndex == -1 ? 0 : lastNonWrappingIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String raw3 = StringsKt.removeSurrounding((String)string, (CharSequence)"\"");
            return new RawString(this.table.getStringPool().makeRef(raw3, new StringPool.Context(0L, this.config, 1, null)));
        }
        return null;
    }

    private final boolean parseItem(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, int resourceFormat) {
        if (resourceFormat == 2) {
            return this.parseString(element, eventReader, parsedResource);
        }
        parsedResource.setValue(this.parseXml(element, eventReader, resourceFormat, false));
        if (parsedResource.getValue() == null) {
            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid <" + parsedResource.getName().getType().getTagName() + "> for given resource value.");
            return false;
        }
        return true;
    }

    private final boolean parseString(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Item value;
        boolean formatted = true;
        Attribute formattedAttribute = element.getAttributeByName(new QName("formatted"));
        if (formattedAttribute != null) {
            String string = formattedAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formattedAttribute.value");
            Boolean maybeFormatted = ResourceUtilsKt.parseAsBool(string);
            if (maybeFormatted == null) {
                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for the 'formatted' attribute. Was '" + formattedAttribute.getValue() + "', must be a boolean.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            formatted = maybeFormatted;
        }
        boolean translatable = this.options.getTranslatable();
        Attribute translatableAttribute = element.getAttributeByName(new QName("translatable"));
        if (translatableAttribute != null) {
            String string = translatableAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translatableAttribute.value");
            Boolean maybeTranslatable = ResourceUtilsKt.parseAsBool(string);
            if (maybeTranslatable == null) {
                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for 'translatable' attribute. Was '" + translatableAttribute.getValue() + "', must be a boolean.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            translatable = maybeTranslatable;
        }
        if ((value = this.parseXml(element, eventReader, 2, false)) == null) {
            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), parsedResource.getName() + " does not contain a valid string resource.");
            return false;
        }
        if (value instanceof BasicString) {
            ((BasicString)value).setTranslatable(translatable);
            if (formatted && translatable && !ResourceUtilsKt.verifyJavaStringFormat(((BasicString)value).toString())) {
                String errorMsg = "Multiple substitutions specified in non-positional format of string resource " + parsedResource.getName() + ". Did you mean to add the formatted=\"false\" attribute?";
                if (this.options.getErrorOnPositionalArgs()) {
                    this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), errorMsg);
                    return false;
                }
                this.logger.warning(errorMsg, BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null));
            }
        } else if (value instanceof StyledString) {
            ((StyledString)value).setTranslatable(translatable);
        }
        parsedResource.setValue(value);
        return true;
    }

    private final AttributeResource.Symbol parseEnumOrFlagItem(StartElement element, XMLEventReader eventReader, String tag) {
        Source elementSource = this.source.withLine(element.getLocation().getLineNumber());
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        Attribute nameAttribute = element.getAttributeByName(new QName("name"));
        if (nameAttribute == null) {
            this.logError(BlameLoggerKt.blameSource$default(elementSource, null, null, 6, null), "No attribute 'name' found for tag <" + tag + ">.");
            return null;
        }
        Attribute valueAttribute = element.getAttributeByName(new QName("value"));
        if (valueAttribute == null) {
            this.logError(BlameLoggerKt.blameSource$default(elementSource, null, null, 6, null), "No attribute 'value' found for tag <" + tag + ">.");
            return null;
        }
        String string = valueAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueAttribute.value");
        ResValue resValue = ResourceTypesKt.stringToInt(string);
        if (resValue == null) {
            this.logError(BlameLoggerKt.blameSource$default(elementSource, null, null, 6, null), "Invalid value '" + resValue + "' for <" + tag + ">. Must be an integer.");
            return null;
        }
        Reference reference = new Reference(null, 1, null);
        reference.setName(new ResourceName("", AaptResourceType.ID, nameAttribute.getValue()));
        return new AttributeResource.Symbol(reference, resValue.getData(), resValue.getDataType().getByteValue());
    }

    private final boolean parseStyleItem(StartElement element, XMLEventReader eventReader, Style style) {
        Source itemSource = this.source.withLine(element.getLocation().getLineNumber());
        Attribute nameAttribute = element.getAttributeByName(new QName("name"));
        if (nameAttribute == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> must have a 'name' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        String string = nameAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAttribute.value");
        Reference key = ResourceUtilsKt.parseXmlAttributeName(string);
        XmlUtilKt.resolvePackage(element, key);
        key.setSource(itemSource);
        Item xmlItem = this.parseXml(element, eventReader, 0, true);
        if (xmlItem == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Could not parse style item with name '" + nameAttribute.getValue() + "'.");
            return false;
        }
        style.getEntries().add(new Style.Entry(key, xmlItem));
        return true;
    }

    private final FlattenedXml flattenXmlSubTree(StartElement startElement, XMLEventReader eventReader) {
        int depth = 1;
        XmlStringBuilder builder = new XmlStringBuilder(false, 1, null);
        while (depth > 0) {
            String string;
            QName elementName;
            XMLEvent element;
            XMLEvent event = eventReader.nextEvent();
            if (event.isCharacters()) {
                String string2 = event.asCharacters().getData();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.asCharacters().data");
                builder.append(string2);
                continue;
            }
            if (event.isStartElement()) {
                element = event.asStartElement();
                elementName = element.getName();
                string = elementName.getNamespaceURI();
                if (Intrinsics.areEqual((Object)string, (Object)"")) {
                    StringBuilder spanName = new StringBuilder(elementName.getLocalPart());
                    Iterator<Attribute> attributes = element.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute attribute;
                        Intrinsics.checkNotNull((Object)attributes.next(), (String)"null cannot be cast to non-null type javax.xml.stream.events.Attribute");
                        spanName.append(";" + attribute.getName().getLocalPart() + "=" + attribute.getValue());
                    }
                    String string3 = spanName.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"spanName.toString()");
                    builder.startSpan(string3);
                } else if (Intrinsics.areEqual((Object)string, (Object)"urn:oasis:names:tc:xliff:document:1.2")) {
                    if (Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"g")) {
                        builder.startUntranslatable();
                    }
                } else {
                    BlameLogger blameLogger = this.logger;
                    if (blameLogger != null) {
                        blameLogger.warning("Ignoring element '" + elementName + "' with unknown namespace '" + elementName.getNamespaceURI() + "'.", BlameLoggerKt.blameSource$default(this.source.withLine(element.getLocation().getLineNumber()), null, null, 6, null));
                    }
                }
                ++depth;
                continue;
            }
            if (!event.isEndElement()) continue;
            element = event.asEndElement();
            elementName = element.getName();
            --depth;
            string = elementName.getNamespaceURI();
            if (Intrinsics.areEqual((Object)string, (Object)"")) {
                if (depth == 0) continue;
                builder.endSpan();
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"urn:oasis:names:tc:xliff:document:1.2") || !Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"g")) continue;
            builder.endUntranslatable();
        }
        FlattenedXml flattenedXml = builder.getFlattenedXml();
        if (((CharSequence)builder.getError()).length() > 0) {
            String resourceName = startElement.getAttributeByName(new QName("name")).getValue();
            Location location = startElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"startElement.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Failed to flatten XML for resource '" + resourceName + "' with error: " + builder.getError());
        }
        return flattenedXml;
    }

    private final boolean parseSymbol(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        boolean error = false;
        if (this.options.getVisibility() != null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<java-symbol> and <symbol> tags are not supported with resource visibility.");
            error = true;
        }
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)new ConfigDescription(null, 1, null))) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
        }
        if (!this.parseSymbolImpl(element, eventReader, parsedResource)) {
            return false;
        }
        parsedResource.setVisibility(ResourceVisibility.PRIVATE);
        return !error;
    }

    private final boolean parseMacro(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.MACRO, null, 5, null));
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<macro> tags cannot be declared in configurations other than the default configuration");
            return false;
        }
        FlattenedXml flattenedXml = this.flattenXmlSubTree(element, eventReader);
        if (!flattenedXml.getSuccess()) {
            return false;
        }
        parsedResource.setValue(new Macro(flattenedXml.getRawString(), flattenedXml.getStyleString(), flattenedXml.getUntranslatableSections(), null, 8, null));
        return true;
    }

    private final boolean parseAddResource(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        if (this.parseSymbolImpl(element, eventReader, parsedResource)) {
            parsedResource.setVisibility(ResourceVisibility.UNDEFINED);
            parsedResource.setAllowNew(true);
            return true;
        }
        return false;
    }

    private final boolean parseSymbolImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Attribute typeAttribute = element.getAttributeByName(new QName("type"));
        if (typeAttribute == null) {
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<" + element.getName() + "> must have a 'type' attribute.");
            return false;
        }
        String string = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeAttribute.value");
        AaptResourceType parsedType = AaptResourceTypeKt.resourceTypeFromTag(string);
        if (parsedType == null) {
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid resource type '" + typeAttribute.getValue() + "' in <" + element.getName() + "> resource.");
            return false;
        }
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, parsedType, null, 5, null));
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return true;
    }

    private final boolean parseAttr(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseAttrImpl(element, eventReader, parsedResource, false);
    }

    private final boolean parseAttrImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, boolean isWeak) {
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.ATTR, null, 5, null));
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
            parsedResource.setConfig(defaultConfig);
        }
        int typeMask = 0;
        Attribute formatAttribute = element.getAttributeByName(new QName("format"));
        if (formatAttribute != null) {
            String string = formatAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatAttribute.value");
            typeMask = TableExtractorKt.parseFormatAttribute(string);
            if (typeMask == 0) {
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid attribute format '" + formatAttribute.getValue() + "'");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        Integer min = null;
        Integer max = null;
        Attribute minAttribute = element.getAttributeByName(new QName("min"));
        Attribute maxAttribute = element.getAttributeByName(new QName("max"));
        if (minAttribute != null) {
            ResValue minRes;
            String string = minAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"minAttribute.value");
            String minString = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)minString).length() > 0 && (minRes = ResourceTypesKt.stringToInt(minString)) != null) {
                min = minRes.getData();
            }
            if (min == null) {
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid 'min' value '" + minString + "'. Integer value required.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        if (maxAttribute != null) {
            ResValue maxRes;
            String string = maxAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"maxAttribute.value");
            String maxString = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)maxString).length() > 0 && (maxRes = ResourceTypesKt.stringToInt(maxString)) != null) {
                max = maxRes.getData();
            }
            if (max == null) {
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid 'max' value '" + maxString + "'. Integer value required.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        if ((min != null || max != null) && (typeMask & 4) == 0) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "'min' and 'max' attributes can only be used with format='integer' on <" + element.getName() + "> resource");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Map symbolMap = new LinkedHashMap();
        String comment = "";
        boolean error = false;
        while (eventReader.hasNext()) {
            block29: {
                QName childName;
                Source childSource;
                StartElement childElement;
                block24: {
                    block25: {
                        String symbolName;
                        AttributeResource.Symbol symbol;
                        block26: {
                            Object object;
                            Object newSource;
                            block28: {
                                block27: {
                                    XMLEvent event = eventReader.nextEvent();
                                    if (event.getEventType() == 5) {
                                        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type javax.xml.stream.events.Comment");
                                        String string = ((Comment)event).getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event as Comment).text");
                                        comment = ((Object)StringsKt.trim((CharSequence)string)).toString();
                                        continue;
                                    }
                                    if (event.isEndElement()) break;
                                    if (!event.isStartElement()) continue;
                                    childElement = event.asStartElement();
                                    childSource = this.source.withLine(event.getLocation().getLineNumber());
                                    childName = childElement.getName();
                                    String string = childName.getNamespaceURI();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"childName.namespaceURI");
                                    if (!(((CharSequence)string).length() == 0) || !Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"flag") && !Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"enum")) break block24;
                                    boolean itemError = false;
                                    String string2 = childName.getLocalPart();
                                    if (Intrinsics.areEqual((Object)string2, (Object)"enum")) {
                                        if ((typeMask & 0x20000) != 0) {
                                            Location location = childElement.getLocation();
                                            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                                            this.logError(BlameLoggerKt.blameSource(this.source, location), "Cannot define both <enum> and <flag> under the same <" + element.getName() + "> resource.");
                                            error = true;
                                            itemError = true;
                                        }
                                        typeMask |= 0x10000;
                                    } else if (Intrinsics.areEqual((Object)string2, (Object)"flag")) {
                                        if ((typeMask & 0x10000) != 0) {
                                            Location location = childElement.getLocation();
                                            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                                            this.logError(BlameLoggerKt.blameSource(this.source, location), "Cannot define both <enum> and <flag> under the same <" + element.getName() + "> resource.");
                                            error = true;
                                            itemError = true;
                                        }
                                        typeMask |= 0x20000;
                                    }
                                    if (itemError) continue;
                                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                                    String string3 = childName.getLocalPart();
                                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"childName.localPart");
                                    symbol = this.parseEnumOrFlagItem(childElement, eventReader, string3);
                                    if (symbol == null) break block25;
                                    ParsedResource childResource = new ParsedResource(defaultConfig, childSource, "");
                                    childResource.setName(symbol.getSymbol().getName());
                                    childResource.setValue(new Id());
                                    parsedResource.getChildren().add(childResource);
                                    symbol.getSymbol().setComment(comment);
                                    symbol.getSymbol().setSource(childSource);
                                    symbolName = symbol.getSymbol().getName().toString();
                                    if (!symbolMap.containsKey(symbolName)) break block26;
                                    Object object2 = this.logger;
                                    if (object2 == null || (object2 = ((BlameLogger)object2).getOriginalSource(BlameLoggerKt.blameSource$default(symbol.getSymbol().getSource(), null, null, 6, null))) == null) {
                                        object2 = newSource = BlameLoggerKt.blameSource$default(symbol.getSymbol().getSource(), null, null, 6, null);
                                    }
                                    if ((object = this.logger) == null) break block27;
                                    Object v = symbolMap.get(symbolName);
                                    Intrinsics.checkNotNull(v);
                                    if ((object = ((BlameLogger)object).getOriginalSource(BlameLoggerKt.blameSource$default(((AttributeResource.Symbol)v).getSymbol().getSource(), null, null, 6, null))) != null) break block28;
                                }
                                Object v = symbolMap.get(symbolName);
                                Intrinsics.checkNotNull(v);
                                object = BlameLoggerKt.blameSource$default(((AttributeResource.Symbol)v).getSymbol().getSource(), null, null, 6, null);
                            }
                            Object previousSource = object;
                            String errorMsg = "Duplicate symbol '" + symbolName + "' defined here: " + (BlameLogger.Source)newSource + " and here: " + (BlameLogger.Source)previousSource;
                            this.logError(BlameLoggerKt.blameSource$default(symbol.getSymbol().getSource(), null, null, 6, null), errorMsg);
                            error = true;
                        }
                        symbolMap.put(symbolName, symbol);
                        break block29;
                    }
                    error = true;
                    break block29;
                }
                Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
                if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                    this.logError(BlameLoggerKt.blameSource$default(childSource, null, null, 6, null), "Unrecognized tag <" + childName + "> of child element of <" + element.getName() + ">.");
                    error = true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
            }
            comment = "";
        }
        if (error) {
            return false;
        }
        AttributeResource resource = new AttributeResource(typeMask == 0 ? 65535 : typeMask, null, 2, null);
        resource.setWeak(isWeak);
        resource.getSymbols().addAll(symbolMap.values());
        Integer n = min;
        resource.setMinInt(n != null ? n : Integer.MIN_VALUE);
        Integer n2 = max;
        resource.setMaxInt(n2 != null ? n2 : Integer.MAX_VALUE);
        parsedResource.setValue(resource);
        return true;
    }

    private final boolean parseArray(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        int resourceFormat = 65535;
        Attribute formatAttribute = element.getAttributeByName(new QName("format"));
        if (formatAttribute != null) {
            String string = formatAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatAttribute.value");
            resourceFormat = TableExtractorKt.parseFormatNoEnumsOrFlags(string);
            if (resourceFormat == 0) {
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid format value: '" + formatAttribute.getValue() + "'.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        return this.parseArrayImpl(element, eventReader, parsedResource, resourceFormat);
    }

    private final boolean parseIntegerArray(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseArrayImpl(element, eventReader, parsedResource, 4);
    }

    private final boolean parseStringArray(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseArrayImpl(element, eventReader, parsedResource, 2);
    }

    private final boolean parseArrayImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, int resourceFormat) {
        XMLEvent event;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.ARRAY, null, 5, null));
        ArrayResource array = new ArrayResource();
        boolean translatable = this.options.getTranslatable();
        Attribute translatableAttribute = element.getAttributeByName(new QName("translatable"));
        if (translatableAttribute != null) {
            String string = translatableAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translatableAttribute.value");
            Boolean translatableValue = ResourceUtilsKt.parseAsBool(string);
            if (translatableValue == null) {
                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for 'translatable' attribute. Must be a boolean.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            translatable = translatableValue;
        }
        array.setTranslatable(translatable);
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            Source childSource = this.source.withLine(childElement.getLocation().getLineNumber());
            QName childName = childElement.getName();
            String string = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"childName.namespaceURI");
            if (((CharSequence)string).length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) {
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                Item childItem = this.parseXml(childElement, eventReader, resourceFormat, false);
                if (childItem != null) {
                    childItem.setSource(childSource);
                    array.getElements().add(childItem);
                    continue;
                }
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Could not parse array item.");
                error = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                this.logError(BlameLoggerKt.blameSource$default(childSource, null, null, 6, null), "Unknown tag <" + childName + "> in <" + element.getName() + "> resource.");
                error = true;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(array);
        return true;
    }

    private final boolean parseConfigVarying(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseStyleImpl(element, eventReader, parsedResource, AaptResourceType.CONFIG_VARYING);
    }

    private final boolean parseStyle(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseStyleImpl(element, eventReader, parsedResource, AaptResourceType.STYLE);
    }

    private final boolean parseStyleImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, AaptResourceType type) {
        XMLEvent event;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, type, null, 5, null));
        Style style = new Style();
        Attribute parentAttribute = element.getAttributeByName(new QName("parent"));
        if (parentAttribute != null) {
            String string = parentAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentAttribute.value");
            if (((CharSequence)string).length() > 0) {
                String string2 = parentAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parentAttribute.value");
                ParsedParentInfo parseResult = ResourceUtilsKt.parseStyleParentReference(string2);
                if (parseResult.getParent() == null) {
                    Location location = element.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), parseResult.getErrorString());
                    XmlUtilKt.walkToEndOfElement(element, eventReader);
                    return false;
                }
                style.setParent(parseResult.getParent());
                Reference reference = style.getParent();
                Intrinsics.checkNotNull((Object)reference);
                XmlUtilKt.resolvePackage(element, reference);
            }
        } else {
            String string = parsedResource.getName().getEntry();
            Intrinsics.checkNotNull((Object)string);
            String styleName = string;
            int marker = StringsKt.lastIndexOf$default((CharSequence)styleName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (marker != -1) {
                style.setParentInferred(true);
                String string3 = styleName.substring(0, marker);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                style.setParent(new Reference(new ResourceName("", AaptResourceType.STYLE, string3)));
            }
        }
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            String string = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"childName.namespaceURI");
            if (((CharSequence)string).length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) {
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                if (this.parseStyleItem(childElement, eventReader, style)) continue;
                error = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                Location location = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Unrecognized child element <" + childName + "> of <" + element.getName() + "> resource.");
                error = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(style);
        return true;
    }

    private final boolean parseDeclareStyleable(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.STYLEABLE, null, 5, null));
        parsedResource.setVisibility(ResourceVisibility.PUBLIC);
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
            parsedResource.setConfig(defaultConfig);
        }
        Styleable styleable = new Styleable();
        String comment = "";
        boolean error = false;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 5) {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type javax.xml.stream.events.Comment");
                String string = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event as Comment).text");
                comment = ((Object)StringsKt.trim((CharSequence)string)).toString();
                continue;
            }
            if (event.isEndElement()) break;
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            Source itemSource = this.source.withLine(childElement.getLocation().getLineNumber());
            String string = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"childName.namespaceURI");
            if (((CharSequence)string).length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"attr")) {
                Attribute nameAttribute = childElement.getAttributeByName(new QName("name"));
                if (nameAttribute == null) {
                    this.logError(BlameLoggerKt.blameSource$default(itemSource, null, null, 6, null), "<attr> tag must have a 'name' attribute.");
                    error = true;
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    continue;
                }
                String string2 = nameAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameAttribute.value");
                Reference nameReference = ResourceUtilsKt.parseXmlAttributeName(string2);
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.resolvePackage(childElement, nameReference);
                ParsedResource childResource = new ParsedResource(defaultConfig, itemSource, comment);
                childResource.setName(nameReference.getName());
                if (!this.parseAttrImpl(childElement, eventReader, childResource, true)) {
                    error = true;
                    continue;
                }
                nameReference.setComment(childResource.getComment());
                nameReference.setSource(itemSource);
                styleable.getEntries().add(nameReference);
                parsedResource.getChildren().add(childResource);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
                if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                    this.logError(BlameLoggerKt.blameSource$default(itemSource, null, null, 6, null), "Unknown tag of <" + childName + "> in <" + element.getName() + "> resource.");
                    error = true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
            }
            comment = "";
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(styleable);
        return true;
    }

    private final boolean parseOverlayable(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Attribute nameAttribute;
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
        }
        if ((nameAttribute = element.getAttributeByName(new QName(null, "name"))) == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<overlayable> tag must have a 'name' attribute");
            return false;
        }
        Attribute actorAttribute = element.getAttributeByName(new QName(null, "actor"));
        if (actorAttribute != null) {
            String string = actorAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actorAttribute.value");
            if (!StringsKt.startsWith$default((String)string, (String)"overlay://", (boolean)false, (int)2, null)) {
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "<overlayable> tag has a 'actor' attribute: '" + actorAttribute.getValue() + "'. Value must use the schema: overlay://.");
                return false;
            }
        }
        String string = nameAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAttribute.value");
        Attribute attribute = actorAttribute;
        String string2 = attribute != null ? attribute.getValue() : null;
        if (string2 == null) {
            string2 = "";
        }
        Overlayable overlayable = new Overlayable(string, string2, this.source);
        boolean error = false;
        String comment = "";
        int currentPolicies = 0;
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isEndElement()) {
                if (--depth == 0) break;
                currentPolicies = 0;
                continue;
            }
            if (event.getEventType() == 5) {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type javax.xml.stream.events.Comment");
                String string3 = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"event as Comment).text");
                comment = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                continue;
            }
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            if (Intrinsics.areEqual((Object)childName.getNamespaceURI(), (Object)"") && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) {
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                ParsedResource childResource = this.parseOverlayableItem(childElement, eventReader, currentPolicies, overlayable, comment);
                comment = "";
                if (childResource == null) {
                    error = true;
                    continue;
                }
                parsedResource.getChildren().add(childResource);
                continue;
            }
            if (Intrinsics.areEqual((Object)childName.getNamespaceURI(), (Object)"") && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"policy")) {
                ++depth;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                Integer newPolicy = this.parsePoliciesFromElement(childElement, currentPolicies);
                if (newPolicy == null) {
                    error = true;
                    currentPolicies = 0;
                } else {
                    currentPolicies = newPolicy;
                }
                comment = "";
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                Location location = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Unrecognized tag '" + childName + "' within an <overlayable> resource.");
                error = true;
                continue;
            }
            comment = "";
        }
        return !error;
    }

    private final ParsedResource parseOverlayableItem(StartElement element, XMLEventReader eventReader, int policies, Overlayable overlayable, String comment) {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (policies == 0) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> within an <overlayable> must be inside a <policy> block.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return null;
        }
        Attribute nameAttribute = element.getAttributeByName(new QName(null, "name"));
        if (nameAttribute == null || (charSequence2 = (CharSequence)nameAttribute.getValue()) == null || charSequence2.length() == 0) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> within an <overlayable> must have a 'name' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return null;
        }
        Attribute typeAttribute = element.getAttributeByName(new QName(null, "type"));
        if (typeAttribute == null || (charSequence = (CharSequence)typeAttribute.getValue()) == null || charSequence.length() == 0) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> within an <overlayable> must have a 'type' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return null;
        }
        String string = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeAttribute.value");
        AaptResourceType type = AaptResourceTypeKt.resourceTypeFromTag(string);
        if (type == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid resource type '" + typeAttribute.getValue() + "' in <item> in <overlayable> resource.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return null;
        }
        OverlayableItem overlayableItem = new OverlayableItem(overlayable, policies, comment, this.source.withLine(element.getLocation().getLineNumber()));
        ParsedResource childResource = new ParsedResource();
        childResource.setName(ResourceName.copy$default(childResource.getName(), null, type, nameAttribute.getValue(), 1, null));
        childResource.setOverlayableItem(overlayableItem);
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return childResource;
    }

    /*
     * Unable to fully structure code
     */
    private final Integer parsePoliciesFromElement(StartElement element, int oldPolicies) {
        if (oldPolicies != 0) {
            v0 = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, v0), "Policy blocks should not be nested recursively.");
            return null;
        }
        typeAttribute = element.getAttributeByName(new QName(null, "type"));
        if (typeAttribute == null || (var4_4 = (CharSequence)typeAttribute.getValue()) == null || var4_4.length() == 0) {
            v1 = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, v1), "<policy> must have a 'type' attribute.");
            return null;
        }
        newPolicy = 0;
        v2 = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"typeAttribute.value");
        var6_6 = new char[]{'|'};
        for (String string : StringsKt.split$default((CharSequence)v2, (char[])var6_6, (boolean)false, (int)0, (int)6, null)) {
            block22: {
                block21: {
                    block18: {
                        block20: {
                            block19: {
                                block17: {
                                    var7_8 = StringsKt.trim((CharSequence)string).toString();
                                    switch (var7_8.hashCode()) {
                                        case -309474065: {
                                            if (!var7_8.equals("product")) {
                                                ** break;
                                            }
                                            break block17;
                                        }
                                        case -887328209: {
                                            if (!var7_8.equals("system")) {
                                                ** break;
                                            }
                                            break block18;
                                        }
                                        case -977423767: {
                                            if (!var7_8.equals("public")) {
                                                ** break;
                                            }
                                            break block19;
                                        }
                                        case 1073584312: {
                                            if (!var7_8.equals("signature")) {
                                                ** break;
                                            }
                                            break block20;
                                        }
                                        case 109911: {
                                            if (var7_8.equals("oem")) break;
                                            ** break;
                                        }
                                        case -820075192: {
                                            if (!var7_8.equals("vendor")) {
                                                ** break;
                                            }
                                            break block21;
                                        }
                                        case 109880: {
                                            if (!var7_8.equals("odm")) ** break;
                                            v3 = 32;
                                            break block22;
                                        }
                                    }
                                    v3 = 64;
                                    break block22;
                                }
                                v3 = 8;
                                break block22;
                            }
                            v3 = 1;
                            break block22;
                        }
                        v3 = 16;
                        break block22;
                    }
                    v3 = 2;
                    break block22;
                }
                v3 = 4;
                break block22;
lbl63:
                // 8 sources

                v4 = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, v4), "<policy> has unsupported type '" + StringsKt.trim((CharSequence)string).toString() + "'.");
                return null;
            }
            newPolicy |= v3;
        }
        return newPolicy;
    }

    private final boolean parsePlural(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        XMLEvent event;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.PLURALS, null, 5, null));
        Plural plural = new Plural();
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            QName childName;
            StartElement childElement;
            block28: {
                Plural.Type pluralType;
                String trimmedQuantity;
                if (!event.isStartElement()) continue;
                childElement = event.asStartElement();
                childName = childElement.getName();
                String string = childName.getNamespaceURI();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"childName.namespaceURI");
                if (!(((CharSequence)string).length() == 0) || !Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) break block28;
                Attribute quantityAttribute = childElement.getAttributeByName(new QName("quantity"));
                if (quantityAttribute == null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> in <plurals> are required to have the 'quantity' attribute.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                String string2 = quantityAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quantityAttribute.value");
                switch (trimmedQuantity = ((Object)StringsKt.trim((CharSequence)string2)).toString()) {
                    case "zero": {
                        Plural.Type type = Plural.Type.ZERO;
                        break;
                    }
                    case "one": {
                        Plural.Type type = Plural.Type.ONE;
                        break;
                    }
                    case "two": {
                        Plural.Type type = Plural.Type.TWO;
                        break;
                    }
                    case "few": {
                        Plural.Type type = Plural.Type.FEW;
                        break;
                    }
                    case "many": {
                        Plural.Type type = Plural.Type.MANY;
                        break;
                    }
                    case "other": {
                        Plural.Type type = Plural.Type.OTHER;
                        break;
                    }
                    default: {
                        Plural.Type type = pluralType = null;
                    }
                }
                if (pluralType == null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "Unrecognized quantity value '" + trimmedQuantity + "' specified in <item> in <plurals> resource.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                int pluralIndex = pluralType.ordinal();
                if (plural.getValues()[pluralIndex] != null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> has quantity '" + trimmedQuantity + "' which has already been specified in <plurals> resource '" + element.getName() + "'");
                    error = true;
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    continue;
                }
                Item[] itemArray = plural.getValues();
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                itemArray[pluralIndex] = this.parseXml(childElement, eventReader, 2, false);
                if (plural.getValues()[pluralIndex] != null) continue;
                error = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                Location location = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Unrecognized tag '" + childName + "' within an <plurals> resource.");
                error = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(plural);
        return true;
    }

    private final boolean parsePublic(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Attribute typeAttribute;
        if (this.options.getVisibility() != null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public> tag not allowed with --visibility flag.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)new ConfigDescription(null, 1, null))) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
        }
        if ((typeAttribute = element.getAttributeByName(new QName("type"))) == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public> must have a 'type' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        String string = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeAttribute.value");
        AaptResourceType parsedType = AaptResourceTypeKt.resourceTypeFromTag(string);
        if (parsedType == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid resource type '" + typeAttribute.getValue() + "' in <public> resource.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, parsedType, null, 5, null));
        Attribute idAttribute = element.getAttributeByName(new QName("id"));
        if (idAttribute != null) {
            String string2 = idAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idAttribute.value");
            Integer id = ResourceUtilsKt.parseResourceId(string2);
            if (id == null) {
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid resource Id '" + idAttribute.getValue() + "' in <public> resource.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            parsedResource.setResourceId(id);
        }
        if (parsedType == AaptResourceType.ID) {
            parsedResource.setValue(new Id());
        }
        parsedResource.setVisibility(ResourceVisibility.PUBLIC);
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return true;
    }

    private final boolean parsePublicGroup(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        XMLEvent event;
        Attribute typeAttribute;
        if (this.options.getVisibility() != null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public-group> tag not allowed with --visibility flag.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)new ConfigDescription(null, 1, null))) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
        }
        if ((typeAttribute = element.getAttributeByName(new QName("type"))) == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public-group> must have a 'type' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        String string = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeAttribute.value");
        AaptResourceType parsedType = AaptResourceTypeKt.resourceTypeFromTag(string);
        if (parsedType == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid resource type '" + typeAttribute.getValue() + "' in <public-group>.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Attribute idAttribute = element.getAttributeByName(new QName("first-id"));
        if (idAttribute == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public-group> must have a 'first-id' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        String string2 = idAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idAttribute.value");
        Integer idVal = ResourceUtilsKt.parseResourceId(string2);
        if (idVal == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Invalid resource ID '" + idAttribute.getValue() + "' in <public-group>. Integer expected.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Integer childId = idVal;
        String comment = "";
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            if (event.getEventType() == 5) {
                Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type javax.xml.stream.events.Comment");
                Intrinsics.checkNotNullExpressionValue((Object)((Comment)event).getText(), (String)"event as Comment).text");
                continue;
            }
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            Source itemSource = this.source.withLine(childElement.getLocation().getLineNumber());
            String string3 = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"childName.namespaceURI");
            if (((CharSequence)string3).length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"public")) {
                Attribute nameAttribute = childElement.getAttributeByName(new QName("name"));
                if (nameAttribute == null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "<public> must have a 'name' attribute.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                Attribute childIdAttribute = childElement.getAttributeByName(new QName("id"));
                if (childIdAttribute != null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "'id' attribute is not allowed on <public> tags within a <public-group>.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                Attribute childTypeAttribute = childElement.getAttributeByName(new QName("type"));
                if (childTypeAttribute != null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "'type' attribute is not allowed on <public> tags within a <public-group>.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                ParsedResource childResource = new ParsedResource(new ConfigDescription(null, 1, null), itemSource, comment);
                childResource.setName(new ResourceName("", parsedType, nameAttribute.getValue()));
                childResource.setResourceId(childId);
                childResource.setVisibility(ResourceVisibility.PUBLIC);
                parsedResource.getChildren().add(childResource);
                childId = childId + 1;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                Location location = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Unrecognized tag '" + childName + "' within an <public-group> resource.");
                error = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        return !error;
    }

    private final boolean addResourceToTable(ParsedResource parsedResource) {
        OverlayableItem overlayableItem;
        if (parsedResource.getVisibility() != ResourceVisibility.UNDEFINED) {
            Visibility visibility = new Visibility(parsedResource.getSource(), parsedResource.getComment(), parsedResource.getVisibility());
            if (!this.table.setVisibilityWithId(parsedResource.getName(), visibility, parsedResource.getResourceId())) {
                return false;
            }
        }
        if (parsedResource.getAllowNew()) {
            AllowNew allowNew = new AllowNew(parsedResource.getSource(), parsedResource.getComment());
            if (!this.table.setAllowNew(parsedResource.getName(), allowNew)) {
                return false;
            }
        }
        if ((overlayableItem = parsedResource.getOverlayableItem()) != null && !this.table.setOverlayable(parsedResource.getName(), overlayableItem)) {
            return false;
        }
        Value resource = parsedResource.getValue();
        if (resource != null) {
            resource.setComment(parsedResource.getComment());
            resource.setSource(parsedResource.getSource());
            if (!this.table.addResourceWithId(parsedResource.getName(), parsedResource.getResourceId(), parsedResource.getConfig(), parsedResource.getProductString(), resource)) {
                return false;
            }
        }
        boolean error = false;
        for (ParsedResource child : parsedResource.getChildren()) {
            error = error || !this.addResourceToTable(child);
        }
        return !error;
    }

    public static final /* synthetic */ boolean access$parseAddResource(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseAddResource(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseArray(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseArray(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseAttr(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseAttr(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseConfigVarying(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseConfigVarying(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseDeclareStyleable(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseDeclareStyleable(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseIntegerArray(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseIntegerArray(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseSymbol(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseSymbol(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseMacro(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseMacro(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseOverlayable(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseOverlayable(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parsePlural(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parsePlural(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parsePublic(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parsePublic(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parsePublicGroup(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parsePublicGroup(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseStringArray(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseStringArray(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseStyle(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseStyle(element, eventReader, parsedResource);
    }
}

