/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.commands.AutoValue_AddTransparencyCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.AppBundleSerializer;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.transparency.BundleTransparencyCheckUtils;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.transparency.CodeTransparencyFactory;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UncheckedJoseException;

@AutoValue
public abstract class AddTransparencyCommand {
    public static final String COMMAND_NAME = "add-transparency";
    static final int MIN_RSA_KEY_LENGTH = 3072;
    private static final Flag<Mode> MODE_FLAG = Flag.enumFlag("mode", Mode.class);
    private static final Flag<Path> BUNDLE_LOCATION_FLAG = Flag.path("bundle");
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<Path> KEYSTORE_FLAG = Flag.path("ks");
    private static final Flag<String> KEY_ALIAS_FLAG = Flag.string("ks-key-alias");
    private static final Flag<Password> KEYSTORE_PASSWORD_FLAG = Flag.password("ks-pass");
    private static final Flag<Password> KEY_PASSWORD_FLAG = Flag.password("key-pass");
    private static final Flag<Path> TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG = Flag.path("transparency-key-certificate");
    private static final Flag<Path> TRANSPARENCY_SIGNATURE_LOCATION_FLAG = Flag.path("transparency-signature");
    private static final Flag<DexMergingChoice> DEX_MERGING_CHOICE_FLAG = Flag.enumFlag("dex-merging-choice", DexMergingChoice.class);
    private static final Flag<Boolean> ALLOW_SHARED_USER_ID_FLAG = Flag.booleanFlag("allow-shared-user-id");

    public abstract Mode getMode();

    public abstract Path getBundlePath();

    public abstract Path getOutputPath();

    public abstract DexMergingChoice getDexMergingChoice();

    public abstract Optional<SignerConfig> getSignerConfig();

    public abstract ImmutableList<X509Certificate> getTransparencyKeyCertificates();

    public abstract Optional<Path> getTransparencySignaturePath();

    public abstract Optional<Boolean> getAllowSharedUserId();

    public static Builder builder() {
        return new AutoValue_AddTransparencyCommand.Builder().setMode(Mode.DEFAULT).setDexMergingChoice(DexMergingChoice.ASK_IN_CONSOLE).setTransparencyKeyCertificates((List<X509Certificate>)ImmutableList.of());
    }

    public static AddTransparencyCommand fromFlags(ParsedFlags flags) {
        Mode mode = MODE_FLAG.getValue(flags).orElse(Mode.DEFAULT);
        switch (mode) {
            case DEFAULT: {
                return AddTransparencyCommand.fromFlagsInDefaultMode(flags);
            }
            case GENERATE_CODE_TRANSPARENCY_FILE: {
                return AddTransparencyCommand.fromFlagsInGenerateGenerateCodeTransparencyFileMode(flags);
            }
            case INJECT_SIGNATURE: {
                return AddTransparencyCommand.fromFlagsInInjectSignatureMode(flags);
            }
        }
        throw new IllegalStateException("Unrecognized value of --mode flag.");
    }

    private static AddTransparencyCommand fromFlagsInDefaultMode(ParsedFlags flags) {
        Path keystorePath = KEYSTORE_FLAG.getRequiredValue(flags);
        String keyAlias = KEY_ALIAS_FLAG.getRequiredValue(flags);
        Optional<Password> keystorePassword = KEYSTORE_PASSWORD_FLAG.getValue(flags);
        Optional<Password> keyPassword = KEY_PASSWORD_FLAG.getValue(flags);
        SignerConfig signerConfig = SignerConfig.extractFromKeystore(keystorePath, keyAlias, keystorePassword, keyPassword);
        Optional<Boolean> allowSharedUserId = ALLOW_SHARED_USER_ID_FLAG.getValue(flags);
        Builder addTransparencyCommandBuilder = AddTransparencyCommand.builder().setMode(Mode.DEFAULT).setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setDexMergingChoice(DEX_MERGING_CHOICE_FLAG.getValue(flags).orElse(DexMergingChoice.ASK_IN_CONSOLE)).setSignerConfig(signerConfig);
        allowSharedUserId.ifPresent(addTransparencyCommandBuilder::setAllowSharedUserId);
        flags.checkNoUnknownFlags();
        return addTransparencyCommandBuilder.build();
    }

    private static AddTransparencyCommand fromFlagsInGenerateGenerateCodeTransparencyFileMode(ParsedFlags flags) {
        Optional<Boolean> allowSharedUserId = ALLOW_SHARED_USER_ID_FLAG.getValue(flags);
        Builder addTransparencyCommandBuilder = AddTransparencyCommand.builder().setMode(Mode.GENERATE_CODE_TRANSPARENCY_FILE).setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setTransparencyKeyCertificates((List<X509Certificate>)CodeTransparencyCryptoUtils.getX509Certificates(TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getRequiredValue(flags)));
        allowSharedUserId.ifPresent(addTransparencyCommandBuilder::setAllowSharedUserId);
        flags.checkNoUnknownFlags();
        return addTransparencyCommandBuilder.build();
    }

    private static AddTransparencyCommand fromFlagsInInjectSignatureMode(ParsedFlags flags) {
        Optional<Boolean> allowSharedUserId = ALLOW_SHARED_USER_ID_FLAG.getValue(flags);
        Builder addTransparencyCommandBuilder = AddTransparencyCommand.builder().setMode(Mode.INJECT_SIGNATURE).setBundlePath(BUNDLE_LOCATION_FLAG.getRequiredValue(flags)).setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setTransparencySignaturePath(TRANSPARENCY_SIGNATURE_LOCATION_FLAG.getRequiredValue(flags)).setTransparencyKeyCertificates((List<X509Certificate>)CodeTransparencyCryptoUtils.getX509Certificates(TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getRequiredValue(flags)));
        allowSharedUserId.ifPresent(addTransparencyCommandBuilder::setAllowSharedUserId);
        flags.checkNoUnknownFlags();
        return addTransparencyCommandBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        this.validateCommonInputs();
        try (ZipFile bundleZip = new ZipFile(this.getBundlePath().toFile());){
            DexMergingChoice choice;
            AppBundle inputBundle = AppBundle.buildFromZip(bundleZip);
            Boolean allowSharedUserId = this.getAllowSharedUserId().orElse(false);
            if (inputBundle.hasSharedUserId() && !allowSharedUserId.booleanValue()) {
                throw InvalidBundleException.builder().withUserMessage("Transparency can not be added because `sharedUserId` attribute is specified in one of the manifests and `allow-shared-user-id` flag is either false or not specified explicitly.").build();
            }
            if (inputBundle.dexMergingEnabled() && (choice = this.evaluateDexMergingChoice()).equals((Object)DexMergingChoice.REJECT)) {
                throw InvalidCommandException.builder().withInternalMessage("'add-transparency' command is rejected because one of generated standalone/universal APKs will require dex merging and it is requested toreject command in this case.").build();
            }
            switch (this.getMode()) {
                case DEFAULT: {
                    this.executeDefaultMode(inputBundle);
                    return;
                }
                case GENERATE_CODE_TRANSPARENCY_FILE: {
                    this.executeGenerateCodeTransparencyFileMode(inputBundle);
                    return;
                }
                case INJECT_SIGNATURE: {
                    this.executeInjectSignatureMode(inputBundle);
                    return;
                }
            }
            return;
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The App Bundle is not a valid zip file.").build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the App Bundle.", e12);
        }
        catch (JoseException e13) {
            throw new UncheckedJoseException("An error occurred when signing the code transparency file.", (Throwable)e13);
        }
    }

    private DexMergingChoice evaluateDexMergingChoice() {
        switch (this.getDexMergingChoice()) {
            case REJECT: 
            case CONTINUE: {
                return this.getDexMergingChoice();
            }
            case ASK_IN_CONSOLE: {
                String userDecision = System.console().readLine("You will not be able to verify code transparency for standalone and universal APKs generated from this bundle. Reason: bundletool will merge dex files when generating standalone APKs. This happens for applications with dynamic feature modules that have min sdk below 21 and specify DexMergingStrategy.MERGE_IF_NEEDED.\nWould you like to continue? [yes/no]:", new Object[0]);
                return Ascii.equalsIgnoreCase((CharSequence)userDecision, (CharSequence)"yes") ? DexMergingChoice.CONTINUE : DexMergingChoice.REJECT;
            }
        }
        throw new IllegalStateException("Unsupported DexMergingChoice");
    }

    private void executeDefaultMode(AppBundle inputBundle) throws IOException, JoseException {
        this.validateDefaultModeInputs();
        String jsonText = AddTransparencyCommand.toJsonText(CodeTransparencyFactory.createCodeTransparencyMetadata(inputBundle));
        AppBundle.Builder bundleBuilder = inputBundle.toBuilder();
        bundleBuilder.setBundleMetadata(inputBundle.getBundleMetadata().toBuilder().addFile("com.android.tools.build.bundletool", "code_transparency_signed.jwt", AddTransparencyCommand.toBytes(this.createSignedJwt(jsonText, (List<X509Certificate>)this.getSignerConfig().get().getCertificates()))).build());
        new AppBundleSerializer().writeToDisk(bundleBuilder.build(), this.getOutputPath());
    }

    private void executeGenerateCodeTransparencyFileMode(AppBundle inputBundle) throws IOException {
        this.validateGenerateCodeTransparencyFileModeInputs();
        String codeTransparencyMetadata = AddTransparencyCommand.toJsonText(CodeTransparencyFactory.createCodeTransparencyMetadata(inputBundle));
        Files.write(this.getOutputPath(), AddTransparencyCommand.toBytes(AddTransparencyCommand.createJwtWithoutSignature(codeTransparencyMetadata, this.getTransparencyKeyCertificates())).read(), new OpenOption[0]);
    }

    private void executeInjectSignatureMode(AppBundle inputBundle) throws IOException {
        this.validateInjectSignatureModeInputs();
        String signature = BaseEncoding.base64Url().encode(Files.readAllBytes(this.getTransparencySignaturePath().get()));
        String codeTransparencyMetadata = AddTransparencyCommand.toJsonText(CodeTransparencyFactory.createCodeTransparencyMetadata(inputBundle));
        String transparencyFileWithoutSignature = AddTransparencyCommand.createJwtWithoutSignature(codeTransparencyMetadata, this.getTransparencyKeyCertificates());
        AppBundle bundleWithTransparency = inputBundle.toBuilder().setBundleMetadata(inputBundle.getBundleMetadata().toBuilder().addFile("com.android.tools.build.bundletool", "code_transparency_signed.jwt", AddTransparencyCommand.toBytes(transparencyFileWithoutSignature + "." + signature)).build()).build();
        if (!BundleTransparencyCheckUtils.checkTransparency(bundleWithTransparency).verified()) {
            throw CommandExecutionException.builder().withInternalMessage("Code transparency verification failed for the provided public key certificate and signature.").build();
        }
        new AppBundleSerializer().writeToDisk(bundleWithTransparency, this.getOutputPath());
    }

    public static CommandHelp help() {
        String modeFlagOptions = Arrays.stream(Mode.values()).map(Mode::getLowerCaseName).collect(Collectors.joining("|"));
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Generates code transparency file and adds it to the output bundle.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODE_FLAG.getName()).setExampleValue(modeFlagOptions).setOptional(true).setDescription("Specifies which mode to run '%s' command against. Acceptable values are '%s'. If set to '%s' we generate a signed code transparency file and include it into the output bundle. If set to '%s' we generate unsigned transparency file. If set to '%s' we inject the provided signed transparency file into the bundle. The default value is '%s'.", COMMAND_NAME, modeFlagOptions, Mode.DEFAULT.getLowerCaseName(), Mode.GENERATE_CODE_TRANSPARENCY_FILE.getLowerCaseName(), Mode.INJECT_SIGNATURE.getLowerCaseName(), Mode.DEFAULT.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(BUNDLE_LOCATION_FLAG.getName()).setExampleValue("path/to/bundle.aab").setDescription("Path to the Android App Bundle that we want to add transparency file to.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FLAG.getName()).setExampleValue("path/to/[bundle_with_transparency.aab|transparency_file.jwe]").setDescription("Path to where the output file should be written. Must have extension .aab in '%s' and '%s' modes.", Mode.DEFAULT.getLowerCaseName(), Mode.INJECT_SIGNATURE.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_FLAG.getName()).setExampleValue("path/to/keystore").setOptional(true).setDescription("Path to the keystore that should be used to sign the code transparency file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_ALIAS_FLAG.getName()).setOptional(true).setExampleValue("key-alias").setDescription("Alias of the key to use in the keystore to sign the code transparency file.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEYSTORE_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the keystore to use to sign the code transparency file. Must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(KEY_PASSWORD_FLAG.getName()).setExampleValue("[pass|file]:value").setOptional(true).setDescription("Password of the key in the keystore to use to sign the code transparency file. Must be prefixed with either 'pass:' (if the password is passed in clear text, e.g. 'pass:qwerty') or 'file:' (if the password is the first line of a file, e.g. 'file:/tmp/myPassword.txt'). If this flag is not set, the keystore password will be tried. If that fails, the password will be requested on the prompt.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(TRANSPARENCY_KEY_CERTIFICATE_LOCATION_FLAG.getName()).setExampleValue("path/to/certificate.cert").setOptional(true).setDescription("Path to the file containing the code transparency public key certificate. Required in '%s' and '%s' modes. Should not be used in other modes.", Mode.GENERATE_CODE_TRANSPARENCY_FILE.getLowerCaseName(), Mode.INJECT_SIGNATURE.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(TRANSPARENCY_SIGNATURE_LOCATION_FLAG.getName()).setExampleValue("path/to/transparency.signature").setOptional(true).setDescription("Path to the file containing the code transparency file signature. Required in '%s' mode. Should not be used in other modes.", Mode.INJECT_SIGNATURE.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEX_MERGING_CHOICE_FLAG.getName()).setExampleValue(String.format("%s|%s", DexMergingChoice.CONTINUE.getLowerCaseName(), DexMergingChoice.REJECT.getLowerCaseName())).setOptional(true).setDescription("Allows to silently respond how 'add-transparency' command should behave if some of generated standalone/universal APKs will require dex merging. '%s' means that 'add-transparency' should add code transparency anyway, but it won't be propagated to these APKs. '%s' means that 'add-transparency' command should fail. By default, if this choice is required user will be asked in terminal.", DexMergingChoice.CONTINUE.getLowerCaseName(), DexMergingChoice.REJECT.getLowerCaseName()).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ALLOW_SHARED_USER_ID_FLAG.getName()).setExampleValue("true|false").setOptional(true).setDescription("Allows to use `add-transparency` command when AppBundle has `sharedUserId`. If the flag is not provided explicitly then its value considered as false").build()).build();
    }

    private String createSignedJwt(String payload, List<X509Certificate> certificates) throws JoseException {
        JsonWebSignature jws = AddTransparencyCommand.createJwsCommon(payload, certificates);
        jws.setKey((Key)this.getSignerConfig().get().getPrivateKey());
        return jws.getCompactSerialization();
    }

    @VisibleForTesting
    static String createJwtWithoutSignature(String payload, List<X509Certificate> certificates) {
        JsonWebSignature jws = AddTransparencyCommand.createJwsCommon(payload, certificates);
        return jws.getHeaders().getEncodedHeader() + "." + jws.getEncodedPayload();
    }

    private static JsonWebSignature createJwsCommon(String payload, List<X509Certificate> certificates) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("RS256");
        jws.setCertificateChainHeaderValue(certificates.toArray(new X509Certificate[0]));
        jws.setPayload(payload);
        return jws;
    }

    private static String toJsonText(CodeTransparencyOuterClass.CodeTransparency codeTransparency) throws InvalidProtocolBufferException {
        return JsonFormat.printer().print((MessageOrBuilder)codeTransparency);
    }

    private static ByteSource toBytes(String content) {
        return CharSource.wrap((CharSequence)content).asByteSource(Charset.defaultCharset());
    }

    private void validateCommonInputs() {
        FilePreconditions.checkFileHasExtension("AAB file", this.getBundlePath(), ".aab");
        FilePreconditions.checkFileExistsAndReadable(this.getBundlePath());
    }

    private void validateDefaultModeInputs() {
        FilePreconditions.checkFileHasExtension("AAB file", this.getOutputPath(), ".aab");
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        Preconditions.checkArgument((boolean)this.getSignerConfig().get().getPrivateKey().getAlgorithm().equals("RSA"), (String)"Transparency signing key must be an RSA key, but %s key was provided.", (Object)this.getSignerConfig().get().getPrivateKey().getAlgorithm());
        int keyLength = ((RSAPrivateKey)this.getSignerConfig().get().getPrivateKey()).getModulus().bitLength();
        Preconditions.checkArgument((keyLength >= 3072 ? 1 : 0) != 0, (String)"Minimum required key length is %s bits, but %s bit key was provided.", (int)3072, (int)keyLength);
    }

    private void validateGenerateCodeTransparencyFileModeInputs() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        this.validateTransparencyKeyCertificate();
    }

    private void validateInjectSignatureModeInputs() {
        FilePreconditions.checkFileHasExtension("AAB file", this.getOutputPath(), ".aab");
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        FilePreconditions.checkFileExistsAndReadable(this.getTransparencySignaturePath().get());
        this.validateTransparencyKeyCertificate();
    }

    private void validateTransparencyKeyCertificate() {
        Preconditions.checkArgument((!this.getTransparencyKeyCertificates().isEmpty() ? 1 : 0) != 0, (Object)"Transparency signing key certificates must be provided.");
        X509Certificate leafCertificate = (X509Certificate)this.getTransparencyKeyCertificates().get(0);
        Preconditions.checkArgument((boolean)leafCertificate.getPublicKey().getAlgorithm().equals("RSA"), (String)"Transparency signing key must be an RSA key, but %s key was provided.", (Object)leafCertificate.getPublicKey().getAlgorithm());
        int keyLength = ((RSAPublicKey)leafCertificate.getPublicKey()).getModulus().bitLength();
        Preconditions.checkArgument((keyLength >= 3072 ? 1 : 0) != 0, (String)"Minimum required key length is %s bits, but %s bit key was provided.", (int)3072, (int)keyLength);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMode(Mode var1);

        public abstract Builder setBundlePath(Path var1);

        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setSignerConfig(SignerConfig var1);

        public abstract Builder setTransparencyKeyCertificates(List<X509Certificate> var1);

        public abstract Builder setTransparencySignaturePath(Path var1);

        public abstract Builder setDexMergingChoice(DexMergingChoice var1);

        public abstract Builder setAllowSharedUserId(Boolean var1);

        public abstract AddTransparencyCommand build();
    }

    public static enum DexMergingChoice {
        ASK_IN_CONSOLE,
        CONTINUE,
        REJECT;


        final String getLowerCaseName() {
            return Ascii.toLowerCase((String)this.name());
        }
    }

    public static enum Mode {
        DEFAULT,
        GENERATE_CODE_TRANSPARENCY_FILE,
        INJECT_SIGNATURE;


        final String getLowerCaseName() {
            return Ascii.toLowerCase((String)this.name());
        }
    }
}

