/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.androidtools.P7ZipCommand;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.commands.BuildSdkApksForAppCommand;
import com.android.tools.build.bundletool.commands.CommandUtils;
import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ModuleSplitSerializer;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.DefaultSigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import java.util.Optional;

@Module
public abstract class BuildSdkApksForAppModule {
    @Provides
    static Aapt2Command provideAapt2Command(BuildSdkApksForAppCommand command, TempDirectory tempDir) {
        return command.getAapt2Command().orElseGet(() -> CommandUtils.extractAapt2FromJar(tempDir.getPath()));
    }

    @Provides
    static Config.BundleConfig provideBundleConfig() {
        return Config.BundleConfig.newBuilder().setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).build();
    }

    @Provides
    static Version provideBundletoolVersion() {
        return BundleToolVersion.getCurrentVersion();
    }

    @Provides
    static Optional<Devices.DeviceSpec> provideDeviceSpec() {
        return Optional.empty();
    }

    @Provides
    static ApkOptimizations provideApkOptimizations() {
        return ApkOptimizations.getOptimizationsForUniversalApk();
    }

    @Provides
    static BuildApksCommand.ApkBuildMode provideApkBuildMode() {
        return BuildApksCommand.ApkBuildMode.DEFAULT;
    }

    @Provides
    @BuildApksModule.ApkSigningConfigProvider
    static Optional<SigningConfigurationProvider> provideApkSigningConfigurationProvider(BuildSdkApksForAppCommand command, Version version) {
        return command.getSigningConfiguration().map(signingConfig -> new DefaultSigningConfigurationProvider((SigningConfiguration)signingConfig, version));
    }

    @Provides
    static ListeningExecutorService provideExecutorService(BuildSdkApksForAppCommand command) {
        return command.getExecutorService();
    }

    @Provides
    static Optional<ApkListener> provideApkListener() {
        return Optional.empty();
    }

    @Provides
    static Optional<ApkModifier> provideApkModifier() {
        return Optional.empty();
    }

    @Provides
    @BuildApksModule.VerboseLogs
    static boolean provideVerbose() {
        return false;
    }

    @Provides
    static Optional<SourceStamp> provideSourceStamp() {
        return Optional.empty();
    }

    @Provides
    static Optional<P7ZipCommand> privideP7ZipCommand() {
        return Optional.empty();
    }

    @BuildApksModule.FirstVariantNumber
    @Provides
    static Optional<Integer> provideFirstVariantNumber() {
        return Optional.empty();
    }

    @Provides
    static Bundle provideBundle(BundleModule module, Config.BundleConfig bundleConfig) {
        return AppBundle.buildFromModules((ImmutableList<BundleModule>)ImmutableList.of((Object)module), bundleConfig, BundleMetadata.builder().build()).toBuilder().setPackageNameOptional(module.getAndroidManifest().getPackageName()).build();
    }

    @Binds
    abstract ApkSerializer apkSerializerHelper(ModuleSplitSerializer var1);
}

