/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.mergers.AndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SuffixManager;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.shards.ModuleSplitterForShards;
import com.android.tools.build.bundletool.shards.Sharder;
import com.android.tools.build.bundletool.splitters.BinaryArtProfilesInjector;
import com.android.tools.build.bundletool.splitters.CodeTransparencyInjector;
import com.android.tools.build.bundletool.splitters.RuntimeEnabledSdkTableInjector;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;

public class SystemApksGenerator {
    private final ModuleSplitterForShards moduleSplitter;
    private final Sharder sharder;
    private final ModuleSplitsToShardMerger shardsMerger;
    private final Optional<Devices.DeviceSpec> deviceSpec;
    private final CodeTransparencyInjector codeTransparencyInjector;
    private final BinaryArtProfilesInjector binaryArtProfilesInjector;
    private final RuntimeEnabledSdkTableInjector runtimeEnabledSdkTableInjector;

    @Inject
    public SystemApksGenerator(ModuleSplitterForShards moduleSplitter, Sharder sharder, ModuleSplitsToShardMerger shardsMerger, Optional<Devices.DeviceSpec> deviceSpec, AppBundle appBundle) {
        this.moduleSplitter = moduleSplitter;
        this.sharder = sharder;
        this.shardsMerger = shardsMerger;
        this.deviceSpec = deviceSpec;
        this.codeTransparencyInjector = new CodeTransparencyInjector(appBundle);
        this.binaryArtProfilesInjector = new BinaryArtProfilesInjector(appBundle);
        this.runtimeEnabledSdkTableInjector = new RuntimeEnabledSdkTableInjector(appBundle);
    }

    public ImmutableList<ModuleSplit> generateSystemApks(ImmutableList<BundleModule> modules, ImmutableSet<BundleModuleName> modulesToFuse, ApkOptimizations apkOptimizations) {
        Preconditions.checkState((boolean)this.deviceSpec.isPresent(), (Object)"Device spec should be set when sharding for system apps.");
        ImmutableList splits = (ImmutableList)modules.stream().flatMap(module -> this.moduleSplitter.generateSplits((BundleModule)module, apkOptimizations.getSplitDimensions()).stream()).collect(ImmutableList.toImmutableList());
        ImmutableList systemShard = (ImmutableList)Iterables.getOnlyElement(this.sharder.groupSplitsToShards((ImmutableList<ModuleSplit>)splits));
        return (ImmutableList)this.processSplitsOfSystemShard((ImmutableList<ModuleSplit>)systemShard, modulesToFuse).stream().map(module -> SystemApksGenerator.applyUncompressedOptimizations(module, apkOptimizations)).map(this.codeTransparencyInjector::inject).map(this.binaryArtProfilesInjector::inject).map(this.runtimeEnabledSdkTableInjector::inject).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> processSplitsOfSystemShard(ImmutableList<ModuleSplit> splits, ImmutableSet<BundleModuleName> modulesToFuse) {
        ImmutableSet splitsOfFusedModules = (ImmutableSet)splits.stream().filter(module -> modulesToFuse.contains((Object)module.getModuleName())).collect(ImmutableSet.toImmutableSet());
        ImmutableSet splitsOfNonFusedModules = Sets.difference((Set)ImmutableSet.copyOf(splits), (Set)splitsOfFusedModules).immutableCopy();
        ImmutableSet<ModuleSplit> splitsWithOnlyDeviceLanguages = this.filterOutUnusedLanguageSplits((ImmutableSet<ModuleSplit>)splitsOfFusedModules);
        ModuleSplit systemSplit = this.mergeSplitsToSystemApk(splitsWithOnlyDeviceLanguages);
        AndroidManifest systemSplitManifest = systemSplit.getAndroidManifest();
        ImmutableSet additionalLanguageSplits = (ImmutableSet)Sets.difference((Set)splitsOfFusedModules, splitsWithOnlyDeviceLanguages).stream().collect(CollectorUtils.groupingByDeterministic(ModuleSplit::getApkTargeting)).values().stream().map(splitsPerLanguage -> this.mergeLanguageSplitsIntoOne((ImmutableList<ModuleSplit>)splitsPerLanguage, systemSplitManifest)).collect(ImmutableSet.toImmutableSet());
        ImmutableList additionalSplits = (ImmutableList)Sets.union((Set)additionalLanguageSplits, (Set)splitsOfNonFusedModules).stream().collect(CollectorUtils.groupingByDeterministic(ModuleSplit::getModuleName)).values().stream().flatMap(SystemApksGenerator::writeSplitIdInManifestHavingSameModule).map(module -> SystemApksGenerator.writeSplitTargetingAndSplitTypeToAdditionalSplit(module, systemSplit.getVariantTargeting())).collect(ImmutableList.toImmutableList());
        return ImmutableList.builder().add((Object)systemSplit).addAll((Iterable)additionalSplits).build();
    }

    private ImmutableSet<ModuleSplit> filterOutUnusedLanguageSplits(ImmutableSet<ModuleSplit> splits) {
        ApkMatcher apkMatcher = new ApkMatcher(this.deviceSpec.get());
        return (ImmutableSet)splits.stream().filter(split -> !split.getApkTargeting().hasLanguageTargeting() || apkMatcher.matchesModuleSplitByTargeting((ModuleSplit)split)).collect(ImmutableSet.toImmutableSet());
    }

    private ModuleSplit mergeLanguageSplitsIntoOne(ImmutableList<ModuleSplit> languageSplits, AndroidManifest manifest) {
        return this.shardsMerger.mergeSingleShard((ImmutableCollection<ModuleSplit>)languageSplits, (Map<ImmutableSet<ModuleEntry>, ImmutableList<Path>>)new HashMap<ImmutableSet<ModuleEntry>, ImmutableList<Path>>(), ModuleSplit.SplitType.SPLIT, AndroidManifestMerger.manifestOverride(manifest));
    }

    private ModuleSplit mergeSplitsToSystemApk(ImmutableSet<ModuleSplit> splits) {
        ModuleSplit merged = this.shardsMerger.mergeSingleShard((ImmutableCollection<ModuleSplit>)splits, Maps.newHashMap());
        return merged.toBuilder().setVariantTargeting(TargetingUtils.standaloneApkVariantTargeting(merged)).setMasterSplit(true).setSplitType(ModuleSplit.SplitType.SYSTEM).build();
    }

    private static Stream<ModuleSplit> writeSplitIdInManifestHavingSameModule(ImmutableList<ModuleSplit> splits) {
        Preconditions.checkState((splits.stream().map(ModuleSplit::getModuleName).distinct().count() == 1L ? 1 : 0) != 0);
        SuffixManager suffixManager = new SuffixManager();
        return splits.stream().map(split -> split.writeSplitIdInManifest(suffixManager.createSuffix((ModuleSplit)split)));
    }

    private static ModuleSplit writeSplitTargetingAndSplitTypeToAdditionalSplit(ModuleSplit split, Targeting.VariantTargeting variantTargeting) {
        return split.toBuilder().setVariantTargeting(variantTargeting).setSplitType(ModuleSplit.SplitType.SYSTEM).build();
    }

    private static ModuleSplit applyUncompressedOptimizations(ModuleSplit split, ApkOptimizations optimizations) {
        if (!optimizations.getUncompressNativeLibraries() && !optimizations.getUncompressDexFiles()) {
            return split;
        }
        ImmutableList entries = (ImmutableList)split.getEntries().stream().map(entry -> SystemApksGenerator.applyUncompressedOptimizations(entry, optimizations)).collect(ImmutableList.toImmutableList());
        return split.toBuilder().setEntries((List<ModuleEntry>)entries).setAndroidManifest(split.isMasterSplit() && optimizations.getUncompressNativeLibraries() ? split.getAndroidManifest().toEditor().setExtractNativeLibsValue(false).save() : split.getAndroidManifest()).build();
    }

    private static ModuleEntry applyUncompressedOptimizations(ModuleEntry entry, ApkOptimizations optimizations) {
        if (SystemApksGenerator.isNativeLibrary(entry) && optimizations.getUncompressNativeLibraries() || SystemApksGenerator.isDex(entry) && optimizations.getUncompressDexFiles()) {
            return entry.toBuilder().setForceUncompressed(true).build();
        }
        return entry;
    }

    private static boolean isNativeLibrary(ModuleEntry entry) {
        ZipPath path = entry.getPath();
        return path.startsWith(BundleModule.LIB_DIRECTORY) && path.getFileName().toString().endsWith(".so");
    }

    private static boolean isDex(ModuleEntry entry) {
        return entry.getPath().startsWith(BundleModule.DEX_DIRECTORY);
    }
}

