/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.IssueReporter;
import com.android.builder.sdk.DefaultSdkLoader;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.PlatformLoader;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.utils.SynchronizedFile;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SdkHandler {
    private static final ILogger logger = LoggerWrapper.getLogger(SdkHandler.class);
    private final IssueReporter issueReporter;
    private final AndroidLocationsProvider androidLocationsProvider;
    private SdkLocationSourceSet sdkLocationSourceSet;
    private final String suppressWarningUnsupportedCompileSdk;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private SdkLoader sdkLoader;

    public SdkHandler(AndroidLocationsProvider androidLocationsProvider, SdkLocationSourceSet sdkLocationSourceSet, IssueReporter issueReporter2, String suppressWarningUnsupportedCompileSdk) {
        this.androidLocationsProvider = androidLocationsProvider;
        this.sdkLocationSourceSet = sdkLocationSourceSet;
        this.issueReporter = issueReporter2;
        this.suppressWarningUnsupportedCompileSdk = suppressWarningUnsupportedCompileSdk;
    }

    public Pair<SdkInfo, TargetInfo> initTarget(String targetHash, Revision buildToolRevision) {
        TargetInfo targetInfo;
        AndroidVersion platformVersion;
        Preconditions.checkNotNull((Object)targetHash, (Object)"android.compileSdkVersion is missing!");
        Preconditions.checkNotNull((Object)buildToolRevision, (Object)"android.buildToolsVersion is missing!");
        SdkLoader sdkLoader2 = this.getSdkLoader();
        if (sdkLoader2 == null) {
            return null;
        }
        if (buildToolRevision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            this.issueReporter.reportWarning(IssueReporter.Type.BUILD_TOOLS_TOO_LOW, String.format("The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.", buildToolRevision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION), ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString());
            buildToolRevision = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
        }
        if ((platformVersion = AndroidTargetHash.getVersionFromHash((String)targetHash)) != null) {
            SdkParsingUtilsKt.warnIfCompileSdkTooNew(platformVersion, this.issueReporter, this.suppressWarningUnsupportedCompileSdk);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SdkInfo sdkInfo = sdkLoader2.getSdkInfo(logger);
        try {
            targetInfo = sdkLoader2.getTargetInfo(targetHash, buildToolRevision, logger, this.sdkLibData);
        }
        catch (LicenceNotAcceptedException e) {
            this.issueReporter.reportError(IssueReporter.Type.MISSING_SDK_PACKAGE, e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" ")));
            return null;
        }
        catch (InstallFailedException e) {
            this.issueReporter.reportError(IssueReporter.Type.MISSING_SDK_PACKAGE, e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" ")));
            return null;
        }
        catch (IllegalStateException e) {
            this.issueReporter.reportError(IssueReporter.Type.MISSING_SDK_PACKAGE, (Exception)e);
            return null;
        }
        logger.verbose("SDK initialized in %1$d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return Pair.of((Object)sdkInfo, (Object)targetInfo);
    }

    public boolean ensurePlatformToolsIsInstalledWarnOnFailure() {
        ConsoleProgressIndicator progress2 = new ConsoleProgressIndicator();
        File sdkDir = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter).getDirectory();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((AndroidLocationsProvider)this.androidLocationsProvider, (Path)(sdkDir == null ? null : sdkDir.toPath()));
        LocalPackage platformToolsPackage = sdk.getLatestLocalPackageForPrefix("platform-tools", null, true, (ProgressIndicator)progress2);
        if (platformToolsPackage == null && this.sdkLoader != null) {
            if (this.sdkLibData.useSdkDownload()) {
                try {
                    this.sdkLoader.installSdkTool(this.sdkLibData, "platform-tools");
                    return true;
                }
                catch (LicenceNotAcceptedException e) {
                    this.issueReporter.reportWarning(IssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed. Please accept the installation licence to continue", "platform-tools");
                }
                catch (InstallFailedException e) {
                    this.issueReporter.reportWarning(IssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed, and automatic installation failed.", "platform-tools");
                }
            } else {
                this.issueReporter.reportWarning(IssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed.", "platform-tools");
            }
        }
        return false;
    }

    private synchronized SdkLoader getSdkLoader() {
        if (this.sdkLoader == null) {
            SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter);
            switch (sdkLocation.getType()) {
                case TEST: 
                case REGULAR: {
                    this.sdkLoader = DefaultSdkLoader.getLoader((AndroidLocationsProvider)this.androidLocationsProvider, (File)sdkLocation.getDirectory());
                    break;
                }
                case PLATFORM: {
                    this.sdkLoader = PlatformLoader.getLoader((File)sdkLocation.getDirectory());
                    break;
                }
            }
        }
        return this.sdkLoader;
    }

    public synchronized void unload() {
        if (this.sdkLoader != null) {
            SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter);
            switch (sdkLocation.getType()) {
                case TEST: 
                case REGULAR: {
                    DefaultSdkLoader.unload();
                    break;
                }
                case PLATFORM: {
                    PlatformLoader.unload();
                    break;
                }
            }
            this.sdkLoader = null;
        }
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    public File installSystemImage(String imageHash) throws AndroidLocationsException, ExecutionException {
        SdkLoader loader = this.getSdkLoader();
        if (loader == null) {
            return null;
        }
        loader.getSdkInfo(logger);
        File imageLocation = (File)SynchronizedFile.getInstanceWithMultiProcessLocking((File)this.androidLocationsProvider.getPrefsLocation().resolve(imageHash).toFile()).write(file -> loader.installSdkTool(this.sdkLibData, imageHash));
        if (imageLocation == null) {
            this.issueReporter.reportWarning(IssueReporter.Type.MISSING_SDK_PACKAGE, imageHash + " package is not installed.", imageHash);
        }
        return imageLocation;
    }

    public ImmutableList<String> remoteRepoIdsWithPrefix(String prefix) {
        SdkLoader loader = this.getSdkLoader();
        if (loader == null) {
            return null;
        }
        return loader.retrieveRepoIdsWithPrefix(this.sdkLibData, prefix);
    }

    public File installNdk(Revision ndkRevision) {
        if (!this.sdkLibData.useSdkDownload()) {
            return null;
        }
        try {
            SdkLoader loader = this.getSdkLoader();
            if (loader == null) {
                return null;
            }
            loader.getSdkInfo(logger);
            return this.sdkLoader.installSdkTool(this.sdkLibData, "ndk;" + ndkRevision.toString());
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void installCMake(String version) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        try {
            SdkLoader loader = this.getSdkLoader();
            if (loader == null) {
                return;
            }
            loader.getSdkInfo(logger);
            loader.installSdkTool(this.sdkLibData, "cmake;" + version);
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
    }

    public File getLocalEmulator() {
        SdkLoader loader = this.getSdkLoader();
        if (loader == null) {
            return null;
        }
        return loader.getLocalEmulator(logger);
    }
}

