/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.TestVariantBuilder;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.TestVariantCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.sync.TestModuleVariantModelTask;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class TestApplicationTaskManager
extends AbstractAppTaskManager<TestVariantBuilder, TestVariantCreationConfig> {
    public TestApplicationTaskManager(Project project, Collection<? extends ComponentInfo<TestVariantBuilder, TestVariantCreationConfig>> variants, Collection<? extends TestComponentCreationConfig> testComponents, Collection<? extends TestFixturesCreationConfig> testFixturesComponents, GlobalTaskCreationConfig globalConfig2, TaskManagerConfig localConfig, BaseExtension extension2) {
        super(project, variants, testComponents, testFixturesComponents, globalConfig2, localConfig, extension2);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<TestVariantBuilder, TestVariantCreationConfig> variantInfo) {
        this.createCommonTasks(variantInfo);
        TestVariantCreationConfig testVariantProperties = variantInfo.getVariant();
        Provider testingApk = testVariantProperties.getArtifacts().get(SingleArtifact.APK.INSTANCE);
        this.taskFactory.register(new TestModuleVariantModelTask.CreationAction(testVariantProperties));
        FileCollection testedApks = testVariantProperties.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK);
        FileCollection privacySandboxSdkApks = testVariantProperties.getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT) ? testVariantProperties.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS) : null;
        TestApplicationTestData testData = new TestApplicationTestData(testVariantProperties.getNamespace(), testVariantProperties, testingApk, testedApks, privacySandboxSdkApks);
        this.configureTestData(testVariantProperties, testData);
        this.createValidateSigningTask(testVariantProperties);
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(testVariantProperties));
        TaskProvider<DeviceProviderInstrumentTestTask> instrumentTestTask = this.taskFactory.register(new DeviceProviderInstrumentTestTask.CreationAction(testVariantProperties, testData){

            @Override
            public String getName() {
                return super.getName() + "AndroidTest";
            }
        });
        this.taskFactory.configure("connectedAndroidTest", (Action<? super Task>)((Action)task -> task.dependsOn(new Object[]{instrumentTestTask})));
        this.createTestDevicesForVariant(testVariantProperties, testData, testVariantProperties.getName(), "AndroidTest");
    }

    @Override
    protected void maybeCreateJavaCodeShrinkerTask(ConsumableCreationConfig creationConfig) {
        if (creationConfig.getOptimizationCreationConfig().getMinifiedEnabled()) {
            this.doCreateJavaCodeShrinkerTask(creationConfig, true);
        } else {
            TaskProvider<CheckTestedAppObfuscation> checkObfuscation = this.taskFactory.register(new CheckTestedAppObfuscation.CreationAction((TestVariantCreationConfig)creationConfig));
            Preconditions.checkNotNull(creationConfig.getTaskContainer().getJavacTask());
            TaskFactoryUtils.dependsOn(creationConfig.getTaskContainer().getJavacTask(), checkObfuscation);
        }
    }

    @Override
    protected TaskProvider<? extends ManifestProcessorTask> createMergeManifestTasks(ApkCreationConfig creationConfig) {
        return this.taskFactory.register(new ProcessTestManifest.CreationAction((TestCreationConfig)((Object)creationConfig)));
    }

    @Override
    protected void createVariantPreBuildTask(ComponentCreationConfig creationConfig) {
        this.createDefaultPreBuildTask(creationConfig);
    }
}

