/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a`\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u001a&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007\u001a\u0012\u0010\u0014\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0016\u001a\u00020\u0007H\u0007\u001a0\u0010\u0017\u001a\u00020\u00182\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0002\u00a8\u0006\u001d"}, d2={"findNdkPathImpl", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "ndkVersionFromDsl", "", "ndkPathFromDsl", "ndkDirProperty", "sdkFolder", "Ljava/io/File;", "ndkVersionedFolderNames", "", "getNdkSourceProperties", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "getNdkFolderParsedRevision", "Lcom/android/repository/Revision;", "ndkDirFolder", "getNdkVersionInfo", "ndkRoot", "getNdkVersionOrDefault", "getNdkVersionedFolders", "ndkVersionRoot", "logUserInputs", "", "parseRevision", "version", "stripPreviewFromRevision", "revision", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkLocator.kt\ncom/android/build/gradle/internal/cxx/configure/NdkLocatorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,432:1\n3792#2:433\n4307#2,2:434\n*S KotlinDebug\n*F\n+ 1 NdkLocator.kt\ncom/android/build/gradle/internal/cxx/configure/NdkLocatorKt\n*L\n374#1:433\n374#1:434,2\n*E\n"})
public final class NdkLocatorKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public static final NdkLocatorRecord findNdkPathImpl(@Nullable String ndkVersionFromDsl, @Nullable String ndkPathFromDsl, @Nullable String ndkDirProperty, @Nullable File sdkFolder, @NotNull List<String> ndkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties, @Nullable SdkHandler sdkHandler) {
        Object ndkPathFolder;
        Intrinsics.checkNotNullParameter(ndkVersionedFolderNames, (String)"ndkVersionedFolderNames");
        Intrinsics.checkNotNullParameter(getNdkSourceProperties, (String)"getNdkSourceProperties");
        NdkLocatorKt.logUserInputs(ndkVersionFromDsl, ndkPathFromDsl, ndkDirProperty, sdkFolder);
        Revision revision = NdkLocatorKt.parseRevision(NdkLocatorKt.getNdkVersionOrDefault(ndkVersionFromDsl));
        if (revision == null) {
            return null;
        }
        Revision revisionFromNdkVersion = revision;
        CharSequence charSequence = ndkPathFromDsl;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ndkPathFolder = new File(ndkPathFromDsl);
            Revision revisionFromNdkPath = NdkLocatorKt.findNdkPathImpl$getNdkFolderRevision(getNdkSourceProperties, (File)ndkPathFolder);
            if (revisionFromNdkPath == null) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "Location specified by android.ndkPath (" + ndkPathFromDsl + ") did not contain a valid NDK and couldn't be used", new Object[0]);
                return null;
            }
            CharSequence charSequence2 = ndkDirProperty;
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_AMBIGUOUS, "Both android.ndkPath and ndk.dir in local.properties are set", new Object[0]);
                return null;
            }
            charSequence2 = ndkVersionFromDsl;
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) && !Intrinsics.areEqual((Object)revisionFromNdkVersion, (Object)revisionFromNdkPath)) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_AMBIGUOUS, "android.ndkVersion is [" + revisionFromNdkVersion + "] but android.ndkPath " + (File)ndkPathFolder + " refers to a different version [" + revisionFromNdkPath + "].", new Object[0]);
                return null;
            }
            return new NdkLocatorRecord((File)ndkPathFolder, revisionFromNdkPath);
        }
        ndkPathFolder = ndkDirProperty;
        if (!(ndkPathFolder == null || StringsKt.isBlank((CharSequence)ndkPathFolder))) {
            File ndkDirFolder = new File(ndkDirProperty);
            Revision revision2 = NdkLocatorKt.findNdkPathImpl$getNdkFolderRevision(getNdkSourceProperties, ndkDirFolder);
            if (revision2 != null) {
                NdkLocatorRecord ndkLocatorRecord;
                if (!Intrinsics.areEqual((Object)revision2, (Object)revisionFromNdkVersion) && ndkVersionFromDsl != null) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_VERSION_IS_UNMATCHED, "NDK from ndk.dir at " + ndkDirFolder + " had version [" + revision2 + "] which disagrees with android.ndkVersion [" + revisionFromNdkVersion + "]", new Object[0]);
                    return null;
                }
                NdkLocatorRecord resolutionWithNdkDir = new NdkLocatorRecord(ndkDirFolder, revision2);
                LoggingEnvironmentKt.infoln("Checking whether deleting ndk.dir and setting android.ndkVersion to [" + revision2 + "] would result in the same NDK", new Object[0]);
                AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(null, "ndk.dir delete check", true, 1, null);
                Throwable throwable = null;
                try {
                    PassThroughPrefixingLoggingEnvironment it = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
                    boolean bl = false;
                    NdkLocatorRecord resolutionWithoutNdkDir = NdkLocatorKt.findNdkPathImpl(revision2.toString(), ndkPathFromDsl, null, sdkFolder, ndkVersionedFolderNames, getNdkSourceProperties, null);
                    if (Intrinsics.areEqual((Object)resolutionWithoutNdkDir, (Object)resolutionWithNdkDir)) {
                        LoggingEnvironmentKt.infoln("Deleting ndk.dir and setting android.ndkVersion to [" + revision2 + "] would result in the same NDK.", new Object[0]);
                    } else {
                        LoggingEnvironmentKt.infoln("Deleting ndk.dir and setting android.ndkVersion to [" + revision2 + "] would *not* result in the same NDK.", new Object[0]);
                    }
                    ndkLocatorRecord = resolutionWithoutNdkDir;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                NdkLocatorRecord resolutionWithoutNdkDir = ndkLocatorRecord;
                if (Intrinsics.areEqual((Object)resolutionWithNdkDir, (Object)resolutionWithoutNdkDir)) {
                    LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_DIR_IS_DEPRECATED, "NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. Please delete ndk.dir from local.properties and set android.ndkVersion to [" + revision2 + "] in all native modules in the project. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                    return resolutionWithNdkDir;
                }
                if (resolutionWithoutNdkDir == null) {
                    LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_DIR_IS_DEPRECATED, "NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. Please use android.ndkVersion or android.ndkPath in build.gradle to specify the NDK to use. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                    return resolutionWithNdkDir;
                }
                LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_DIR_IS_DEPRECATED, "NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. If you delete ndk.dir from local.properties and set android.ndkVersion to [" + revision2 + "] then NDK at " + resolutionWithoutNdkDir.getNdk() + " will be used. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                return resolutionWithNdkDir;
            }
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_INVALID, "Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a valid NDK and couldn't be used", new Object[0]);
            return null;
        }
        if (sdkFolder != null) {
            File versionedNdkPath = new File(new File(sdkFolder, "ndk"), String.valueOf(revisionFromNdkVersion));
            Revision sideBySideRevision = NdkLocatorKt.findNdkPathImpl$getNdkFolderRevision(getNdkSourceProperties, versionedNdkPath);
            if (sideBySideRevision != null) {
                return new NdkLocatorRecord(versionedNdkPath, sideBySideRevision);
            }
            File ndkBundlePath = new File(sdkFolder, "ndk-bundle");
            Revision bundleRevision = NdkLocatorKt.findNdkPathImpl$getNdkFolderRevision(getNdkSourceProperties, ndkBundlePath);
            if (bundleRevision != null && Intrinsics.areEqual((Object)bundleRevision, (Object)revisionFromNdkVersion)) {
                return new NdkLocatorRecord(ndkBundlePath, bundleRevision);
            }
        }
        if (sdkHandler == null) {
            return null;
        }
        LoggingEnvironmentKt.infoln("No NDK was found. Trying to download it now.", new Object[0]);
        File downloaded = sdkHandler.installNdk(revisionFromNdkVersion);
        if (downloaded != null) {
            LoggingEnvironmentKt.infoln("NDK " + revisionFromNdkVersion + " was downloaded to " + downloaded + ". Using that.", new Object[0]);
            return new NdkLocatorRecord(downloaded, revisionFromNdkVersion);
        }
        throw new InvalidUserDataException("NDK not configured. Download it with SDK manager. Preferred NDK version is '25.1.8937393'. ");
    }

    @Nullable
    public static final Revision getNdkFolderParsedRevision(@NotNull File ndkDirFolder, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)ndkDirFolder, (String)"ndkDirFolder");
        Intrinsics.checkNotNullParameter(getNdkSourceProperties, (String)"getNdkSourceProperties");
        SdkSourceProperties properties = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)ndkDirFolder);
        if (properties == null) {
            LoggingEnvironmentKt.infoln("Folder " + ndkDirFolder + " does not exist. Ignoring.", new Object[0]);
            return null;
        }
        String packageRevision = properties.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION);
        if (packageRevision == null) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "Folder " + ndkDirFolder + " has no Pkg.Revision in source.properties. Ignoring.", new Object[0]);
            return null;
        }
        return NdkLocatorKt.parseRevision(packageRevision);
    }

    private static final void logUserInputs(String ndkVersionFromDsl, String ndkPathFromDsl, String ndkDirProperty, File sdkFolder) {
        String string = ndkVersionFromDsl;
        if (string == null) {
            string = "not set";
        }
        LoggingEnvironmentKt.infoln("android.ndkVersion from module build.gradle is [" + string + "]", new Object[0]);
        String string2 = ndkPathFromDsl;
        if (string2 == null) {
            string2 = "not set";
        }
        LoggingEnvironmentKt.infoln("android.ndkPath from module build.gradle is " + string2, new Object[0]);
        String string3 = ndkDirProperty;
        if (string3 == null) {
            string3 = "not set";
        }
        LoggingEnvironmentKt.infoln("ndk.dir in local.properties is " + string3, new Object[0]);
        LoggingEnvironmentKt.infoln("Not considering ANDROID_NDK_HOME because support was removed after deprecation period.", new Object[0]);
        if (sdkFolder != null) {
            LoggingEnvironmentKt.infoln("sdkFolder is " + sdkFolder, new Object[0]);
            String[] stringArray = new String[]{"ndk"};
            File sxsRoot = FileUtils.join((File)sdkFolder, (String[])stringArray);
            if (!sxsRoot.isDirectory()) {
                LoggingEnvironmentKt.infoln("NDK side-by-side folder from sdkFolder " + sxsRoot + " does not exist", new Object[0]);
            }
        } else {
            LoggingEnvironmentKt.infoln("sdkFolder is not set", new Object[0]);
        }
    }

    private static final String getNdkVersionOrDefault(String ndkVersionFromDsl) {
        String string;
        CharSequence charSequence = ndkVersionFromDsl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            LoggingEnvironmentKt.infoln("Because no explicit NDK was requested, the default version [25.1.8937393] for this Android Gradle Plugin will be used", new Object[0]);
            string = "25.1.8937393";
        } else {
            string = ndkVersionFromDsl;
        }
        return string;
    }

    private static final Revision parseRevision(String version) {
        try {
            Revision revision = Revision.parseRevision((String)version);
            Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"parseRevision(version)");
            Revision revision2 = NdkLocatorKt.stripPreviewFromRevision(revision);
            if (revision2.toIntArray(true).length < 3) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_IS_AMBIGUOUS, "Specified NDK version [" + version + "] does not have enough precision. Use major.minor.micro in version.", new Object[0]);
                return null;
            }
            return revision2;
        }
        catch (NumberFormatException e) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_VERSION_IS_INVALID, "Requested NDK version '" + version + "' could not be parsed", new Object[0]);
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        Intrinsics.checkNotNullParameter((Object)ndkRoot, (String)"ndkRoot");
        if (!ndkRoot.exists()) {
            return null;
        }
        File sourceProperties = new File(ndkRoot, "source.properties");
        if (!sourceProperties.exists()) {
            File releaseTxt = FilesKt.resolve((File)ndkRoot, (String)"RELEASE.TXT");
            if (releaseTxt.exists()) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_VERSION_UNSUPPORTED, "NDK at " + ndkRoot + " is not supported (pre-r11)", new Object[0]);
                return null;
            }
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "NDK at " + ndkRoot + " did not have a source.properties file", new Object[0]);
            return null;
        }
        return SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        Intrinsics.checkNotNull((Object)stringArray);
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Revision stripPreviewFromRevision(Revision revision) {
        Revision revision2;
        int[] parts = revision.toIntArray(false);
        switch (parts.length) {
            case 1: {
                revision2 = new Revision(parts[0]);
                break;
            }
            case 2: {
                revision2 = new Revision(parts[0], parts[1]);
                break;
            }
            default: {
                revision2 = new Revision(parts[0], parts[1], parts[2]);
            }
        }
        return revision2;
    }

    private static final Revision findNdkPathImpl$getNdkFolderRevision(Function1<? super File, SdkSourceProperties> $getNdkSourceProperties, File ndkDirFolder) {
        return NdkLocatorKt.getNdkFolderParsedRevision(ndkDirFolder, $getNdkSourceProperties);
    }
}

