/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintResourceItem;
import com.android.tools.lint.LintResourcePersistence;
import com.android.tools.lint.LintResourceRepository;
import com.android.tools.lint.LintResourceRepositoryKt;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.DomExtensions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0003*+,BA\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\tH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J$\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0007H\u0014J$\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\tH\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/LintResourceRepository;", "Lcom/android/ide/common/resources/AbstractResourceRepository;", "Lcom/android/ide/common/resources/SingleNamespaceResourceRepository;", "project", "Lcom/android/tools/lint/detector/api/Project;", "typeToMap", "", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "", "Lcom/android/ide/common/resources/ResourceItem;", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "libraryName", "(Lcom/android/tools/lint/detector/api/Project;Ljava/util/Map;Lcom/android/ide/common/rendering/api/ResourceNamespace;Ljava/lang/String;)V", "getLibraryName", "()Ljava/lang/String;", "getTypeToMap$lint_cli", "()Ljava/util/Map;", "accept", "Lcom/android/ide/common/resources/ResourceVisitor$VisitResult;", "visitor", "Lcom/android/ide/common/resources/ResourceVisitor;", "getLeafResourceRepositories", "", "getNamespace", "getNamespaces", "", "getPackageName", "getPublicResources", "", "type", "getResourcesInternal", "resourceType", "serialize", "pathVariables", "Lcom/android/tools/lint/model/PathVariables;", "root", "Ljava/io/File;", "sort", "", "toString", "Companion", "LintLibraryRepository", "MergedResourceRepository", "lint-cli"})
public class LintResourceRepository
extends AbstractResourceRepository
implements SingleNamespaceResourceRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> typeToMap;
    @NotNull
    private final ResourceNamespace namespace;
    @Nullable
    private final String libraryName;
    @NotNull
    private static final Function1<File, Boolean> skipHidden = Companion.skipHidden.1.INSTANCE;
    @NotNull
    private static final String KEY_LIBRARY_CACHE = "libraryCache";
    @NotNull
    private static final String KEY_FRAMEWORK_CACHE = "frameworkCache";
    private static boolean warned;

    public LintResourceRepository(@Nullable Project project, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> typeToMap, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        Intrinsics.checkNotNullParameter(typeToMap, (String)"typeToMap");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.project = project;
        this.typeToMap = typeToMap;
        this.namespace = namespace;
        this.libraryName = libraryName;
    }

    @NotNull
    public final Map<ResourceType, ListMultimap<String, ResourceItem>> getTypeToMap$lint_cli() {
        return this.typeToMap;
    }

    @Nullable
    public final String getLibraryName() {
        return this.libraryName;
    }

    @NotNull
    protected ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        if (!Intrinsics.areEqual((Object)namespace, (Object)this.namespace)) {
            ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableListMultimap, (String)"of()");
            return (ListMultimap)immutableListMultimap;
        }
        ListMultimap listMultimap = this.typeToMap.get(resourceType);
        if (listMultimap == null) {
            ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableListMultimap, (String)"of()");
            listMultimap = (ListMultimap)immutableListMultimap;
        }
        return listMultimap;
    }

    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        return SetsKt.setOf((Object)this.namespace);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.namespace;
    }

    @NotNull
    public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        return CollectionsKt.listOf((Object)((Object)this));
    }

    @NotNull
    public final String serialize(@NotNull PathVariables pathVariables, @Nullable File root, boolean sort) {
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        return LintResourcePersistence.INSTANCE.serialize(this, pathVariables, root, sort);
    }

    public static /* synthetic */ String serialize$default(LintResourceRepository lintResourceRepository, PathVariables pathVariables, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: serialize");
        }
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return lintResourceRepository.serialize(pathVariables, file, bl);
    }

    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (visitor.shouldVisitNamespace(this.namespace) && AbstractResourceRepository.acceptByResources(this.typeToMap, (ResourceVisitor)visitor) == ResourceVisitor.VisitResult.ABORT) {
            return ResourceVisitor.VisitResult.ABORT;
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Nullable
    public String getPackageName() {
        LintResourceRepositoryKt.access$unsupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        LintResourceRepositoryKt.access$unsupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public String toString() {
        Object object = this.project;
        if (object != null && (object = object.getName()) != null) {
            Object it = object;
            boolean bl = false;
            return "Resources for " + (String)it + " without dependencies";
        }
        return super.toString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001LB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002Jr\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001cH\u0002JX\u0010#\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001cH\u0002J\u0016\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J \u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J8\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0.2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u000202H\u0002J\u001e\u00103\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u000202J\u0018\u00104\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u00105\u001a\u000206H\u0002J4\u00104\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\b2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020+0\u0010H\u0002J \u00104\u001a\u00020+2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010:\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010;\u001a\u00020<H\u0002J,\u0010:\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020+0\u0010H\u0002J\u0018\u0010=\u001a\u00020+2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010>\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0006\u00107\u001a\u00020\u0004H\u0002J\u0018\u0010?\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0006\u0010;\u001a\u00020<H\u0002J:\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\b2\u0006\u0010&\u001a\u00020,2\b\u0010B\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010)2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020+0DH\u0002JZ\u0010E\u001a\u00020\f2\u0006\u0010&\u001a\u00020,2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\bH\u0002JR\u0010F\u001a\u00020\f2\u0006\u0010&\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001a2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\bH\u0002JE\u0010G\u001a\u00020\f2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bIJJ\u0010J\u001a\u00020\f2\u0006\u0010&\u001a\u00020,2\u0006\u0010K\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00120\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/android/tools/lint/LintResourceRepository$Companion;", "", "()V", "KEY_FRAMEWORK_CACHE", "", "KEY_LIBRARY_CACHE", "skipHidden", "Lkotlin/Function1;", "Ljava/io/File;", "", "warned", "addIds", "", "element", "Lorg/w3c/dom/Element;", "map", "", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "Lcom/android/ide/common/resources/ResourceItem;", "folderType", "Lcom/android/resources/ResourceFolderType;", "config", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "file", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "added", "", "Lcom/android/ide/common/resources/ResourceMergerItem;", "addItems", "name", "type", "libraryName", "Lcom/android/tools/lint/LintResourceItem;", "addStyleableItems", "styleableNode", "clearCaches", "client", "Lcom/android/tools/lint/LintCliClient;", "project", "Lcom/android/tools/lint/detector/api/Project;", "createFromFolder", "Lcom/android/tools/lint/LintResourceRepository;", "Lcom/android/tools/lint/client/api/LintClient;", "resourceFolders", "Lkotlin/sequences/Sequence;", "createRepository", "Lcom/android/ide/common/resources/ResourceRepository;", "scope", "Lcom/android/tools/lint/client/api/ResourceRepositoryScope;", "get", "getForFramework", "target", "Lcom/android/sdklib/IAndroidTarget;", "hash", "res", "cache", "getForLibrary", "library", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "getForProjectOnly", "getFrameworkResourceCacheFile", "getLibraryResourceCacheFile", "getOrCreateRepository", "serializedFile", "root", "factory", "Lkotlin/Function0;", "processFiles", "processValues", "recordItem", "item", "recordItem$lint_cli", "scanTypeFolder", "folder", "EmptyRepository", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintResourceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintResourceRepository.kt\ncom/android/tools/lint/LintResourceRepository$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,915:1\n1#2:916\n766#3:917\n857#3,2:918\n1549#3:920\n1620#3,3:921\n1855#3,2:924\n800#3,11:926\n1313#4,2:937\n3792#5:939\n4307#5,2:940\n3792#5:942\n4307#5,2:943\n*S KotlinDebug\n*F\n+ 1 LintResourceRepository.kt\ncom/android/tools/lint/LintResourceRepository$Companion\n*L\n410#1:917\n410#1:918,2\n411#1:920\n411#1:921,3\n412#1:924,2\n430#1:926,11\n444#1:937,2\n644#1:939\n644#1:940,2\n665#1:942\n665#1:943,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void clearCaches(@NotNull LintCliClient client, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            for (ResourceRepositoryScope s : ResourceRepositoryScope.values()) {
                project.putClientProperty((Object)s, null);
            }
            client.putClientProperty(LintResourceRepository.KEY_LIBRARY_CACHE, null);
            client.putClientProperty(LintResourceRepository.KEY_FRAMEWORK_CACHE, null);
        }

        @NotNull
        public final ResourceRepository get(@NotNull LintCliClient client, @NotNull Project project, @NotNull ResourceRepositoryScope scope) {
            ResourceRepository resourceRepository;
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            ResourceRepository resourceRepository2 = (ResourceRepository)project.getClientProperty((Object)scope);
            if (resourceRepository2 == null) {
                ResourceRepository resourceRepository3;
                ResourceRepository it = resourceRepository3 = this.createRepository(client, project, scope);
                boolean bl = false;
                project.putClientProperty((Object)scope, (Object)it);
                resourceRepository = resourceRepository3;
            } else {
                resourceRepository = resourceRepository2;
            }
            return resourceRepository;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final ResourceRepository createRepository(LintCliClient client, Project project, ResourceRepositoryScope scope) {
            block15: {
                if (scope == ResourceRepositoryScope.ANDROID) {
                    var4_4 = project.getBuildTarget();
                    if (var4_4 != null) {
                        target = var4_4;
                        $i$a$-let-LintResourceRepository$Companion$createRepository$1 = false;
                        return (ResourceRepository)LintResourceRepository.Companion.getForFramework(client, target);
                    }
                    return (ResourceRepository)EmptyRepository.INSTANCE;
                }
                projectRepository = this.getForProjectOnly(client, project);
                if (scope == ResourceRepositoryScope.PROJECT_ONLY) {
                    return (ResourceRepository)projectRepository;
                }
                repositories = new ArrayList<E>();
                ((Collection)repositories).add(projectRepository);
                if (scope.includesDependencies()) {
                    v0 = project.getAllLibraries();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"project.allLibraries");
                    target = v0;
                    $i$f$filter = false;
                    var8_12 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Project)element$iv$iv;
                        $i$a$-filter-LintResourceRepository$Companion$createRepository$2 = false;
                        if (!(it.isExternalLibrary() == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    var11_19 = $this$mapTo$iv$iv.iterator();
                    while (var11_19.hasNext()) {
                        item$iv$iv /* !! */  = var11_19.next();
                        it = (Project)item$iv$iv /* !! */ ;
                        var19_27 = destination$iv$iv;
                        $i$a$-map-LintResourceRepository$Companion$createRepository$3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        var19_27.add(LintResourceRepository.Companion.getForProjectOnly(client, it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$forEach = false;
                    $this$mapTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        element$iv = $this$mapTo$iv$iv.next();
                        it = (LintResourceRepository)element$iv;
                        $i$a$-forEach-LintResourceRepository$Companion$createRepository$4 = false;
                        ((Collection)repositories).add(it);
                    }
                    if (scope == ResourceRepositoryScope.LOCAL_DEPENDENCIES && repositories.size() == 1) {
                        return (ResourceRepository)projectRepository;
                    }
                }
                if (!scope.includesLibraries()) break block15;
                $i$f$forEach = project.getBuildVariant();
                if ($i$f$forEach == null || ($this$mapTo$iv$iv = $i$f$forEach.getMainArtifact()) == null || (var9_14 = $this$mapTo$iv$iv.getDependencies()) == null || (it = var9_14.getAll()) == null) ** GOTO lbl-1000
                item$iv$iv /* !! */  = it;
                $i$f$filterIsInstance = false;
                $i$a$-map-LintResourceRepository$Companion$createRepository$3 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LintModelAndroidLibrary)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if ($this$filterIsInstance$iv != null) {
                    v1 = $this$filterIsInstance$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = project.getBuildLibraryModel();
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-LintResourceRepository$Companion$createRepository$libs$1 = false;
                        v1 = CollectionsKt.listOf((Object)it);
                    } else {
                        v1 = libs = CollectionsKt.emptyList();
                    }
                }
                if (scope == ResourceRepositoryScope.ALL_DEPENDENCIES && libs.isEmpty()) {
                    return this.get(client, project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                }
                $i$f$forEach = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)libs), (Function1)((Function1)new Function1<LintModelAndroidLibrary, LintResourceRepository>(client){
                    final /* synthetic */ LintCliClient $client;
                    {
                        this.$client = $client;
                        super(1);
                    }

                    @NotNull
                    public final LintResourceRepository invoke(@NotNull LintModelAndroidLibrary it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return com.android.tools.lint.LintResourceRepository$Companion.access$getForLibrary(LintResourceRepository.Companion, this.$client, it);
                    }
                })), (Function1)createRepository.6.INSTANCE);
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    it = (LintResourceRepository)element$iv;
                    $i$a$-forEach-LintResourceRepository$Companion$createRepository$7 = false;
                    ((Collection)repositories).add(it);
                }
            }
            v3 = ResourceNamespace.TODO();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"TODO()");
            return (ResourceRepository)new MergedResourceRepository(project, repositories, v3);
        }

        private final LintResourceRepository getOrCreateRepository(File serializedFile, LintClient client, File root, Project project, Function0<? extends LintResourceRepository> factory) {
            block4: {
                if (serializedFile.isFile()) {
                    String serialized = FilesKt.readText$default((File)serializedFile, null, (int)1, null);
                    try {
                        return LintResourcePersistence.INSTANCE.deserialize(serialized, client.getPathVariables(), root, project);
                    }
                    catch (Throwable e) {
                        if (warned) break block4;
                        warned = true;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Failed to deserialize cached resource repository.\nThis is an internal lint error which typically means that lint is being passed a\nserialized file that was created with an older version of lint or with a different\nset of path variable names. Attempting to gracefully recover.\n");
                        sb.append("The serialized content was:\n");
                        sb.append(serialized);
                        sb.append("\nStack: `");
                        sb.append(e.toString());
                        sb.append("`:");
                        LintDriver.Companion.appendStackTraceSummary$default((LintDriver.Companion)LintDriver.Companion, (Throwable)e, (StringBuilder)sb, (int)0, (int)0, (int)12, null);
                        String string = sb.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                        LintClient.Companion.report(client, IssueRegistry.LINT_WARNING, string, serializedFile, project);
                    }
                }
            }
            LintResourceRepository repository2 = (LintResourceRepository)((Object)factory.invoke());
            File file = serializedFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            Project project2 = project;
            String serialized = LintResourcePersistence.serialize$default(LintResourcePersistence.INSTANCE, repository2, client.getPathVariables(), project2 != null ? project2.getDir() : null, false, 8, null);
            FilesKt.writeText$default((File)serializedFile, (String)serialized, null, (int)2, null);
            return repository2;
        }

        private final LintResourceRepository getForProjectOnly(LintCliClient client, Project project) {
            LintResourceRepository lintResourceRepository;
            LintResourceRepository lintResourceRepository2 = (LintResourceRepository)((Object)project.getClientProperty((Object)ResourceRepositoryScope.PROJECT_ONLY));
            if (lintResourceRepository2 == null) {
                LintResourceRepository lintResourceRepository3;
                LintResourceRepository it = lintResourceRepository3 = this.getOrCreateRepository(client.getSerializationFile(project, XmlFileType.RESOURCE_REPOSITORY), client, project.getDir(), project, (Function0<? extends LintResourceRepository>)((Function0)new Function0<LintResourceRepository>(client, project){
                    final /* synthetic */ LintCliClient $client;
                    final /* synthetic */ Project $project;
                    {
                        this.$client = $client;
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final LintResourceRepository invoke() {
                        LintClient lintClient = this.$client;
                        ResourceNamespace resourceNamespace = ResourceNamespace.TODO();
                        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"TODO()");
                        return com.android.tools.lint.LintResourceRepository$Companion.access$createFromFolder(LintResourceRepository.Companion, lintClient, this.$project, resourceNamespace);
                    }
                }));
                boolean bl = false;
                project.putClientProperty((Object)ResourceRepositoryScope.PROJECT_ONLY, (Object)it);
                lintResourceRepository = lintResourceRepository3;
            } else {
                lintResourceRepository = lintResourceRepository2;
            }
            return lintResourceRepository;
        }

        private final File getLibraryResourceCacheFile(LintCliClient client, LintModelAndroidLibrary library) {
            return new File(client.getCacheDir("library-resources-v1", true), StringsKt.replace$default((String)library.getIdentifier(), (char)':', (char)'_', (boolean)false, (int)4, null));
        }

        private final File getFrameworkResourceCacheFile(LintCliClient client, String hash) {
            return new File(client.getCacheDir("framework-resources-v1", true), hash);
        }

        private final LintResourceRepository getForLibrary(LintCliClient client, LintModelAndroidLibrary library) {
            Map map = (Map)client.getClientProperty(LintResourceRepository.KEY_LIBRARY_CACHE);
            if (map == null) {
                HashMap hashMap;
                HashMap it = hashMap = new HashMap();
                boolean bl = false;
                client.putClientProperty(LintResourceRepository.KEY_LIBRARY_CACHE, it);
                map = hashMap;
            }
            Map cache = map;
            return this.getForLibrary(client, library, cache);
        }

        private final LintResourceRepository getForFramework(LintCliClient client, IAndroidTarget target) {
            File res = target.getPath(11).toFile();
            String string = target.hashString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.hashString()");
            Intrinsics.checkNotNullExpressionValue((Object)res, (String)"res");
            return this.getForFramework(string, res, client);
        }

        private final LintResourceRepository getForFramework(String hash, File res, LintCliClient client) {
            Map map = (Map)client.getClientProperty(LintResourceRepository.KEY_FRAMEWORK_CACHE);
            if (map == null) {
                HashMap hashMap;
                HashMap it = hashMap = new HashMap();
                boolean bl = false;
                client.putClientProperty(LintResourceRepository.KEY_FRAMEWORK_CACHE, it);
                map = hashMap;
            }
            Map cache = map;
            return this.getForFramework(client, hash, res, cache);
        }

        private final LintResourceRepository getForFramework(LintCliClient client, String hash, File res, Map<String, LintResourceRepository> cache) {
            LintResourceRepository lintResourceRepository = cache.get(hash);
            if (lintResourceRepository == null) {
                LintResourceRepository lintResourceRepository2;
                LintResourceRepository it = lintResourceRepository2 = this.getOrCreateRepository(this.getFrameworkResourceCacheFile(client, hash), client, null, null, (Function0<? extends LintResourceRepository>)((Function0)new Function0<LintResourceRepository>(client, res){
                    final /* synthetic */ LintCliClient $client;
                    final /* synthetic */ File $res;
                    {
                        this.$client = $client;
                        this.$res = $res;
                        super(0);
                    }

                    @NotNull
                    public final LintResourceRepository invoke() {
                        LintClient lintClient = this.$client;
                        Object[] objectArray = new File[]{this.$res};
                        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        ResourceNamespace resourceNamespace = ResourceNamespace.ANDROID;
                        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"ANDROID");
                        return LintResourceRepository.Companion.createFromFolder(lintClient, (Sequence<? extends File>)sequence, null, null, resourceNamespace);
                    }
                }));
                boolean bl = false;
                cache.put(hash, it);
                lintResourceRepository = lintResourceRepository2;
            }
            return lintResourceRepository;
        }

        private final LintResourceRepository getForLibrary(LintCliClient client, LintModelAndroidLibrary library, Map<LintModelAndroidLibrary, LintResourceRepository> cache) {
            LintResourceRepository lintResourceRepository = cache.get(library);
            if (lintResourceRepository == null) {
                LintResourceRepository lintResourceRepository2;
                LintResourceRepository it = lintResourceRepository2 = this.getOrCreateRepository(this.getLibraryResourceCacheFile(client, library), client, null, null, (Function0<? extends LintResourceRepository>)((Function0)new Function0<LintResourceRepository>(client, library){
                    final /* synthetic */ LintCliClient $client;
                    final /* synthetic */ LintModelAndroidLibrary $library;
                    {
                        this.$client = $client;
                        this.$library = $library;
                        super(0);
                    }

                    @NotNull
                    public final LintResourceRepository invoke() {
                        ResourceNamespace resourceNamespace = ResourceNamespace.TODO();
                        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"TODO()");
                        return new LintLibraryRepository(this.$client, this.$library, resourceNamespace);
                    }
                }));
                boolean bl = false;
                cache.put(library, it);
                lintResourceRepository = lintResourceRepository2;
            }
            return lintResourceRepository;
        }

        private final LintResourceRepository createFromFolder(LintClient client, Project project, ResourceNamespace namespace) {
            List list2 = project.getResourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project.resourceFolders");
            Sequence sequence = CollectionsKt.asSequence((Iterable)list2);
            List list3 = project.getGeneratedResourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"project.generatedResourceFolders");
            return this.createFromFolder(client, (Sequence<? extends File>)SequencesKt.plus((Sequence)sequence, (Iterable)list3), project, null, namespace);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LintResourceRepository createFromFolder(@NotNull LintClient client, @NotNull Sequence<? extends File> resourceFolders, @Nullable Project project, @Nullable String libraryName, @NotNull ResourceNamespace namespace) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(resourceFolders, (String)"resourceFolders");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Map map = new EnumMap(ResourceType.class);
            for (File resourceFolder : resourceFolders) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                File[] folders2;
                if (resourceFolder.listFiles() == null) continue;
                File[] fileArray = folders2;
                Function1 predicate$iv = skipHidden;
                boolean $i$f$filter = false;
                void var14_14 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)predicate$iv.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (File folder : CollectionsKt.sorted((Iterable)((List)destination$iv$iv))) {
                    Intrinsics.checkNotNullExpressionValue((Object)folder, (String)"folder");
                    this.scanTypeFolder(client, folder, libraryName, namespace, map);
                }
            }
            return new LintResourceRepository(project, map, namespace, libraryName);
        }

        /*
         * WARNING - void declaration
         */
        private final void scanTypeFolder(LintClient client, File folder, String libraryName, ResourceNamespace namespace, Map<ResourceType, ListMultimap<String, ResourceItem>> map) {
            Object object;
            FolderConfiguration config;
            ResourceFolderType folderType;
            block12: {
                block11: {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    if (!folder.isDirectory()) {
                        return;
                    }
                    String folderName = folder.getName();
                    ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)folderName);
                    if (resourceFolderType == null) {
                        return;
                    }
                    folderType = resourceFolderType;
                    FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
                    if (folderConfiguration == null) {
                        return;
                    }
                    config = folderConfiguration;
                    config.normalizeByAddingImpliedVersionQualifier();
                    object = folder.listFiles();
                    if (object == null) break block11;
                    File[] fileArray = object;
                    Function1 predicate$iv = skipHidden;
                    boolean $i$f$filter = false;
                    void var15_12 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        if (!((Boolean)predicate$iv.invoke((Object)element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                    if (object != null) break block12;
                }
                return;
            }
            Object files = object;
            if (folderType == ResourceFolderType.VALUES) {
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    this.processValues(client, namespace, map, config, libraryName, file);
                }
            } else {
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    this.processFiles(client, map, folderType, config, libraryName, namespace, file);
                }
            }
        }

        private final void processValues(LintClient client, ResourceNamespace namespace, Map<ResourceType, ListMultimap<String, ResourceItem>> map, FolderConfiguration config, String libraryName, File file) {
            if (!Lint.isXmlFile((File)file)) {
                return;
            }
            Document document = LintClient.getXmlDocument$default((LintClient)client, (File)file, null, (int)2, null);
            Element element = document != null ? document.getDocumentElement() : null;
            if (element == null) {
                return;
            }
            Element resources = element;
            ArrayList items = new ArrayList();
            Iterator iterator = DomExtensions.iterator((Element)resources);
            while (iterator.hasNext()) {
                ResourceType type;
                Element element2 = (Element)iterator.next();
                if (ResourceType.fromXmlTag((Node)element2) == null || type.isSynthetic()) continue;
                String name = element2.getAttribute("name");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (((CharSequence)name).length() == 0) {
                    if (type != ResourceType.PUBLIC) continue;
                    this.addItems(file, "", type, element2, config, libraryName, namespace, map, items);
                    continue;
                }
                this.addItems(file, name, type, element2, config, libraryName, namespace, map, items);
            }
            new ResourceFile(file, (List)items, config);
        }

        private final void addItems(File file, String name, ResourceType type, Element element, FolderConfiguration config, String libraryName, ResourceNamespace namespace, Map<ResourceType, ListMultimap<String, ResourceItem>> map, List<LintResourceItem> added) {
            LintResourceItem item = new LintResourceItem(file, name, namespace, type, element, libraryName != null, libraryName, config, false);
            this.recordItem$lint_cli(map, type, name, (ResourceItem)item);
            List<LintResourceItem> list2 = added;
            if (list2 != null) {
                list2.add(item);
            }
            if (type == ResourceType.STYLEABLE) {
                this.addStyleableItems(file, element, namespace, map, config, added);
            }
        }

        private final void addStyleableItems(File file, Element styleableNode, ResourceNamespace namespace, Map<ResourceType, ListMultimap<String, ResourceItem>> map, FolderConfiguration config, List<LintResourceItem> added) {
            boolean bl = Intrinsics.areEqual((Object)styleableNode.getNodeName(), (Object)"declare-styleable");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterator iterator = DomExtensions.iterator((Element)styleableNode);
            while (iterator.hasNext()) {
                ResourceType type;
                boolean bl2;
                Element element = (Element)iterator.next();
                String name = element.getAttribute("name");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (((CharSequence)name).length() == 0 || ResourceType.fromXmlTag((Node)element) == null) continue;
                boolean bl3 = bl2 = type == ResourceType.ATTR;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                LintResourceItem attr = new LintResourceItem(file, name, namespace, type, element, false, null, config, false);
                this.recordItem$lint_cli(map, type, name, (ResourceItem)attr);
                List<LintResourceItem> list2 = added;
                if (list2 == null) continue;
                list2.add(attr);
            }
        }

        private final void addIds(Element element, Map<ResourceType, ListMultimap<String, ResourceItem>> map, ResourceFolderType folderType, FolderConfiguration config, File file, ResourceNamespace namespace, List<ResourceMergerItem> added) {
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String name;
                Node attribute = attributes.item(i);
                String value = attribute.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (!StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)value.substring(5), (String)"this as java.lang.String).substring(startIndex)");
                LintResourceItem item = new LintResourceItem(file, name, namespace, ResourceType.ID, null, false, null, config, true);
                this.recordItem$lint_cli(map, ResourceType.ID, name, (ResourceItem)item);
                added.add(item);
            }
            Iterator iterator = DomExtensions.iterator((Element)element);
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                this.addIds(child, map, folderType, config, file, namespace, added);
            }
        }

        private final void processFiles(LintClient client, Map<ResourceType, ListMultimap<String, ResourceItem>> map, ResourceFolderType folderType, FolderConfiguration config, String libraryName, ResourceNamespace namespace, File file) {
            if (Lint.isXmlFile((File)file) && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType)) {
                Node node = LintClient.getXmlDocument$default((LintClient)client, (File)file, null, (int)2, null);
                if (node != null && (node = node.getDocumentElement()) != null) {
                    Node it = node;
                    boolean bl = false;
                    List items = new ArrayList();
                    Companion.addIds((Element)it, map, folderType, config, file, namespace, items);
                    if (!((Collection)items).isEmpty()) {
                        new ResourceFile(file, items, config);
                    }
                }
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            String name = Lint.getBaseName((String)string);
            ResourceType type = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            LintResourceItem item = new LintResourceItem(file, name, namespace, type, null, libraryName != null, libraryName, config, true);
            this.recordItem$lint_cli(map, type, name, (ResourceItem)item);
            new ResourceFile(file, (ResourceMergerItem)item, config);
        }

        public final void recordItem$lint_cli(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> map, @NotNull ResourceType type, @NotNull String name, @NotNull ResourceItem item) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            ListMultimap listMultimap = map.get(type);
            if (listMultimap == null) {
                Companion $this$recordItem_u24lambda_u2413 = this;
                boolean bl = false;
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create()");
                ListMultimap newMap = (ListMultimap)arrayListMultimap;
                map.put(type, (ListMultimap<String, ResourceItem>)newMap);
                listMultimap = newMap;
            }
            ListMultimap typeMap = listMultimap;
            typeMap.put((Object)name, (Object)item);
        }

        public static final /* synthetic */ LintResourceRepository access$getForLibrary(Companion $this, LintCliClient client, LintModelAndroidLibrary library) {
            return $this.getForLibrary(client, library);
        }

        public static final /* synthetic */ LintResourceRepository access$createFromFolder(Companion $this, LintClient client, Project project, ResourceNamespace namespace) {
            return $this.createFromFolder(client, project, namespace);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u000fH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/LintResourceRepository$Companion$EmptyRepository;", "Lcom/android/tools/lint/LintResourceRepository;", "()V", "accept", "Lcom/android/ide/common/resources/ResourceVisitor$VisitResult;", "visitor", "Lcom/android/ide/common/resources/ResourceVisitor;", "getLeafResourceRepositories", "", "Lcom/android/ide/common/resources/SingleNamespaceResourceRepository;", "getNamespaces", "", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "getResourcesInternal", "Lcom/google/common/collect/ListMultimap;", "", "Lcom/android/ide/common/resources/ResourceItem;", "namespace", "resourceType", "Lcom/android/resources/ResourceType;", "toString", "lint-cli"})
        public static final class EmptyRepository
        extends LintResourceRepository {
            @NotNull
            public static final EmptyRepository INSTANCE = new EmptyRepository();

            private EmptyRepository() {
                Map map = new EnumMap(ResourceType.class);
                ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
                Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
                super(null, map, resourceNamespace, null);
            }

            @Override
            @NotNull
            public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                return ResourceVisitor.VisitResult.ABORT;
            }

            @Override
            @NotNull
            public Set<ResourceNamespace> getNamespaces() {
                return SetsKt.emptySet();
            }

            @Override
            @NotNull
            public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
                return CollectionsKt.emptyList();
            }

            @Override
            @NotNull
            protected ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
                ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
                Intrinsics.checkNotNullExpressionValue((Object)immutableListMultimap, (String)"of()");
                return (ListMultimap)immutableListMultimap;
            }

            @Override
            @NotNull
            public String toString() {
                String string = ((Object)((Object)this)).getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this::class.java.simpleName");
                return string;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/LintResourceRepository$LintLibraryRepository;", "Lcom/android/tools/lint/LintResourceRepository;", "client", "Lcom/android/tools/lint/LintCliClient;", "library", "Lcom/android/tools/lint/model/LintModelAndroidLibrary;", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/model/LintModelAndroidLibrary;Lcom/android/ide/common/rendering/api/ResourceNamespace;)V", "getResourcesInternal", "Lcom/google/common/collect/ListMultimap;", "", "Lcom/android/ide/common/resources/ResourceItem;", "resourceType", "Lcom/android/resources/ResourceType;", "toString", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintResourceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintResourceRepository.kt\ncom/android/tools/lint/LintResourceRepository$LintLibraryRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,915:1\n3792#2:916\n4307#2,2:917\n1855#3,2:919\n26#4:921\n*S KotlinDebug\n*F\n+ 1 LintResourceRepository.kt\ncom/android/tools/lint/LintResourceRepository$LintLibraryRepository\n*L\n263#1:916\n263#1:917,2\n263#1:919,2\n282#1:921\n*E\n"})
    public static final class LintLibraryRepository
    extends LintResourceRepository {
        @NotNull
        private final LintCliClient client;
        @NotNull
        private final LintModelAndroidLibrary library;

        /*
         * WARNING - void declaration
         */
        public LintLibraryRepository(@NotNull LintCliClient client, @NotNull LintModelAndroidLibrary library, @NotNull ResourceNamespace namespace) {
            block3: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                File[] listFiles;
                Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                super(null, new EnumMap(ResourceType.class), namespace, library.getResolvedCoordinates().toString());
                this.client = client;
                this.library = library;
                Object object = listFiles = this.library.getResFolder().listFiles();
                if (listFiles == null) break block3;
                File[] fileArray = object;
                Function1 predicate$iv = skipHidden;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)predicate$iv.invoke((Object)element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                if (object != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File folder = (File)element$iv;
                        boolean bl = false;
                        Companion.scanTypeFolder(this.client, folder, this.getLibraryName(), namespace, this.getTypeToMap$lint_cli());
                    }
                }
            }
        }

        @Override
        @NotNull
        protected ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            ListMultimap<String, ResourceItem> listMultimap = this.getTypeToMap$lint_cli().get(resourceType);
            if (listMultimap == null) {
                File[] fileArray;
                LintLibraryRepository $this$getResourcesInternal_u24lambda_u241 = this;
                boolean bl = false;
                List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType);
                File[] fileArray2 = $this$getResourcesInternal_u24lambda_u241.library.getResFolder().listFiles(new FileFilter(folderTypes){
                    final /* synthetic */ List<ResourceFolderType> $folderTypes;
                    {
                        this.$folderTypes = $folderTypes;
                    }

                    public final boolean accept(File folder) {
                        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder.getName());
                        return folderType != null && this.$folderTypes.contains(folderType);
                    }
                });
                if (fileArray2 == null) {
                    boolean $i$f$emptyArray = false;
                    fileArray = new File[]{};
                } else {
                    fileArray = fileArray2;
                }
                File[] folders2 = fileArray;
                String libraryName = $this$getResourcesInternal_u24lambda_u241.library.getResolvedCoordinates().toString();
                for (File folder : ArraysKt.sorted((Comparable[])folders2)) {
                    LintClient lintClient = $this$getResourcesInternal_u24lambda_u241.client;
                    Intrinsics.checkNotNullExpressionValue((Object)folder, (String)"folder");
                    Companion.scanTypeFolder(lintClient, folder, libraryName, namespace, $this$getResourcesInternal_u24lambda_u241.getTypeToMap$lint_cli());
                }
                for (ResourceFolderType scannedFolderTypes : folderTypes) {
                    List scannedTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)scannedFolderTypes);
                    for (ResourceType scannedType : scannedTypes) {
                        ArrayListMultimap arrayListMultimap;
                        if ($this$getResourcesInternal_u24lambda_u241.getTypeToMap$lint_cli().get(scannedType) != null) continue;
                        Map<ResourceType, ListMultimap<String, ResourceItem>> map = $this$getResourcesInternal_u24lambda_u241.getTypeToMap$lint_cli();
                        Intrinsics.checkNotNullExpressionValue((Object)scannedType, (String)"scannedType");
                        ResourceType resourceType2 = scannedType;
                        Intrinsics.checkNotNullExpressionValue((Object)ArrayListMultimap.create(), (String)"create()");
                        map.put(resourceType2, (ListMultimap<String, ResourceItem>)arrayListMultimap);
                    }
                }
                ListMultimap<String, ResourceItem> listMultimap2 = $this$getResourcesInternal_u24lambda_u241.getTypeToMap$lint_cli().get(resourceType);
                Intrinsics.checkNotNull(listMultimap2);
                listMultimap = listMultimap2;
            }
            return listMultimap;
        }

        @Override
        @NotNull
        public String toString() {
            return "Resources for " + this.library.getResolvedCoordinates();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\fH\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J$\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\fH\u0014J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020\u000eH\u0016R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/LintResourceRepository$MergedResourceRepository;", "Lcom/android/ide/common/resources/AbstractResourceRepository;", "project", "Lcom/android/tools/lint/detector/api/Project;", "repositories", "", "Lcom/android/tools/lint/LintResourceRepository;", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "(Lcom/android/tools/lint/detector/api/Project;Ljava/util/List;Lcom/android/ide/common/rendering/api/ResourceNamespace;)V", "cache", "Ljava/util/EnumMap;", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "", "Lcom/android/ide/common/resources/ResourceItem;", "accept", "Lcom/android/ide/common/resources/ResourceVisitor$VisitResult;", "visitor", "Lcom/android/ide/common/resources/ResourceVisitor;", "getLeafResourceRepositories", "", "Lcom/android/ide/common/resources/SingleNamespaceResourceRepository;", "getNamespaces", "", "getPublicResources", "", "type", "getResources", "", "resourceType", "resourceName", "getResourcesInternal", "hasResources", "", "toString", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintResourceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintResourceRepository.kt\ncom/android/tools/lint/LintResourceRepository$MergedResourceRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,915:1\n1855#2:916\n1856#2:918\n1855#2,2:919\n1#3:917\n*S KotlinDebug\n*F\n+ 1 LintResourceRepository.kt\ncom/android/tools/lint/LintResourceRepository$MergedResourceRepository\n*L\n182#1:916\n182#1:918\n205#1:919,2\n*E\n"})
    public static final class MergedResourceRepository
    extends AbstractResourceRepository {
        @NotNull
        private final Project project;
        @NotNull
        private final List<LintResourceRepository> repositories;
        @NotNull
        private final ResourceNamespace namespace;
        @NotNull
        private final EnumMap<ResourceType, ListMultimap<String, ResourceItem>> cache;

        public MergedResourceRepository(@NotNull Project project, @NotNull List<? extends LintResourceRepository> repositories, @NotNull ResourceNamespace namespace) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            this.project = project;
            this.repositories = repositories;
            this.namespace = namespace;
            this.cache = new EnumMap(ResourceType.class);
        }

        @NotNull
        public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            for (ResourceType type : ResourceType.values()) {
                if (!visitor.shouldVisitResourceType(type)) continue;
                for (LintResourceRepository repository2 : this.repositories) {
                    ListMultimap<String, ResourceItem> map = repository2.getResourcesInternal(this.namespace, type);
                    for (Map.Entry entry : map.entries()) {
                        Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"map.entries()");
                        ResourceItem item = (ResourceItem)entry.getValue();
                        if (visitor.visit(item) != ResourceVisitor.VisitResult.ABORT) continue;
                        return ResourceVisitor.VisitResult.ABORT;
                    }
                }
            }
            return ResourceVisitor.VisitResult.CONTINUE;
        }

        @NotNull
        public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            LintResourceRepositoryKt.access$unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Set<ResourceNamespace> getNamespaces() {
            LintResourceRepositoryKt.access$unsupported();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
            return this.repositories;
        }

        @NotNull
        protected ListMultimap<String, ResourceItem> getResourcesInternal(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
            ListMultimap listMultimap;
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ListMultimap listMultimap2 = this.cache.get(type);
            if (listMultimap2 == null) {
                MergedResourceRepository $this$getResourcesInternal_u24lambda_u242 = this;
                boolean bl = false;
                int keyCount = 100;
                int valuesPerKey = 5;
                ArrayListMultimap map = ArrayListMultimap.create((int)keyCount, (int)valuesPerKey);
                Iterable $this$forEach$iv = $this$getResourcesInternal_u24lambda_u242.repositories;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ListMultimap<String, ResourceItem> it;
                    LintResourceRepository repository2 = (LintResourceRepository)((Object)element$iv);
                    boolean bl2 = false;
                    ListMultimap<String, ResourceItem> repoMap = repository2.getTypeToMap$lint_cli().get(type);
                    if (repoMap == null) continue;
                    boolean bl3 = false;
                    map.putAll((Multimap)it);
                }
                ((Map)$this$getResourcesInternal_u24lambda_u242.cache).put(type, map);
                ArrayListMultimap arrayListMultimap = map;
                Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"run {\n          val keyC\u2026p\n          map\n        }");
                listMultimap = (ListMultimap)arrayListMultimap;
            } else {
                listMultimap = listMultimap2;
            }
            return listMultimap;
        }

        @NotNull
        public List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            ArrayList list2 = new ArrayList();
            Iterable $this$forEach$iv = this.repositories;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintResourceRepository repository2 = (LintResourceRepository)((Object)element$iv);
                boolean bl = false;
                list2.addAll(repository2.getResources(namespace, resourceType, resourceName));
            }
            return list2;
        }

        public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            for (LintResourceRepository repository2 : this.repositories) {
                if (!repository2.hasResources(namespace, resourceType, resourceName)) continue;
                return true;
            }
            return false;
        }

        public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            for (LintResourceRepository repository2 : this.repositories) {
                if (!repository2.hasResources(namespace, resourceType)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public String toString() {
            return "Resources for " + this.project.getName() + " with dependencies";
        }
    }
}

