/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.vision.common.InputImage;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public class BitmapInStreamingChecker {
    private static final GmsLogger zza = new GmsLogger("StreamingFormatChecker", "");
    private final LinkedList zzb = new LinkedList();
    private long zzc = -1L;

    @KeepForSdk
    public void check(@NonNull InputImage input) {
        long l;
        if (input.getFormat() != -1) {
            return;
        }
        long l2 = SystemClock.elapsedRealtime();
        this.zzb.add(l2);
        if (this.zzb.size() > 5) {
            this.zzb.removeFirst();
        }
        if (this.zzb.size() != 5 || l2 - (Long)Preconditions.checkNotNull((Object)((Long)this.zzb.peekFirst())) >= 5000L || (l = this.zzc) != -1L && l2 - l < TimeUnit.SECONDS.toMillis(5L)) {
            return;
        }
        this.zzc = l2;
        zza.w("StreamingFormatChecker", "ML Kit has detected that you seem to pass camera frames to the detector as a Bitmap object. This is inefficient. Please use YUV_420_888 format for camera2 API or NV21 format for (legacy) camera API and directly pass down the byte array to ML Kit.");
    }
}

