/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Looper;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginManager;

public class CordovaResourceApi {
    private static final String LOG_TAG = "CordovaResourceApi";
    public static final int URI_TYPE_FILE = 0;
    public static final int URI_TYPE_ASSET = 1;
    public static final int URI_TYPE_CONTENT = 2;
    public static final int URI_TYPE_RESOURCE = 3;
    public static final int URI_TYPE_DATA = 4;
    public static final int URI_TYPE_HTTP = 5;
    public static final int URI_TYPE_HTTPS = 6;
    public static final int URI_TYPE_PLUGIN = 7;
    public static final int URI_TYPE_UNKNOWN = -1;
    public static final String PLUGIN_URI_SCHEME = "cdvplugin";
    private static final String[] LOCAL_FILE_PROJECTION = new String[]{"_data"};
    public static Thread jsThread;
    private final AssetManager assetManager;
    private final ContentResolver contentResolver;
    private final PluginManager pluginManager;
    private boolean threadCheckingEnabled = true;

    public CordovaResourceApi(Context context, PluginManager pluginManager) {
        this.contentResolver = context.getContentResolver();
        this.assetManager = context.getAssets();
        this.pluginManager = pluginManager;
    }

    public void setThreadCheckingEnabled(boolean value) {
        this.threadCheckingEnabled = value;
    }

    public boolean isThreadCheckingEnabled() {
        return this.threadCheckingEnabled;
    }

    public static int getUriType(Uri uri) {
        CordovaResourceApi.assertNonRelative(uri);
        String scheme = uri.getScheme();
        if ("content".equalsIgnoreCase(scheme)) {
            return 2;
        }
        if ("android.resource".equalsIgnoreCase(scheme)) {
            return 3;
        }
        if ("file".equalsIgnoreCase(scheme)) {
            if (uri.getPath().startsWith("/android_asset/")) {
                return 1;
            }
            return 0;
        }
        if ("data".equalsIgnoreCase(scheme)) {
            return 4;
        }
        if ("http".equalsIgnoreCase(scheme)) {
            return 5;
        }
        if ("https".equalsIgnoreCase(scheme)) {
            return 6;
        }
        if (PLUGIN_URI_SCHEME.equalsIgnoreCase(scheme)) {
            return 7;
        }
        return -1;
    }

    public Uri remapUri(Uri uri) {
        CordovaResourceApi.assertNonRelative(uri);
        Uri pluginUri = this.pluginManager.remapUri(uri);
        return pluginUri != null ? pluginUri : uri;
    }

    public String remapPath(String path) {
        return this.remapUri(Uri.fromFile((File)new File(path))).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File mapUriToFile(Uri uri) {
        this.assertBackgroundThread();
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: {
                return new File(uri.getPath());
            }
            case 2: {
                Cursor cursor = this.contentResolver.query(uri, LOCAL_FILE_PROJECTION, null, null, null);
                if (cursor == null) break;
                try {
                    int columnIndex = cursor.getColumnIndex(LOCAL_FILE_PROJECTION[0]);
                    if (columnIndex != -1 && cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        String realPath = cursor.getString(columnIndex);
                        if (realPath != null) {
                            File file = new File(realPath);
                            return file;
                        }
                    }
                    break;
                }
                finally {
                    cursor.close();
                }
            }
        }
        return null;
    }

    public String getMimeType(Uri uri) {
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: 
            case 1: {
                return this.getMimeTypeFromPath(uri.getPath());
            }
            case 2: 
            case 3: {
                return this.contentResolver.getType(uri);
            }
            case 4: {
                return this.getDataUriMimeType(uri);
            }
            case 5: 
            case 6: {
                try {
                    HttpURLConnection conn = (HttpURLConnection)new URL(uri.toString()).openConnection();
                    conn.setDoInput(false);
                    conn.setRequestMethod("HEAD");
                    String mimeType = conn.getHeaderField("Content-Type");
                    if (mimeType != null) {
                        mimeType = mimeType.split(";")[0];
                    }
                    return mimeType;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String getMimeTypeFromPath(String path) {
        String extension = path;
        int lastDot = extension.lastIndexOf(46);
        if (lastDot != -1) {
            extension = extension.substring(lastDot + 1);
        }
        if ((extension = extension.toLowerCase(Locale.getDefault())).equals("3ga")) {
            return "audio/3gpp";
        }
        if (extension.equals("js")) {
            return "text/javascript";
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }

    public OpenForReadResult openForRead(Uri uri) throws IOException {
        return this.openForRead(uri, false);
    }

    public OpenForReadResult openForRead(Uri uri, boolean skipThreadCheck) throws IOException {
        if (!skipThreadCheck) {
            this.assertBackgroundThread();
        }
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: {
                FileInputStream inputStream = new FileInputStream(uri.getPath());
                String mimeType = this.getMimeTypeFromPath(uri.getPath());
                long length = inputStream.getChannel().size();
                return new OpenForReadResult(uri, inputStream, mimeType, length, null);
            }
            case 1: {
                InputStream inputStream;
                String assetPath = uri.getPath().substring(15);
                AssetFileDescriptor assetFd = null;
                long length = -1L;
                try {
                    assetFd = this.assetManager.openFd(assetPath);
                    inputStream = assetFd.createInputStream();
                    length = assetFd.getLength();
                }
                catch (FileNotFoundException e) {
                    inputStream = this.assetManager.open(assetPath);
                    length = inputStream.available();
                }
                String mimeType = this.getMimeTypeFromPath(assetPath);
                return new OpenForReadResult(uri, inputStream, mimeType, length, assetFd);
            }
            case 2: 
            case 3: {
                String mimeType = this.contentResolver.getType(uri);
                AssetFileDescriptor assetFd = this.contentResolver.openAssetFileDescriptor(uri, "r");
                FileInputStream inputStream = assetFd.createInputStream();
                long length = assetFd.getLength();
                return new OpenForReadResult(uri, inputStream, mimeType, length, assetFd);
            }
            case 4: {
                OpenForReadResult ret = this.readDataUri(uri);
                if (ret == null) break;
                return ret;
            }
            case 5: 
            case 6: {
                HttpURLConnection conn = (HttpURLConnection)new URL(uri.toString()).openConnection();
                conn.setRequestProperty("Accept-Encoding", "gzip");
                conn.setDoInput(true);
                String mimeType = conn.getHeaderField("Content-Type");
                if (mimeType != null) {
                    mimeType = mimeType.split(";")[0];
                }
                int length = conn.getContentLength();
                InputStream inputStream = "gzip".equals(conn.getContentEncoding()) ? new GZIPInputStream(conn.getInputStream()) : conn.getInputStream();
                return new OpenForReadResult(uri, inputStream, mimeType, length, null);
            }
            case 7: {
                String pluginId = uri.getHost();
                CordovaPlugin plugin = this.pluginManager.getPlugin(pluginId);
                if (plugin == null) {
                    throw new FileNotFoundException("Invalid plugin ID in URI: " + uri);
                }
                return plugin.handleOpenForRead(uri);
            }
        }
        throw new FileNotFoundException("URI not supported by CordovaResourceApi: " + uri);
    }

    public OutputStream openOutputStream(Uri uri) throws IOException {
        return this.openOutputStream(uri, false);
    }

    public OutputStream openOutputStream(Uri uri, boolean append) throws IOException {
        this.assertBackgroundThread();
        switch (CordovaResourceApi.getUriType(uri)) {
            case 0: {
                File localFile = new File(uri.getPath());
                File parent = localFile.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                return new FileOutputStream(localFile, append);
            }
            case 2: 
            case 3: {
                AssetFileDescriptor assetFd = this.contentResolver.openAssetFileDescriptor(uri, append ? "wa" : "w");
                return assetFd.createOutputStream();
            }
        }
        throw new FileNotFoundException("URI not supported by CordovaResourceApi: " + uri);
    }

    public HttpURLConnection createHttpConnection(Uri uri) throws IOException {
        this.assertBackgroundThread();
        return (HttpURLConnection)new URL(uri.toString()).openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(OpenForReadResult input, OutputStream outputStream) throws IOException {
        block8: {
            this.assertBackgroundThread();
            try {
                int bytesRead;
                InputStream inputStream = input.inputStream;
                if (inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                    FileChannel inChannel = ((FileInputStream)input.inputStream).getChannel();
                    FileChannel outChannel = ((FileOutputStream)outputStream).getChannel();
                    long offset = 0L;
                    long length = input.length;
                    if (input.assetFd != null) {
                        offset = input.assetFd.getStartOffset();
                    }
                    inChannel.position(offset);
                    outChannel.transferFrom(inChannel, 0L, length);
                    break block8;
                }
                int BUFFER_SIZE = 8192;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer, 0, 8192)) > 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            finally {
                input.inputStream.close();
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public void copyResource(Uri sourceUri, OutputStream outputStream) throws IOException {
        this.copyResource(this.openForRead(sourceUri), outputStream);
    }

    public void copyResource(Uri sourceUri, Uri dstUri) throws IOException {
        this.copyResource(this.openForRead(sourceUri), this.openOutputStream(dstUri));
    }

    private void assertBackgroundThread() {
        if (this.threadCheckingEnabled) {
            Thread curThread = Thread.currentThread();
            if (curThread == Looper.getMainLooper().getThread()) {
                throw new IllegalStateException("Do not perform IO operations on the UI thread. Use CordovaInterface.getThreadPool() instead.");
            }
            if (curThread == jsThread) {
                throw new IllegalStateException("Tried to perform an IO operation on the WebCore thread. Use CordovaInterface.getThreadPool() instead.");
            }
        }
    }

    private String getDataUriMimeType(Uri uri) {
        String uriAsString = uri.getSchemeSpecificPart();
        int commaPos = uriAsString.indexOf(44);
        if (commaPos == -1) {
            return null;
        }
        String[] mimeParts = uriAsString.substring(0, commaPos).split(";");
        if (mimeParts.length > 0) {
            return mimeParts[0];
        }
        return null;
    }

    private OpenForReadResult readDataUri(Uri uri) {
        byte[] data;
        String uriAsString = uri.getSchemeSpecificPart();
        int commaPos = uriAsString.indexOf(44);
        if (commaPos == -1) {
            return null;
        }
        String[] mimeParts = uriAsString.substring(0, commaPos).split(";");
        String contentType = null;
        boolean base64 = false;
        if (mimeParts.length > 0) {
            contentType = mimeParts[0];
        }
        for (int i = 1; i < mimeParts.length; ++i) {
            if (!"base64".equalsIgnoreCase(mimeParts[i])) continue;
            base64 = true;
        }
        String dataPartAsString = uriAsString.substring(commaPos + 1);
        if (base64) {
            data = Base64.decode((String)dataPartAsString, (int)0);
        } else {
            try {
                data = dataPartAsString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                data = dataPartAsString.getBytes();
            }
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        return new OpenForReadResult(uri, inputStream, contentType, data.length, null);
    }

    private static void assertNonRelative(Uri uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Relative URIs are not supported.");
        }
    }

    public static final class OpenForReadResult {
        public final Uri uri;
        public final InputStream inputStream;
        public final String mimeType;
        public final long length;
        public final AssetFileDescriptor assetFd;

        public OpenForReadResult(Uri uri, InputStream inputStream, String mimeType, long length, AssetFileDescriptor assetFd) {
            this.uri = uri;
            this.inputStream = inputStream;
            this.mimeType = mimeType;
            this.length = length;
            this.assetFd = assetFd;
        }
    }
}

