/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class ViewUtils {
    private static final String TAG = "ViewUtils";
    private static Method sComputeFitSystemWindowsMethod;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @ChecksSdkIntAtLeast(api=27)
    static final boolean SDK_LEVEL_SUPPORTS_AUTOSIZE;

    private ViewUtils() {
    }

    public static boolean isLayoutRtl(View view) {
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    public static void computeFitSystemWindows(View view, Rect inoutInsets, Rect outLocalInsets) {
        if (sComputeFitSystemWindowsMethod != null) {
            try {
                sComputeFitSystemWindowsMethod.invoke((Object)view, inoutInsets, outLocalInsets);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"Could not invoke computeFitSystemWindows", (Throwable)e);
            }
        }
    }

    public static void makeOptionalFitsSystemWindows(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Method method = view.getClass().getMethod("makeOptionalFitsSystemWindows", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)view, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Log.d((String)TAG, (String)"Could not find method makeOptionalFitsSystemWindows. Oh well...");
            }
            catch (InvocationTargetException e) {
                Log.d((String)TAG, (String)"Could not invoke makeOptionalFitsSystemWindows", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.d((String)TAG, (String)"Could not invoke makeOptionalFitsSystemWindows", (Throwable)e);
            }
        }
    }

    static {
        boolean bl = SDK_LEVEL_SUPPORTS_AUTOSIZE = Build.VERSION.SDK_INT >= 27;
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                sComputeFitSystemWindowsMethod = View.class.getDeclaredMethod("computeFitSystemWindows", Rect.class, Rect.class);
                if (!sComputeFitSystemWindowsMethod.isAccessible()) {
                    sComputeFitSystemWindowsMethod.setAccessible(true);
                }
            }
            catch (NoSuchMethodException e) {
                Log.d((String)TAG, (String)"Could not find method computeFitSystemWindows. Oh well.");
            }
        }
    }
}

