/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat;

import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u0018\u0019\u001a\u001bB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/appcompat/BaseMethodDeprecationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "conditions", "", "Landroidx/appcompat/BaseMethodDeprecationDetector$DeprecationCondition;", "(Lcom/android/tools/lint/detector/api/Issue;[Landroidx/appcompat/BaseMethodDeprecationDetector$DeprecationCondition;)V", "applicableMethods", "", "", "getConditions", "()[Landroidx/appcompat/BaseMethodDeprecationDetector$DeprecationCondition;", "[Landroidx/appcompat/BaseMethodDeprecationDetector$DeprecationCondition;", "getApplicableMethodNames", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "DeprecationCondition", "MethodLocation", "Predicate", "SubClassOf", "appcompat-lint"})
public abstract class BaseMethodDeprecationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    private final Issue issue;
    @NotNull
    private final DeprecationCondition[] conditions;
    @NotNull
    private final List<String> applicableMethods;

    /*
     * WARNING - void declaration
     */
    public BaseMethodDeprecationDetector(@NotNull Issue issue, DeprecationCondition ... conditions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)conditions, (String)"conditions");
        this.issue = issue;
        DeprecationCondition[] deprecationConditionArray = this.conditions = conditions;
        BaseMethodDeprecationDetector baseMethodDeprecationDetector = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMethodLocation().getMethodName());
        }
        baseMethodDeprecationDetector.applicableMethods = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final DeprecationCondition[] getConditions() {
        return this.conditions;
    }

    @NotNull
    public final List<String> getApplicableMethodNames() {
        return this.applicableMethods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        DeprecationCondition[] deprecationConditionArray = this.conditions;
        int n = 0;
        int n2 = deprecationConditionArray.length;
        while (n < n2) {
            DeprecationCondition deprecationCondition;
            DeprecationCondition condition = deprecationCondition = deprecationConditionArray[n];
            boolean bl = false;
            if (condition.matches(context, node, method)) {
                Unit unit;
                Incident incident = IncidentKt.Incident((Context)((Context)context)).issue(this.issue).at((Object)node).message(condition.getMessage());
                if (condition.getConstraint() != null) {
                    Constraint constraint;
                    boolean bl2 = false;
                    context.report(incident, constraint);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    context.report(incident);
                }
                if (condition.getConstraint() == null) {
                    return;
                }
            }
            boolean bl3 = false;
            if (bl3) return;
            ++n;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Landroidx/appcompat/BaseMethodDeprecationDetector$Predicate;", "", "matches", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "appcompat-lint"})
    public static interface Predicate {
        public boolean matches(@NotNull JavaContext var1, @NotNull UCallExpression var2, @NotNull PsiMethod var3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/appcompat/BaseMethodDeprecationDetector$SubClassOf;", "Landroidx/appcompat/BaseMethodDeprecationDetector$Predicate;", "superClass", "", "(Ljava/lang/String;)V", "matches", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "appcompat-lint"})
    public static final class SubClassOf
    implements Predicate {
        @NotNull
        private final String superClass;

        public SubClassOf(@NotNull String superClass) {
            Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
            this.superClass = superClass;
        }

        @Override
        public boolean matches(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            PsiType psiType = node.getReceiverType();
            PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            return context.getEvaluator().extendsClass((PsiClass)(psiClassType != null ? psiClassType.resolve() : null), this.superClass, false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/appcompat/BaseMethodDeprecationDetector$MethodLocation;", "Landroidx/appcompat/BaseMethodDeprecationDetector$Predicate;", "className", "", "methodName", "params", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getMethodName", "()Ljava/lang/String;", "[Ljava/lang/String;", "matches", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "appcompat-lint"})
    public static final class MethodLocation
    implements Predicate {
        @NotNull
        private final String className;
        @NotNull
        private final String methodName;
        @NotNull
        private final String[] params;

        public MethodLocation(@NotNull String className, @NotNull String methodName, String ... params) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.className = className;
            this.methodName = methodName;
            this.params = params;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @Override
        public boolean matches(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (!context.getEvaluator().isMemberInClass((PsiMember)method, this.className)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)this.methodName)) {
                return false;
            }
            String[] stringArray = this.params;
            return context.getEvaluator().methodMatches(method, this.className, true, Arrays.copyOf(stringArray, stringArray.length));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\"\u00020\u0001\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001a"}, d2={"Landroidx/appcompat/BaseMethodDeprecationDetector$DeprecationCondition;", "Landroidx/appcompat/BaseMethodDeprecationDetector$Predicate;", "methodLocation", "Landroidx/appcompat/BaseMethodDeprecationDetector$MethodLocation;", "message", "", "predicates", "", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "(Landroidx/appcompat/BaseMethodDeprecationDetector$MethodLocation;Ljava/lang/String;[Landroidx/appcompat/BaseMethodDeprecationDetector$Predicate;Lcom/android/tools/lint/detector/api/Constraint;)V", "getConstraint", "()Lcom/android/tools/lint/detector/api/Constraint;", "getMessage", "()Ljava/lang/String;", "getMethodLocation", "()Landroidx/appcompat/BaseMethodDeprecationDetector$MethodLocation;", "[Landroidx/appcompat/BaseMethodDeprecationDetector$Predicate;", "matches", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "appcompat-lint"})
    public static final class DeprecationCondition
    implements Predicate {
        @NotNull
        private final MethodLocation methodLocation;
        @NotNull
        private final String message;
        @NotNull
        private final Predicate[] predicates;
        @Nullable
        private final Constraint constraint;

        public DeprecationCondition(@NotNull MethodLocation methodLocation, @NotNull String message, @NotNull Predicate[] predicates, @Nullable Constraint constraint) {
            Intrinsics.checkNotNullParameter((Object)methodLocation, (String)"methodLocation");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)predicates, (String)"predicates");
            this.methodLocation = methodLocation;
            this.message = message;
            this.predicates = predicates;
            this.constraint = constraint;
        }

        public /* synthetic */ DeprecationCondition(MethodLocation methodLocation, String string, Predicate[] predicateArray, Constraint constraint, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                constraint = null;
            }
            this(methodLocation, string, predicateArray, constraint);
        }

        @NotNull
        public final MethodLocation getMethodLocation() {
            return this.methodLocation;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final Constraint getConstraint() {
            return this.constraint;
        }

        @Override
        public boolean matches(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (!this.methodLocation.matches(context, node, method)) {
                return false;
            }
            for (Predicate predicate : this.predicates) {
                if (predicate.matches(context, node, method)) continue;
                return false;
            }
            return true;
        }
    }
}

