/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.res;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Landroidx/appcompat/res/ColorStateListAlphaDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "appcompat-lint"})
public final class ColorStateListAlphaDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue NOT_USING_ANDROID_ALPHA = Issue.Companion.create("UseAndroidAlpha", "`android:alpha` attribute missing on `ColorStateList`", "`ColorStateList` uses app:alpha without `android:alpha`", Category.CORRECTNESS, 1, Severity.ERROR, new Implementation(ColorStateListAlphaDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"selector");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        NodeList items = element.getElementsByTagName("item");
        int n = items.getLength();
        for (int index = 0; index < n; ++index) {
            Node node = items.item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element item = (Element)node;
            if (!item.hasAttributeNS("http://schemas.android.com/apk/res/android", "color")) continue;
            boolean hasAppAlphaAttr = item.hasAttributeNS("http://schemas.android.com/apk/res-auto", "alpha");
            boolean hasAndroidAlphaAttr = item.hasAttributeNS("http://schemas.android.com/apk/res/android", "alpha");
            if (!hasAppAlphaAttr || hasAndroidAlphaAttr) continue;
            Node node2 = item;
            Attr attr = item.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "alpha");
            Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"item.getAttributeNodeNS(\u2026stants.AUTO_URI, \"alpha\")");
            context.report(NOT_USING_ANDROID_ALPHA, node2, context.getLocation((Node)attr), "Must use `android:alpha` if `app:alpha` is used", LintFix.Companion.create().set("http://schemas.android.com/apk/res/android", "alpha", item.getAttributeNS("http://schemas.android.com/apk/res-auto", "alpha")).build());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/appcompat/res/ColorStateListAlphaDetector$Companion;", "", "()V", "NOT_USING_ANDROID_ALPHA", "Lcom/android/tools/lint/detector/api/Issue;", "getNOT_USING_ANDROID_ALPHA$appcompat_lint", "()Lcom/android/tools/lint/detector/api/Issue;", "appcompat-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getNOT_USING_ANDROID_ALPHA$appcompat_lint() {
            return NOT_USING_ANDROID_ALPHA;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

