/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Landroidx/appcompat/widget/SwitchUsageCodeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "createUastHandler", "Landroidx/appcompat/widget/SwitchUsageCodeDetector$SwitchUsageUastHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "SwitchUsageUastHandler", "appcompat-lint"})
public final class SwitchUsageCodeDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String USING_CORE_SWITCH_DESCRIPTION = "Use `SwitchCompat` from AppCompat or `SwitchMaterial` from Material library";
    @NotNull
    private static final Issue USING_CORE_SWITCH_CODE = Issue.Companion.create("UseSwitchCompatOrMaterialCode", "Replace usage of `Switch` widget", "Use `SwitchCompat` from AppCompat or `SwitchMaterial` from Material library", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(SwitchUsageCodeDetector.class, Scope.JAVA_FILE_SCOPE));

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UVariable.class, UClass.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public SwitchUsageUastHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new SwitchUsageUastHandler(context);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/appcompat/widget/SwitchUsageCodeDetector$Companion;", "", "()V", "USING_CORE_SWITCH_CODE", "Lcom/android/tools/lint/detector/api/Issue;", "getUSING_CORE_SWITCH_CODE$appcompat_lint", "()Lcom/android/tools/lint/detector/api/Issue;", "USING_CORE_SWITCH_DESCRIPTION", "", "appcompat-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUSING_CORE_SWITCH_CODE$appcompat_lint() {
            return USING_CORE_SWITCH_CODE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/appcompat/widget/SwitchUsageCodeDetector$SwitchUsageUastHandler;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkAndReport", "", "type", "Lcom/intellij/psi/PsiType;", "node", "Lorg/jetbrains/uast/UElement;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitVariable", "Lorg/jetbrains/uast/UVariable;", "appcompat-lint"})
    public static final class SwitchUsageUastHandler
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public SwitchUsageUastHandler(@NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        public void visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable $this$forEach$iv = node.getUastSuperTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UTypeReferenceExpression it = (UTypeReferenceExpression)element$iv;
                boolean bl = false;
                this.checkAndReport(it.getType(), (UElement)it);
            }
        }

        public void visitVariable(@NotNull UVariable node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkAndReport(node.getType(), (UElement)node);
        }

        private final void checkAndReport(PsiType type, UElement node) {
            if (this.context.getEvaluator().typeMatches(type, "android.widget.Switch")) {
                JavaContext.report$default((JavaContext)this.context, (Issue)Companion.getUSING_CORE_SWITCH_CODE$appcompat_lint(), (UElement)node, (Location)this.context.getLocation(node), (String)SwitchUsageCodeDetector.USING_CORE_SWITCH_DESCRIPTION, null, (int)16, null);
            }
        }
    }
}

